/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.fog.environment;

import javax.annotation.Nullable;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.fog.FogData;
import net.minecraft.client.renderer.fog.environment.AirBasedFogEnvironment;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;

public class AtmosphericFogEnvironment
extends AirBasedFogEnvironment {
    private static final int MIN_RAIN_FOG_SKY_LIGHT = 8;
    private static final float RAIN_FOG_START_OFFSET = -160.0f;
    private static final float RAIN_FOG_END_OFFSET = -256.0f;
    private float rainFogMultiplier;

    @Override
    public void setupFog(FogData p_423515_, Entity p_423566_, BlockPos p_423678_, ClientLevel p_423511_, float p_423456_, DeltaTracker p_423432_) {
        Biome $$6 = p_423511_.getBiome(p_423678_).value();
        float $$7 = p_423432_.getGameTimeDeltaTicks();
        boolean $$8 = $$6.hasPrecipitation();
        float $$9 = Mth.clamp(((float)p_423511_.getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(p_423678_) - 8.0f) / 7.0f, 0.0f, 1.0f);
        float $$10 = p_423511_.getRainLevel(p_423432_.getGameTimeDeltaPartialTick(false)) * $$9 * ($$8 ? 1.0f : 0.5f);
        this.rainFogMultiplier += ($$10 - this.rainFogMultiplier) * $$7 * 0.2f;
        p_423515_.environmentalStart = this.rainFogMultiplier * -160.0f;
        p_423515_.environmentalEnd = 1024.0f + -256.0f * this.rainFogMultiplier;
        p_423515_.skyEnd = p_423456_;
        p_423515_.cloudEnd = Minecraft.getInstance().options.cloudRange().get() * 16;
    }

    @Override
    public boolean isApplicable(@Nullable FogType p_423642_, Entity p_423662_) {
        return p_423642_ == FogType.ATMOSPHERIC;
    }
}

