/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public class LivingEntityEmissiveLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final ResourceLocation texture;
    private final AlphaFunction<S> alphaFunction;
    private final DrawSelector<S, M> drawSelector;
    private final Function<ResourceLocation, RenderType> bufferProvider;
    private final boolean alwaysVisible;

    public LivingEntityEmissiveLayer(RenderLayerParent<S, M> p_379642_, ResourceLocation p_379818_, AlphaFunction<S> p_380124_, DrawSelector<S, M> p_379846_, Function<ResourceLocation, RenderType> p_380046_, boolean p_388482_) {
        super(p_379642_);
        this.texture = p_379818_;
        this.alphaFunction = p_380124_;
        this.drawSelector = p_379846_;
        this.bufferProvider = p_380046_;
        this.alwaysVisible = p_388482_;
    }

    @Override
    public void render(PoseStack p_380055_, MultiBufferSource p_379364_, int p_380349_, S p_379499_, float p_379823_, float p_380346_) {
        if (((LivingEntityRenderState)p_379499_).isInvisible && !this.alwaysVisible) {
            return;
        }
        if (!this.onlyDrawSelectedParts(p_379499_)) {
            return;
        }
        VertexConsumer $$6 = p_379364_.getBuffer(this.bufferProvider.apply(this.texture));
        float $$7 = this.alphaFunction.apply(p_379499_, ((LivingEntityRenderState)p_379499_).ageInTicks);
        int $$8 = ARGB.color(Mth.floor($$7 * 255.0f), 255, 255, 255);
        ((Model)this.getParentModel()).renderToBuffer(p_380055_, $$6, p_380349_, LivingEntityRenderer.getOverlayCoords(p_379499_, 0.0f), $$8);
        this.resetDrawForAllParts();
    }

    private boolean onlyDrawSelectedParts(S p_379774_) {
        List<ModelPart> $$1 = this.drawSelector.getPartsToDraw(this.getParentModel(), p_379774_);
        if ($$1.isEmpty()) {
            return false;
        }
        ((Model)this.getParentModel()).allParts().forEach(p_379465_ -> {
            p_379465_.skipDraw = true;
        });
        $$1.forEach(p_379767_ -> {
            p_379767_.skipDraw = false;
        });
        return true;
    }

    private void resetDrawForAllParts() {
        ((Model)this.getParentModel()).allParts().forEach(p_379339_ -> {
            p_379339_.skipDraw = false;
        });
    }

    public static interface AlphaFunction<S extends LivingEntityRenderState> {
        public float apply(S var1, float var2);
    }

    public static interface DrawSelector<S extends LivingEntityRenderState, M extends EntityModel<S>> {
        public List<ModelPart> getPartsToDraw(M var1, S var2);
    }
}

