/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;

public class EquipmentLayerRenderer {
    private static final int NO_LAYER_COLOR = 0;
    private final EquipmentAssetManager equipmentAssets;
    private final Function<LayerTextureKey, ResourceLocation> layerTextureLookup;
    private final Function<TrimSpriteKey, TextureAtlasSprite> trimSpriteLookup;

    public EquipmentLayerRenderer(EquipmentAssetManager p_388621_, TextureAtlas p_371221_) {
        this.equipmentAssets = p_388621_;
        this.layerTextureLookup = Util.memoize(p_386235_ -> p_386235_.layer.getTextureLocation(p_386235_.layerType));
        this.trimSpriteLookup = Util.memoize(p_399319_ -> p_371221_.getSprite(p_399319_.spriteId()));
    }

    public void renderLayers(EquipmentClientInfo.LayerType p_388694_, ResourceKey<EquipmentAsset> p_386937_, Model p_371498_, ItemStack p_371902_, PoseStack p_371937_, MultiBufferSource p_371457_, int p_371495_) {
        this.renderLayers(p_388694_, p_386937_, p_371498_, p_371902_, p_371937_, p_371457_, p_371495_, null);
    }

    public void renderLayers(EquipmentClientInfo.LayerType p_387484_, ResourceKey<EquipmentAsset> p_387603_, Model p_371731_, ItemStack p_371670_, PoseStack p_371767_, MultiBufferSource p_371286_, int p_371309_, @Nullable ResourceLocation p_371639_) {
        List<EquipmentClientInfo.Layer> $$8 = this.equipmentAssets.get(p_387603_).getLayers(p_387484_);
        if ($$8.isEmpty()) {
            return;
        }
        int $$9 = DyedItemColor.getOrDefault(p_371670_, 0);
        boolean $$10 = p_371670_.hasFoil();
        for (EquipmentClientInfo.Layer $$11 : $$8) {
            int $$12 = EquipmentLayerRenderer.getColorForLayer($$11, $$9);
            if ($$12 == 0) continue;
            ResourceLocation $$13 = $$11.usePlayerTexture() && p_371639_ != null ? p_371639_ : this.layerTextureLookup.apply(new LayerTextureKey(p_387484_, $$11));
            VertexConsumer $$14 = ItemRenderer.getArmorFoilBuffer(p_371286_, RenderType.armorCutoutNoCull($$13), $$10);
            p_371731_.renderToBuffer(p_371767_, $$14, p_371309_, OverlayTexture.NO_OVERLAY, $$12);
            $$10 = false;
        }
        ArmorTrim $$15 = p_371670_.get(DataComponents.TRIM);
        if ($$15 != null) {
            TextureAtlasSprite $$16 = this.trimSpriteLookup.apply(new TrimSpriteKey($$15, p_387484_, p_387603_));
            VertexConsumer $$17 = $$16.wrap(p_371286_.getBuffer(Sheets.armorTrimsSheet($$15.pattern().value().decal())));
            p_371731_.renderToBuffer(p_371767_, $$17, p_371309_, OverlayTexture.NO_OVERLAY);
        }
    }

    private static int getColorForLayer(EquipmentClientInfo.Layer p_386482_, int p_371443_) {
        Optional<EquipmentClientInfo.Dyeable> $$2 = p_386482_.dyeable();
        if ($$2.isPresent()) {
            int $$3 = $$2.get().colorWhenUndyed().map(ARGB::opaque).orElse(0);
            return p_371443_ != 0 ? p_371443_ : $$3;
        }
        return -1;
    }

    record LayerTextureKey(EquipmentClientInfo.LayerType layerType, EquipmentClientInfo.Layer layer) {
    }

    record TrimSpriteKey(ArmorTrim trim, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAssetId) {
        public ResourceLocation spriteId() {
            return this.trim.layerAssetId(this.layerType.trimAssetPrefix(), this.equipmentAssetId);
        }
    }
}

