/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ThrownTridentRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.projectile.ThrownTrident;
import org.joml.Quaternionfc;

public class ThrownTridentRenderer
extends EntityRenderer<ThrownTrident, ThrownTridentRenderState> {
    public static final ResourceLocation TRIDENT_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/trident.png");
    private final TridentModel model;

    public ThrownTridentRenderer(EntityRendererProvider.Context p_174420_) {
        super(p_174420_);
        this.model = new TridentModel(p_174420_.bakeLayer(ModelLayers.TRIDENT));
    }

    @Override
    public void render(ThrownTridentRenderState p_361109_, PoseStack p_116114_, MultiBufferSource p_116115_, int p_116116_) {
        p_116114_.pushPose();
        p_116114_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(p_361109_.yRot - 90.0f));
        p_116114_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(p_361109_.xRot + 90.0f));
        VertexConsumer $$4 = ItemRenderer.getFoilBuffer(p_116115_, this.model.renderType(TRIDENT_LOCATION), false, p_361109_.isFoil);
        this.model.renderToBuffer(p_116114_, $$4, p_116116_, OverlayTexture.NO_OVERLAY);
        p_116114_.popPose();
        super.render(p_361109_, p_116114_, p_116115_, p_116116_);
    }

    @Override
    public ThrownTridentRenderState createRenderState() {
        return new ThrownTridentRenderState();
    }

    @Override
    public void extractRenderState(ThrownTrident p_362162_, ThrownTridentRenderState p_360843_, float p_361066_) {
        super.extractRenderState(p_362162_, p_360843_, p_361066_);
        p_360843_.yRot = p_362162_.getYRot(p_361066_);
        p_360843_.xRot = p_362162_.getXRot(p_361066_);
        p_360843_.isFoil = p_362162_.isFoil();
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

