/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.RavagerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.monster.Ravager;

public class RavagerRenderer
extends MobRenderer<Ravager, RavagerRenderState, RavagerModel> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/illager/ravager.png");

    public RavagerRenderer(EntityRendererProvider.Context p_174362_) {
        super(p_174362_, new RavagerModel(p_174362_.bakeLayer(ModelLayers.RAVAGER)), 1.1f);
    }

    @Override
    public ResourceLocation getTextureLocation(RavagerRenderState p_363518_) {
        return TEXTURE_LOCATION;
    }

    @Override
    public RavagerRenderState createRenderState() {
        return new RavagerRenderState();
    }

    @Override
    public void extractRenderState(Ravager p_361648_, RavagerRenderState p_360518_, float p_364693_) {
        super.extractRenderState(p_361648_, p_360518_, p_364693_);
        p_360518_.stunnedTicksRemaining = (float)p_361648_.getStunnedTick() > 0.0f ? (float)p_361648_.getStunnedTick() - p_364693_ : 0.0f;
        p_360518_.attackTicksRemaining = (float)p_361648_.getAttackTick() > 0.0f ? (float)p_361648_.getAttackTick() - p_364693_ : 0.0f;
        p_360518_.roarAnimation = p_361648_.getRoarTick() > 0 ? ((float)(20 - p_361648_.getRoarTick()) + p_364693_) / 20.0f : 0.0f;
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((RavagerRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

