/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.PandaHoldsItemLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HoldingEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PandaRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Panda;
import org.joml.Quaternionfc;

public class PandaRenderer
extends AgeableMobRenderer<Panda, PandaRenderState, PandaModel> {
    private static final Map<Panda.Gene, ResourceLocation> TEXTURES = Maps.newEnumMap(Map.of(Panda.Gene.NORMAL, ResourceLocation.withDefaultNamespace("textures/entity/panda/panda.png"), Panda.Gene.LAZY, ResourceLocation.withDefaultNamespace("textures/entity/panda/lazy_panda.png"), Panda.Gene.WORRIED, ResourceLocation.withDefaultNamespace("textures/entity/panda/worried_panda.png"), Panda.Gene.PLAYFUL, ResourceLocation.withDefaultNamespace("textures/entity/panda/playful_panda.png"), Panda.Gene.BROWN, ResourceLocation.withDefaultNamespace("textures/entity/panda/brown_panda.png"), Panda.Gene.WEAK, ResourceLocation.withDefaultNamespace("textures/entity/panda/weak_panda.png"), Panda.Gene.AGGRESSIVE, ResourceLocation.withDefaultNamespace("textures/entity/panda/aggressive_panda.png")));

    public PandaRenderer(EntityRendererProvider.Context p_174334_) {
        super(p_174334_, new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA)), new PandaModel(p_174334_.bakeLayer(ModelLayers.PANDA_BABY)), 0.9f);
        this.addLayer(new PandaHoldsItemLayer(this));
    }

    @Override
    public ResourceLocation getTextureLocation(PandaRenderState p_364827_) {
        return TEXTURES.getOrDefault(p_364827_.variant, TEXTURES.get(Panda.Gene.NORMAL));
    }

    @Override
    public PandaRenderState createRenderState() {
        return new PandaRenderState();
    }

    @Override
    public void extractRenderState(Panda p_363780_, PandaRenderState p_363283_, float p_360846_) {
        super.extractRenderState(p_363780_, p_363283_, p_360846_);
        HoldingEntityRenderState.extractHoldingEntityRenderState(p_363780_, p_363283_, this.itemModelResolver);
        p_363283_.variant = p_363780_.getVariant();
        p_363283_.isUnhappy = p_363780_.getUnhappyCounter() > 0;
        p_363283_.isSneezing = p_363780_.isSneezing();
        p_363283_.sneezeTime = p_363780_.getSneezeCounter();
        p_363283_.isEating = p_363780_.isEating();
        p_363283_.isScared = p_363780_.isScared();
        p_363283_.isSitting = p_363780_.isSitting();
        p_363283_.sitAmount = p_363780_.getSitAmount(p_360846_);
        p_363283_.lieOnBackAmount = p_363780_.getLieOnBackAmount(p_360846_);
        p_363283_.rollAmount = p_363780_.isBaby() ? 0.0f : p_363780_.getRollAmount(p_360846_);
        p_363283_.rollTime = p_363780_.rollCounter > 0 ? (float)p_363780_.rollCounter + p_360846_ : 0.0f;
    }

    @Override
    protected void setupRotations(PandaRenderState p_362586_, PoseStack p_115634_, float p_115635_, float p_115636_) {
        float $$26;
        float $$24;
        super.setupRotations(p_362586_, p_115634_, p_115635_, p_115636_);
        if (p_362586_.rollTime > 0.0f) {
            float $$8;
            float $$4 = Mth.frac(p_362586_.rollTime);
            int $$5 = Mth.floor(p_362586_.rollTime);
            int $$6 = $$5 + 1;
            float $$7 = 7.0f;
            float f = $$8 = p_362586_.isBaby ? 0.3f : 0.8f;
            if ((float)$$5 < 8.0f) {
                float $$9 = 90.0f * (float)$$5 / 7.0f;
                float $$10 = 90.0f * (float)$$6 / 7.0f;
                float $$11 = this.getAngle($$9, $$10, $$6, $$4, 8.0f);
                p_115634_.translate(0.0f, ($$8 + 0.2f) * ($$11 / 90.0f), 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-$$11));
            } else if ((float)$$5 < 16.0f) {
                float $$12 = ((float)$$5 - 8.0f) / 7.0f;
                float $$13 = 90.0f + 90.0f * $$12;
                float $$14 = 90.0f + 90.0f * ((float)$$6 - 8.0f) / 7.0f;
                float $$15 = this.getAngle($$13, $$14, $$6, $$4, 16.0f);
                p_115634_.translate(0.0f, $$8 + 0.2f + ($$8 - 0.2f) * ($$15 - 90.0f) / 90.0f, 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-$$15));
            } else if ((float)$$5 < 24.0f) {
                float $$16 = ((float)$$5 - 16.0f) / 7.0f;
                float $$17 = 180.0f + 90.0f * $$16;
                float $$18 = 180.0f + 90.0f * ((float)$$6 - 16.0f) / 7.0f;
                float $$19 = this.getAngle($$17, $$18, $$6, $$4, 24.0f);
                p_115634_.translate(0.0f, $$8 + $$8 * (270.0f - $$19) / 90.0f, 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-$$19));
            } else if ($$5 < 32) {
                float $$20 = ((float)$$5 - 24.0f) / 7.0f;
                float $$21 = 270.0f + 90.0f * $$20;
                float $$22 = 270.0f + 90.0f * ((float)$$6 - 24.0f) / 7.0f;
                float $$23 = this.getAngle($$21, $$22, $$6, $$4, 32.0f);
                p_115634_.translate(0.0f, $$8 * ((360.0f - $$23) / 90.0f), 0.0f);
                p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-$$23));
            }
        }
        if (($$24 = p_362586_.sitAmount) > 0.0f) {
            p_115634_.translate(0.0f, 0.8f * $$24, 0.0f);
            p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp($$24, p_362586_.xRot, p_362586_.xRot + 90.0f)));
            p_115634_.translate(0.0f, -1.0f * $$24, 0.0f);
            if (p_362586_.isScared) {
                float $$25 = (float)(Math.cos(p_362586_.ageInTicks * 1.25f) * Math.PI * (double)0.05f);
                p_115634_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$25));
                if (p_362586_.isBaby) {
                    p_115634_.translate(0.0f, 0.8f, 0.55f);
                }
            }
        }
        if (($$26 = p_362586_.lieOnBackAmount) > 0.0f) {
            float $$27 = p_362586_.isBaby ? 0.5f : 1.3f;
            p_115634_.translate(0.0f, $$27 * $$26, 0.0f);
            p_115634_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp($$26, p_362586_.xRot, p_362586_.xRot + 180.0f)));
        }
    }

    private float getAngle(float p_115625_, float p_115626_, int p_115627_, float p_115628_, float p_115629_) {
        if ((float)p_115627_ < p_115629_) {
            return Mth.lerp(p_115628_, p_115625_, p_115626_);
        }
        return p_115625_;
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((PandaRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

