/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.PaintingRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.Level;
import org.joml.Quaternionfc;

public class PaintingRenderer
extends EntityRenderer<Painting, PaintingRenderState> {
    public PaintingRenderer(EntityRendererProvider.Context p_174332_) {
        super(p_174332_);
    }

    @Override
    public void render(PaintingRenderState p_363740_, PoseStack p_115533_, MultiBufferSource p_115534_, int p_115535_) {
        PaintingVariant $$4 = p_363740_.variant;
        if ($$4 == null) {
            return;
        }
        p_115533_.pushPose();
        p_115533_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180 - p_363740_.direction.get2DDataValue() * 90));
        PaintingTextureManager $$5 = Minecraft.getInstance().getPaintingTextures();
        TextureAtlasSprite $$6 = $$5.getBackSprite();
        VertexConsumer $$7 = p_115534_.getBuffer(RenderType.entitySolidZOffsetForward($$6.atlasLocation()));
        this.renderPainting(p_115533_, $$7, p_363740_.lightCoords, $$4.width(), $$4.height(), $$5.get($$4), $$6);
        p_115533_.popPose();
        super.render(p_363740_, p_115533_, p_115534_, p_115535_);
    }

    @Override
    public PaintingRenderState createRenderState() {
        return new PaintingRenderState();
    }

    @Override
    public void extractRenderState(Painting p_360735_, PaintingRenderState p_364263_, float p_360460_) {
        super.extractRenderState(p_360735_, p_364263_, p_360460_);
        Direction $$3 = p_360735_.getDirection();
        PaintingVariant $$4 = p_360735_.getVariant().value();
        p_364263_.direction = $$3;
        p_364263_.variant = $$4;
        int $$5 = $$4.width();
        int $$6 = $$4.height();
        if (p_364263_.lightCoords.length != $$5 * $$6) {
            p_364263_.lightCoords = new int[$$5 * $$6];
        }
        float $$7 = (float)(-$$5) / 2.0f;
        float $$8 = (float)(-$$6) / 2.0f;
        Level $$9 = p_360735_.level();
        for (int $$10 = 0; $$10 < $$6; ++$$10) {
            for (int $$11 = 0; $$11 < $$5; ++$$11) {
                float $$12 = (float)$$11 + $$7 + 0.5f;
                float $$13 = (float)$$10 + $$8 + 0.5f;
                int $$14 = p_360735_.getBlockX();
                int $$15 = Mth.floor(p_360735_.getY() + (double)$$13);
                int $$16 = p_360735_.getBlockZ();
                switch ($$3) {
                    case NORTH: {
                        $$14 = Mth.floor(p_360735_.getX() + (double)$$12);
                        break;
                    }
                    case WEST: {
                        $$16 = Mth.floor(p_360735_.getZ() - (double)$$12);
                        break;
                    }
                    case SOUTH: {
                        $$14 = Mth.floor(p_360735_.getX() - (double)$$12);
                        break;
                    }
                    case EAST: {
                        $$16 = Mth.floor(p_360735_.getZ() + (double)$$12);
                    }
                }
                p_364263_.lightCoords[$$11 + $$10 * $$5] = LevelRenderer.getLightColor($$9, new BlockPos($$14, $$15, $$16));
            }
        }
    }

    private void renderPainting(PoseStack p_115559_, VertexConsumer p_115560_, int[] p_363896_, int p_115562_, int p_115563_, TextureAtlasSprite p_115564_, TextureAtlasSprite p_115565_) {
        PoseStack.Pose $$7 = p_115559_.last();
        float $$8 = (float)(-p_115562_) / 2.0f;
        float $$9 = (float)(-p_115563_) / 2.0f;
        float $$10 = 0.03125f;
        float $$11 = p_115565_.getU0();
        float $$12 = p_115565_.getU1();
        float $$13 = p_115565_.getV0();
        float $$14 = p_115565_.getV1();
        float $$15 = p_115565_.getU0();
        float $$16 = p_115565_.getU1();
        float $$17 = p_115565_.getV0();
        float $$18 = p_115565_.getV(0.0625f);
        float $$19 = p_115565_.getU0();
        float $$20 = p_115565_.getU(0.0625f);
        float $$21 = p_115565_.getV0();
        float $$22 = p_115565_.getV1();
        double $$23 = 1.0 / (double)p_115562_;
        double $$24 = 1.0 / (double)p_115563_;
        for (int $$25 = 0; $$25 < p_115562_; ++$$25) {
            for (int $$26 = 0; $$26 < p_115563_; ++$$26) {
                float $$27 = $$8 + (float)($$25 + 1);
                float $$28 = $$8 + (float)$$25;
                float $$29 = $$9 + (float)($$26 + 1);
                float $$30 = $$9 + (float)$$26;
                int $$31 = p_363896_[$$25 + $$26 * p_115562_];
                float $$32 = p_115564_.getU((float)($$23 * (double)(p_115562_ - $$25)));
                float $$33 = p_115564_.getU((float)($$23 * (double)(p_115562_ - ($$25 + 1))));
                float $$34 = p_115564_.getV((float)($$24 * (double)(p_115563_ - $$26)));
                float $$35 = p_115564_.getV((float)($$24 * (double)(p_115563_ - ($$26 + 1))));
                this.vertex($$7, p_115560_, $$27, $$30, $$33, $$34, -0.03125f, 0, 0, -1, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$32, $$34, -0.03125f, 0, 0, -1, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$32, $$35, -0.03125f, 0, 0, -1, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$33, $$35, -0.03125f, 0, 0, -1, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$12, $$13, 0.03125f, 0, 0, 1, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$11, $$13, 0.03125f, 0, 0, 1, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$11, $$14, 0.03125f, 0, 0, 1, $$31);
                this.vertex($$7, p_115560_, $$27, $$30, $$12, $$14, 0.03125f, 0, 0, 1, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$15, $$17, -0.03125f, 0, 1, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$16, $$17, -0.03125f, 0, 1, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$16, $$18, 0.03125f, 0, 1, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$15, $$18, 0.03125f, 0, 1, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$30, $$15, $$17, 0.03125f, 0, -1, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$16, $$17, 0.03125f, 0, -1, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$16, $$18, -0.03125f, 0, -1, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$30, $$15, $$18, -0.03125f, 0, -1, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$20, $$21, 0.03125f, -1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$30, $$20, $$22, 0.03125f, -1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$30, $$19, $$22, -0.03125f, -1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$27, $$29, $$19, $$21, -0.03125f, -1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$20, $$21, -0.03125f, 1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$20, $$22, -0.03125f, 1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$30, $$19, $$22, 0.03125f, 1, 0, 0, $$31);
                this.vertex($$7, p_115560_, $$28, $$29, $$19, $$21, 0.03125f, 1, 0, 0, $$31);
            }
        }
    }

    private void vertex(PoseStack.Pose p_323991_, VertexConsumer p_254114_, float p_254164_, float p_254459_, float p_254183_, float p_253615_, float p_254448_, int p_253660_, int p_254342_, int p_253757_, int p_254101_) {
        p_254114_.addVertex(p_323991_, p_254164_, p_254459_, p_254448_).setColor(-1).setUv(p_254183_, p_253615_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254101_).setNormal(p_323991_, p_253660_, p_254342_, p_253757_);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

