/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SlimeRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.MagmaCube;

public class MagmaCubeRenderer
extends MobRenderer<MagmaCube, SlimeRenderState, LavaSlimeModel> {
    private static final ResourceLocation MAGMACUBE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/slime/magmacube.png");

    public MagmaCubeRenderer(EntityRendererProvider.Context p_174298_) {
        super(p_174298_, new LavaSlimeModel(p_174298_.bakeLayer(ModelLayers.MAGMA_CUBE)), 0.25f);
    }

    @Override
    protected int getBlockLightLevel(MagmaCube p_115399_, BlockPos p_115400_) {
        return 15;
    }

    @Override
    public ResourceLocation getTextureLocation(SlimeRenderState p_361835_) {
        return MAGMACUBE_LOCATION;
    }

    @Override
    public SlimeRenderState createRenderState() {
        return new SlimeRenderState();
    }

    @Override
    public void extractRenderState(MagmaCube p_362519_, SlimeRenderState p_361851_, float p_361242_) {
        super.extractRenderState(p_362519_, p_361851_, p_361242_);
        p_361851_.squish = Mth.lerp(p_361242_, p_362519_.oSquish, p_362519_.squish);
        p_361851_.size = p_362519_.getSize();
    }

    @Override
    protected float getShadowRadius(SlimeRenderState p_382806_) {
        return (float)p_382806_.size * 0.25f;
    }

    @Override
    protected void scale(SlimeRenderState p_362807_, PoseStack p_115390_) {
        int $$2 = p_362807_.size;
        float $$3 = p_362807_.squish / ((float)$$2 * 0.5f + 1.0f);
        float $$4 = 1.0f / ($$3 + 1.0f);
        p_115390_.scale($$4 * (float)$$2, 1.0f / $$4 * (float)$$2, $$4 * (float)$$2);
    }

    @Override
    protected /* synthetic */ float getShadowRadius(LivingEntityRenderState livingEntityRenderState) {
        return this.getShadowRadius((SlimeRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((SlimeRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
        return this.getShadowRadius((SlimeRenderState)entityRenderState);
    }
}

