/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.joml.Quaternionfc;

public abstract class LivingEntityRenderer<T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>>
extends EntityRenderer<T, S>
implements RenderLayerParent<S, M> {
    private static final float EYE_BED_OFFSET = 0.1f;
    protected M model;
    protected final ItemModelResolver itemModelResolver;
    protected final List<RenderLayer<S, M>> layers = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.itemModelResolver = p_174289_.getItemModelResolver();
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    protected final boolean addLayer(RenderLayer<S, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    protected AABB getBoundingBoxForCulling(T p_360864_) {
        AABB $$1 = super.getBoundingBoxForCulling(p_360864_);
        if (((LivingEntity)p_360864_).getItemBySlot(EquipmentSlot.HEAD).is(Items.DRAGON_HEAD)) {
            float $$2 = 0.5f;
            return $$1.inflate(0.5, 0.5, 0.5);
        }
        return $$1;
    }

    @Override
    public void render(S p_361886_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction $$4;
        p_115311_.pushPose();
        if (((LivingEntityRenderState)p_361886_).hasPose(Pose.SLEEPING) && ($$4 = ((LivingEntityRenderState)p_361886_).bedOrientation) != null) {
            float $$5 = ((LivingEntityRenderState)p_361886_).eyeHeight - 0.1f;
            p_115311_.translate((float)(-$$4.getStepX()) * $$5, 0.0f, (float)(-$$4.getStepZ()) * $$5);
        }
        float $$6 = ((LivingEntityRenderState)p_361886_).scale;
        p_115311_.scale($$6, $$6, $$6);
        this.setupRotations(p_361886_, p_115311_, ((LivingEntityRenderState)p_361886_).bodyRot, $$6);
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_361886_, p_115311_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        ((EntityModel)this.model).setupAnim(p_361886_);
        boolean $$7 = this.isBodyVisible(p_361886_);
        boolean $$8 = !$$7 && !((LivingEntityRenderState)p_361886_).isInvisibleToPlayer;
        RenderType $$9 = this.getRenderType(p_361886_, $$7, $$8, ((LivingEntityRenderState)p_361886_).appearsGlowing);
        if ($$9 != null) {
            VertexConsumer $$10 = p_115312_.getBuffer($$9);
            int $$11 = LivingEntityRenderer.getOverlayCoords(p_361886_, this.getWhiteOverlayProgress(p_361886_));
            int $$12 = $$8 ? 0x26FFFFFF : -1;
            int $$13 = ARGB.multiply($$12, this.getModelTint(p_361886_));
            ((Model)this.model).renderToBuffer(p_115311_, $$10, p_115313_, $$11, $$13);
        }
        if (this.shouldRenderLayers(p_361886_)) {
            for (RenderLayer<S, M> $$14 : this.layers) {
                $$14.render(p_115311_, p_115312_, p_115313_, p_361886_, ((LivingEntityRenderState)p_361886_).yRot, ((LivingEntityRenderState)p_361886_).xRot);
            }
        }
        p_115311_.popPose();
        super.render(p_361886_, p_115311_, p_115312_, p_115313_);
    }

    protected boolean shouldRenderLayers(S p_364697_) {
        return true;
    }

    protected int getModelTint(S p_360502_) {
        return -1;
    }

    public abstract ResourceLocation getTextureLocation(S var1);

    @Nullable
    protected RenderType getRenderType(S p_360858_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation $$4 = this.getTextureLocation(p_360858_);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull($$4);
        }
        if (p_115323_) {
            return ((Model)this.model).renderType($$4);
        }
        if (p_115325_) {
            return RenderType.outline($$4);
        }
        return null;
    }

    public static int getOverlayCoords(LivingEntityRenderState p_362833_, float p_115340_) {
        return OverlayTexture.pack(OverlayTexture.u(p_115340_), OverlayTexture.v(p_362833_.hasRedOverlay));
    }

    protected boolean isBodyVisible(S p_361327_) {
        return !((LivingEntityRenderState)p_361327_).isInvisible;
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(S p_361234_) {
        return ((LivingEntityRenderState)p_361234_).isFullyFrozen;
    }

    protected void setupRotations(S p_364714_, PoseStack p_115318_, float p_115319_, float p_115320_) {
        if (this.isShaking(p_364714_)) {
            p_115319_ += (float)(Math.cos((float)Mth.floor(((LivingEntityRenderState)p_364714_).ageInTicks) * 3.25f) * Math.PI * (double)0.4f);
        }
        if (!((LivingEntityRenderState)p_364714_).hasPose(Pose.SLEEPING)) {
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - p_115319_));
        }
        if (((LivingEntityRenderState)p_364714_).deathTime > 0.0f) {
            float $$4 = (((LivingEntityRenderState)p_364714_).deathTime - 1.0f) / 20.0f * 1.6f;
            if (($$4 = Mth.sqrt($$4)) > 1.0f) {
                $$4 = 1.0f;
            }
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees($$4 * this.getFlipDegrees()));
        } else if (((LivingEntityRenderState)p_364714_).isAutoSpinAttack) {
            p_115318_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - ((LivingEntityRenderState)p_364714_).xRot));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(((LivingEntityRenderState)p_364714_).ageInTicks * -75.0f));
        } else if (((LivingEntityRenderState)p_364714_).hasPose(Pose.SLEEPING)) {
            Direction $$5 = ((LivingEntityRenderState)p_364714_).bedOrientation;
            float $$6 = $$5 != null ? LivingEntityRenderer.sleepDirectionToRotation($$5) : p_115319_;
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$6));
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(this.getFlipDegrees()));
            p_115318_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
        } else if (((LivingEntityRenderState)p_364714_).isUpsideDown) {
            p_115318_.translate(0.0f, (((LivingEntityRenderState)p_364714_).boundingBoxHeight + 0.1f) / p_115320_, 0.0f);
            p_115318_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getFlipDegrees() {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(S p_362441_) {
        return 0.0f;
    }

    protected void scale(S p_362272_, PoseStack p_115315_) {
    }

    @Override
    protected boolean shouldShowName(T p_363517_, double p_365448_) {
        boolean $$5;
        if (((Entity)p_363517_).isDiscrete()) {
            float $$2 = 32.0f;
            if (p_365448_ >= 1024.0) {
                return false;
            }
        }
        Minecraft $$3 = Minecraft.getInstance();
        LocalPlayer $$4 = $$3.player;
        boolean bl = $$5 = !((Entity)p_363517_).isInvisibleTo($$4);
        if (p_363517_ != $$4) {
            PlayerTeam $$6 = ((Entity)p_363517_).getTeam();
            PlayerTeam $$7 = $$4.getTeam();
            if ($$6 != null) {
                Team.Visibility $$8 = ((Team)$$6).getNameTagVisibility();
                switch ($$8) {
                    case ALWAYS: {
                        return $$5;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return $$7 == null ? $$5 : $$6.isAlliedTo($$7) && (((Team)$$6).canSeeFriendlyInvisibles() || $$5);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return $$7 == null ? $$5 : !$$6.isAlliedTo($$7) && $$5;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && p_363517_ != $$3.getCameraEntity() && $$5 && !((Entity)p_363517_).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String $$1;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals($$1 = ChatFormatting.stripFormatting(p_194454_.getName().getString())) || "Grumm".equals($$1))) {
            Player $$2;
            return !(p_194454_ instanceof Player) || ($$2 = (Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE);
        }
        return false;
    }

    @Override
    protected float getShadowRadius(S p_361012_) {
        return super.getShadowRadius(p_361012_) * ((LivingEntityRenderState)p_361012_).scale;
    }

    @Override
    public void extractRenderState(T p_362733_, S p_360515_, float p_361157_) {
        BlockItem $$6;
        super.extractRenderState(p_362733_, p_360515_, p_361157_);
        float $$3 = Mth.rotLerp(p_361157_, ((LivingEntity)p_362733_).yHeadRotO, ((LivingEntity)p_362733_).yHeadRot);
        ((LivingEntityRenderState)p_360515_).bodyRot = LivingEntityRenderer.solveBodyRot(p_362733_, $$3, p_361157_);
        ((LivingEntityRenderState)p_360515_).yRot = Mth.wrapDegrees($$3 - ((LivingEntityRenderState)p_360515_).bodyRot);
        ((LivingEntityRenderState)p_360515_).xRot = ((Entity)p_362733_).getXRot(p_361157_);
        ((LivingEntityRenderState)p_360515_).customName = ((Entity)p_362733_).getCustomName();
        ((LivingEntityRenderState)p_360515_).isUpsideDown = LivingEntityRenderer.isEntityUpsideDown(p_362733_);
        if (((LivingEntityRenderState)p_360515_).isUpsideDown) {
            ((LivingEntityRenderState)p_360515_).xRot *= -1.0f;
            ((LivingEntityRenderState)p_360515_).yRot *= -1.0f;
        }
        if (!((Entity)p_362733_).isPassenger() && ((LivingEntity)p_362733_).isAlive()) {
            ((LivingEntityRenderState)p_360515_).walkAnimationPos = ((LivingEntity)p_362733_).walkAnimation.position(p_361157_);
            ((LivingEntityRenderState)p_360515_).walkAnimationSpeed = ((LivingEntity)p_362733_).walkAnimation.speed(p_361157_);
        } else {
            ((LivingEntityRenderState)p_360515_).walkAnimationPos = 0.0f;
            ((LivingEntityRenderState)p_360515_).walkAnimationSpeed = 0.0f;
        }
        Entity entity = ((Entity)p_362733_).getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity $$4 = (LivingEntity)entity;
            ((LivingEntityRenderState)p_360515_).wornHeadAnimationPos = $$4.walkAnimation.position(p_361157_);
        } else {
            ((LivingEntityRenderState)p_360515_).wornHeadAnimationPos = ((LivingEntityRenderState)p_360515_).walkAnimationPos;
        }
        ((LivingEntityRenderState)p_360515_).scale = ((LivingEntity)p_362733_).getScale();
        ((LivingEntityRenderState)p_360515_).ageScale = ((LivingEntity)p_362733_).getAgeScale();
        ((LivingEntityRenderState)p_360515_).pose = ((Entity)p_362733_).getPose();
        ((LivingEntityRenderState)p_360515_).bedOrientation = ((LivingEntity)p_362733_).getBedOrientation();
        if (((LivingEntityRenderState)p_360515_).bedOrientation != null) {
            ((LivingEntityRenderState)p_360515_).eyeHeight = ((Entity)p_362733_).getEyeHeight(Pose.STANDING);
        }
        ((LivingEntityRenderState)p_360515_).isFullyFrozen = ((Entity)p_362733_).isFullyFrozen();
        ((LivingEntityRenderState)p_360515_).isBaby = ((LivingEntity)p_362733_).isBaby();
        ((LivingEntityRenderState)p_360515_).isInWater = ((Entity)p_362733_).isInWater();
        ((LivingEntityRenderState)p_360515_).isAutoSpinAttack = ((LivingEntity)p_362733_).isAutoSpinAttack();
        ((LivingEntityRenderState)p_360515_).hasRedOverlay = ((LivingEntity)p_362733_).hurtTime > 0 || ((LivingEntity)p_362733_).deathTime > 0;
        ItemStack $$5 = ((LivingEntity)p_362733_).getItemBySlot(EquipmentSlot.HEAD);
        FeatureElement featureElement = $$5.getItem();
        if (featureElement instanceof BlockItem && (featureElement = ($$6 = (BlockItem)featureElement).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock $$7 = (AbstractSkullBlock)featureElement;
            ((LivingEntityRenderState)p_360515_).wornHeadType = $$7.getType();
            ((LivingEntityRenderState)p_360515_).wornHeadProfile = $$5.get(DataComponents.PROFILE);
            ((LivingEntityRenderState)p_360515_).headItem.clear();
        } else {
            ((LivingEntityRenderState)p_360515_).wornHeadType = null;
            ((LivingEntityRenderState)p_360515_).wornHeadProfile = null;
            if (!HumanoidArmorLayer.shouldRender($$5, EquipmentSlot.HEAD)) {
                this.itemModelResolver.updateForLiving(((LivingEntityRenderState)p_360515_).headItem, $$5, ItemDisplayContext.HEAD, (LivingEntity)p_362733_);
            } else {
                ((LivingEntityRenderState)p_360515_).headItem.clear();
            }
        }
        ((LivingEntityRenderState)p_360515_).deathTime = ((LivingEntity)p_362733_).deathTime > 0 ? (float)((LivingEntity)p_362733_).deathTime + p_361157_ : 0.0f;
        Minecraft $$8 = Minecraft.getInstance();
        ((LivingEntityRenderState)p_360515_).isInvisibleToPlayer = ((LivingEntityRenderState)p_360515_).isInvisible && ((Entity)p_362733_).isInvisibleTo($$8.player);
        ((LivingEntityRenderState)p_360515_).appearsGlowing = $$8.shouldEntityAppearGlowing((Entity)p_362733_);
    }

    @Override
    protected void extractAdditionalHitboxes(T p_412552_, ImmutableList.Builder<HitboxRenderState> p_412540_, float p_412715_) {
        AABB $$3 = ((Entity)p_412552_).getBoundingBox();
        float $$4 = 0.01f;
        HitboxRenderState $$5 = new HitboxRenderState($$3.minX - ((Entity)p_412552_).getX(), ((Entity)p_412552_).getEyeHeight() - 0.01f, $$3.minZ - ((Entity)p_412552_).getZ(), $$3.maxX - ((Entity)p_412552_).getX(), ((Entity)p_412552_).getEyeHeight() + 0.01f, $$3.maxZ - ((Entity)p_412552_).getZ(), 1.0f, 0.0f, 0.0f);
        p_412540_.add((Object)$$5);
    }

    private static float solveBodyRot(LivingEntity p_362839_, float p_361247_, float p_361564_) {
        Entity entity = p_362839_.getVehicle();
        if (entity instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)entity;
            float $$4 = Mth.rotLerp(p_361564_, $$3.yBodyRotO, $$3.yBodyRot);
            float $$5 = 85.0f;
            float $$6 = Mth.clamp(Mth.wrapDegrees(p_361247_ - $$4), -85.0f, 85.0f);
            $$4 = p_361247_ - $$6;
            if (Math.abs($$6) > 50.0f) {
                $$4 += $$6 * 0.2f;
            }
            return $$4;
        }
        return Mth.rotLerp(p_361564_, p_362839_.yBodyRotO, p_362839_.yBodyRot);
    }

    @Override
    protected /* synthetic */ float getShadowRadius(EntityRenderState entityRenderState) {
        return this.getShadowRadius((S)((LivingEntityRenderState)entityRenderState));
    }
}

