/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T, ItemFrameRenderState> {
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final ItemModelResolver itemModelResolver;
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public ItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemModelResolver = p_174204_.getItemModelResolver();
        this.mapRenderer = p_174204_.getMapRenderer();
        this.blockRenderer = p_174204_.getBlockRenderDispatcher();
    }

    @Override
    protected int getBlockLightLevel(T p_174216_, BlockPos p_174217_) {
        if (((Entity)p_174216_).getType() == EntityType.GLOW_ITEM_FRAME) {
            return Math.max(5, super.getBlockLightLevel(p_174216_, p_174217_));
        }
        return super.getBlockLightLevel(p_174216_, p_174217_);
    }

    @Override
    public void render(ItemFrameRenderState p_364723_, PoseStack p_115079_, MultiBufferSource p_115080_, int p_115081_) {
        float $$10;
        float $$9;
        super.render(p_364723_, p_115079_, p_115080_, p_115081_);
        p_115079_.pushPose();
        Direction $$4 = p_364723_.direction;
        Vec3 $$5 = this.getRenderOffset(p_364723_);
        p_115079_.translate(-$$5.x(), -$$5.y(), -$$5.z());
        double $$6 = 0.46875;
        p_115079_.translate((double)$$4.getStepX() * 0.46875, (double)$$4.getStepY() * 0.46875, (double)$$4.getStepZ() * 0.46875);
        if ($$4.getAxis().isHorizontal()) {
            float $$7 = 0.0f;
            float $$8 = 180.0f - $$4.toYRot();
        } else {
            $$9 = -90 * $$4.getAxisDirection().getStep();
            $$10 = 180.0f;
        }
        p_115079_.mulPose((Quaternionfc)Axis.XP.rotationDegrees($$9));
        p_115079_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$10));
        if (!p_364723_.isInvisible) {
            BlockState $$11 = BlockStateDefinitions.getItemFrameFakeState(p_364723_.isGlowFrame, p_364723_.mapId != null);
            BlockStateModel $$12 = this.blockRenderer.getBlockModel($$11);
            p_115079_.pushPose();
            p_115079_.translate(-0.5f, -0.5f, -0.5f);
            ModelBlockRenderer.renderModel(p_115079_.last(), p_115080_.getBuffer(RenderType.entitySolidZOffsetForward(TextureAtlas.LOCATION_BLOCKS)), $$12, 1.0f, 1.0f, 1.0f, p_115081_, OverlayTexture.NO_OVERLAY);
            p_115079_.popPose();
        }
        if (p_364723_.isInvisible) {
            p_115079_.translate(0.0f, 0.0f, 0.5f);
        } else {
            p_115079_.translate(0.0f, 0.0f, 0.4375f);
        }
        if (p_364723_.mapId != null) {
            int $$13 = p_364723_.rotation % 4 * 2;
            p_115079_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)$$13 * 360.0f / 8.0f));
            p_115079_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            float $$14 = 0.0078125f;
            p_115079_.scale(0.0078125f, 0.0078125f, 0.0078125f);
            p_115079_.translate(-64.0f, -64.0f, 0.0f);
            p_115079_.translate(0.0f, 0.0f, -1.0f);
            int $$15 = this.getLightCoords(p_364723_.isGlowFrame, 15728850, p_115081_);
            this.mapRenderer.render(p_364723_.mapRenderState, p_115079_, p_115080_, true, $$15);
        } else if (!p_364723_.item.isEmpty()) {
            p_115079_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)p_364723_.rotation * 360.0f / 8.0f));
            int $$16 = this.getLightCoords(p_364723_.isGlowFrame, 0xF000F0, p_115081_);
            p_115079_.scale(0.5f, 0.5f, 0.5f);
            p_364723_.item.render(p_115079_, p_115080_, $$16, OverlayTexture.NO_OVERLAY);
        }
        p_115079_.popPose();
    }

    private int getLightCoords(boolean p_364675_, int p_174210_, int p_174211_) {
        return p_364675_ ? p_174210_ : p_174211_;
    }

    @Override
    public Vec3 getRenderOffset(ItemFrameRenderState p_361106_) {
        return new Vec3((float)p_361106_.direction.getStepX() * 0.3f, -0.25, (float)p_361106_.direction.getStepZ() * 0.3f);
    }

    @Override
    protected boolean shouldShowName(T p_115091_, double p_361664_) {
        return Minecraft.renderNames() && this.entityRenderDispatcher.crosshairPickEntity == p_115091_ && ((ItemFrame)p_115091_).getItem().getCustomName() != null;
    }

    @Override
    protected Component getNameTag(T p_365048_) {
        return ((ItemFrame)p_365048_).getItem().getHoverName();
    }

    @Override
    public ItemFrameRenderState createRenderState() {
        return new ItemFrameRenderState();
    }

    @Override
    public void extractRenderState(T p_363125_, ItemFrameRenderState p_362907_, float p_364471_) {
        MapItemSavedData $$5;
        MapId $$4;
        super.extractRenderState(p_363125_, p_362907_, p_364471_);
        p_362907_.direction = ((HangingEntity)p_363125_).getDirection();
        ItemStack $$3 = ((ItemFrame)p_363125_).getItem();
        this.itemModelResolver.updateForNonLiving(p_362907_.item, $$3, ItemDisplayContext.FIXED, (Entity)p_363125_);
        p_362907_.rotation = ((ItemFrame)p_363125_).getRotation();
        p_362907_.isGlowFrame = ((Entity)p_363125_).getType() == EntityType.GLOW_ITEM_FRAME;
        p_362907_.mapId = null;
        if (!$$3.isEmpty() && ($$4 = ((ItemFrame)p_363125_).getFramedMapId($$3)) != null && ($$5 = ((Entity)p_363125_).level().getMapData($$4)) != null) {
            this.mapRenderer.extractRenderState($$4, $$5, p_362907_.mapRenderState);
            p_362907_.mapId = $$4;
        }
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ Component getNameTag(Entity entity) {
        return this.getNameTag((T)((ItemFrame)entity));
    }
}

