/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionfc;

public class ItemEntityRenderer
extends EntityRenderer<ItemEntity, ItemEntityRenderState> {
    private static final float ITEM_MIN_HOVER_HEIGHT = 0.0625f;
    private static final float ITEM_BUNDLE_OFFSET_SCALE = 0.15f;
    private static final float FLAT_ITEM_DEPTH_THRESHOLD = 0.0625f;
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    public ItemEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
        this.itemModelResolver = p_174198_.getItemModelResolver();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    public ItemEntityRenderState createRenderState() {
        return new ItemEntityRenderState();
    }

    @Override
    public void extractRenderState(ItemEntity p_362393_, ItemEntityRenderState p_361441_, float p_360849_) {
        super.extractRenderState(p_362393_, p_361441_, p_360849_);
        p_361441_.ageInTicks = (float)p_362393_.getAge() + p_360849_;
        p_361441_.bobOffset = p_362393_.bobOffs;
        p_361441_.extractItemGroupRenderState(p_362393_, p_362393_.getItem(), this.itemModelResolver);
    }

    @Override
    public void render(ItemEntityRenderState p_362172_, PoseStack p_115030_, MultiBufferSource p_115031_, int p_115032_) {
        if (p_362172_.item.isEmpty()) {
            return;
        }
        p_115030_.pushPose();
        AABB $$4 = p_362172_.item.getModelBoundingBox();
        float $$5 = -((float)$$4.minY) + 0.0625f;
        float $$6 = Mth.sin(p_362172_.ageInTicks / 10.0f + p_362172_.bobOffset) * 0.1f + 0.1f;
        p_115030_.translate(0.0f, $$6 + $$5, 0.0f);
        float $$7 = ItemEntity.getSpin(p_362172_.ageInTicks, p_362172_.bobOffset);
        p_115030_.mulPose((Quaternionfc)Axis.YP.rotation($$7));
        ItemEntityRenderer.renderMultipleFromCount(p_115030_, p_115031_, p_115032_, p_362172_, this.random, $$4);
        p_115030_.popPose();
        super.render(p_362172_, p_115030_, p_115031_, p_115032_);
    }

    public static void renderMultipleFromCount(PoseStack p_323763_, MultiBufferSource p_324606_, int p_323603_, ItemClusterRenderState p_388704_, RandomSource p_324507_) {
        ItemEntityRenderer.renderMultipleFromCount(p_323763_, p_324606_, p_323603_, p_388704_, p_324507_, p_388704_.item.getModelBoundingBox());
    }

    public static void renderMultipleFromCount(PoseStack p_404890_, MultiBufferSource p_405782_, int p_404762_, ItemClusterRenderState p_405697_, RandomSource p_404894_, AABB p_405524_) {
        int $$6 = p_405697_.count;
        if ($$6 == 0) {
            return;
        }
        p_404894_.setSeed(p_405697_.seed);
        ItemStackRenderState $$7 = p_405697_.item;
        float $$8 = (float)p_405524_.getZsize();
        if ($$8 > 0.0625f) {
            $$7.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
            for (int $$9 = 1; $$9 < $$6; ++$$9) {
                p_404890_.pushPose();
                float $$10 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float $$11 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                float $$12 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                p_404890_.translate($$10, $$11, $$12);
                $$7.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                p_404890_.popPose();
            }
        } else {
            float $$13 = $$8 * 1.5f;
            p_404890_.translate(0.0f, 0.0f, -($$13 * (float)($$6 - 1) / 2.0f));
            $$7.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
            p_404890_.translate(0.0f, 0.0f, $$13);
            for (int $$14 = 1; $$14 < $$6; ++$$14) {
                p_404890_.pushPose();
                float $$15 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float $$16 = (p_404894_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                p_404890_.translate($$15, $$16, 0.0f);
                $$7.render(p_404890_, p_405782_, p_404762_, OverlayTexture.NO_OVERLAY);
                p_404890_.popPose();
                p_404890_.translate(0.0f, 0.0f, $$13);
            }
        }
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

