/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.GuardianRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class GuardianRenderer
extends MobRenderer<Guardian, GuardianRenderState, GuardianModel> {
    private static final ResourceLocation GUARDIAN_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian.png");
    private static final ResourceLocation GUARDIAN_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/guardian_beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull(GUARDIAN_BEAM_LOCATION);

    public GuardianRenderer(EntityRendererProvider.Context p_174159_) {
        this(p_174159_, 0.5f, ModelLayers.GUARDIAN);
    }

    protected GuardianRenderer(EntityRendererProvider.Context p_174161_, float p_174162_, ModelLayerLocation p_174163_) {
        super(p_174161_, new GuardianModel(p_174161_.bakeLayer(p_174163_)), p_174162_);
    }

    @Override
    public boolean shouldRender(Guardian p_114836_, Frustum p_114837_, double p_114838_, double p_114839_, double p_114840_) {
        LivingEntity $$5;
        if (super.shouldRender(p_114836_, p_114837_, p_114838_, p_114839_, p_114840_)) {
            return true;
        }
        if (p_114836_.hasActiveAttackTarget() && ($$5 = p_114836_.getActiveAttackTarget()) != null) {
            Vec3 $$6 = this.getPosition($$5, (double)$$5.getBbHeight() * 0.5, 1.0f);
            Vec3 $$7 = this.getPosition(p_114836_, p_114836_.getEyeHeight(), 1.0f);
            return p_114837_.isVisible(new AABB($$7.x, $$7.y, $$7.z, $$6.x, $$6.y, $$6.z));
        }
        return false;
    }

    private Vec3 getPosition(LivingEntity p_114803_, double p_114804_, float p_114805_) {
        double $$3 = Mth.lerp((double)p_114805_, p_114803_.xOld, p_114803_.getX());
        double $$4 = Mth.lerp((double)p_114805_, p_114803_.yOld, p_114803_.getY()) + p_114804_;
        double $$5 = Mth.lerp((double)p_114805_, p_114803_.zOld, p_114803_.getZ());
        return new Vec3($$3, $$4, $$5);
    }

    @Override
    public void render(GuardianRenderState p_363200_, PoseStack p_114793_, MultiBufferSource p_114794_, int p_114795_) {
        super.render(p_363200_, p_114793_, p_114794_, p_114795_);
        Vec3 $$4 = p_363200_.attackTargetPosition;
        if ($$4 != null) {
            float $$5 = p_363200_.attackTime * 0.5f % 1.0f;
            p_114793_.pushPose();
            p_114793_.translate(0.0f, p_363200_.eyeHeight, 0.0f);
            GuardianRenderer.renderBeam(p_114793_, p_114794_.getBuffer(BEAM_RENDER_TYPE), $$4.subtract(p_363200_.eyePosition), p_363200_.attackTime, p_363200_.attackScale, $$5);
            p_114793_.popPose();
        }
    }

    private static void renderBeam(PoseStack p_363906_, VertexConsumer p_365218_, Vec3 p_360399_, float p_363920_, float p_363755_, float p_361709_) {
        float $$6 = (float)(p_360399_.length() + 1.0);
        p_360399_ = p_360399_.normalize();
        float $$7 = (float)Math.acos(p_360399_.y);
        float $$8 = 1.5707964f - (float)Math.atan2(p_360399_.z, p_360399_.x);
        p_363906_.mulPose((Quaternionfc)Axis.YP.rotationDegrees($$8 * 57.295776f));
        p_363906_.mulPose((Quaternionfc)Axis.XP.rotationDegrees($$7 * 57.295776f));
        float $$9 = p_363920_ * 0.05f * -1.5f;
        float $$10 = p_363755_ * p_363755_;
        int $$11 = 64 + (int)($$10 * 191.0f);
        int $$12 = 32 + (int)($$10 * 191.0f);
        int $$13 = 128 - (int)($$10 * 64.0f);
        float $$14 = 0.2f;
        float $$15 = 0.282f;
        float $$16 = Mth.cos($$9 + 2.3561945f) * 0.282f;
        float $$17 = Mth.sin($$9 + 2.3561945f) * 0.282f;
        float $$18 = Mth.cos($$9 + 0.7853982f) * 0.282f;
        float $$19 = Mth.sin($$9 + 0.7853982f) * 0.282f;
        float $$20 = Mth.cos($$9 + 3.926991f) * 0.282f;
        float $$21 = Mth.sin($$9 + 3.926991f) * 0.282f;
        float $$22 = Mth.cos($$9 + 5.4977875f) * 0.282f;
        float $$23 = Mth.sin($$9 + 5.4977875f) * 0.282f;
        float $$24 = Mth.cos($$9 + (float)Math.PI) * 0.2f;
        float $$25 = Mth.sin($$9 + (float)Math.PI) * 0.2f;
        float $$26 = Mth.cos($$9 + 0.0f) * 0.2f;
        float $$27 = Mth.sin($$9 + 0.0f) * 0.2f;
        float $$28 = Mth.cos($$9 + 1.5707964f) * 0.2f;
        float $$29 = Mth.sin($$9 + 1.5707964f) * 0.2f;
        float $$30 = Mth.cos($$9 + 4.712389f) * 0.2f;
        float $$31 = Mth.sin($$9 + 4.712389f) * 0.2f;
        float $$32 = $$6;
        float $$33 = 0.0f;
        float $$34 = 0.4999f;
        float $$35 = -1.0f + p_361709_;
        float $$36 = $$35 + $$6 * 2.5f;
        PoseStack.Pose $$37 = p_363906_.last();
        GuardianRenderer.vertex(p_365218_, $$37, $$24, $$32, $$25, $$11, $$12, $$13, 0.4999f, $$36);
        GuardianRenderer.vertex(p_365218_, $$37, $$24, 0.0f, $$25, $$11, $$12, $$13, 0.4999f, $$35);
        GuardianRenderer.vertex(p_365218_, $$37, $$26, 0.0f, $$27, $$11, $$12, $$13, 0.0f, $$35);
        GuardianRenderer.vertex(p_365218_, $$37, $$26, $$32, $$27, $$11, $$12, $$13, 0.0f, $$36);
        GuardianRenderer.vertex(p_365218_, $$37, $$28, $$32, $$29, $$11, $$12, $$13, 0.4999f, $$36);
        GuardianRenderer.vertex(p_365218_, $$37, $$28, 0.0f, $$29, $$11, $$12, $$13, 0.4999f, $$35);
        GuardianRenderer.vertex(p_365218_, $$37, $$30, 0.0f, $$31, $$11, $$12, $$13, 0.0f, $$35);
        GuardianRenderer.vertex(p_365218_, $$37, $$30, $$32, $$31, $$11, $$12, $$13, 0.0f, $$36);
        float $$38 = Mth.floor(p_363920_) % 2 == 0 ? 0.5f : 0.0f;
        GuardianRenderer.vertex(p_365218_, $$37, $$16, $$32, $$17, $$11, $$12, $$13, 0.5f, $$38 + 0.5f);
        GuardianRenderer.vertex(p_365218_, $$37, $$18, $$32, $$19, $$11, $$12, $$13, 1.0f, $$38 + 0.5f);
        GuardianRenderer.vertex(p_365218_, $$37, $$22, $$32, $$23, $$11, $$12, $$13, 1.0f, $$38);
        GuardianRenderer.vertex(p_365218_, $$37, $$20, $$32, $$21, $$11, $$12, $$13, 0.5f, $$38);
    }

    private static void vertex(VertexConsumer p_253637_, PoseStack.Pose p_323627_, float p_253994_, float p_254492_, float p_254474_, int p_254080_, int p_253655_, int p_254133_, float p_254233_, float p_253939_) {
        p_253637_.addVertex(p_323627_, p_253994_, p_254492_, p_254474_).setColor(p_254080_, p_253655_, p_254133_, 255).setUv(p_254233_, p_253939_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_323627_, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(GuardianRenderState p_363236_) {
        return GUARDIAN_LOCATION;
    }

    @Override
    public GuardianRenderState createRenderState() {
        return new GuardianRenderState();
    }

    @Override
    public void extractRenderState(Guardian p_360824_, GuardianRenderState p_360947_, float p_361770_) {
        super.extractRenderState(p_360824_, p_360947_, p_361770_);
        p_360947_.spikesAnimation = p_360824_.getSpikesAnimation(p_361770_);
        p_360947_.tailAnimation = p_360824_.getTailAnimation(p_361770_);
        p_360947_.eyePosition = p_360824_.getEyePosition(p_361770_);
        Entity $$3 = GuardianRenderer.getEntityToLookAt(p_360824_);
        if ($$3 != null) {
            p_360947_.lookDirection = p_360824_.getViewVector(p_361770_);
            p_360947_.lookAtPosition = $$3.getEyePosition(p_361770_);
        } else {
            p_360947_.lookDirection = null;
            p_360947_.lookAtPosition = null;
        }
        LivingEntity $$4 = p_360824_.getActiveAttackTarget();
        if ($$4 != null) {
            p_360947_.attackScale = p_360824_.getAttackAnimationScale(p_361770_);
            p_360947_.attackTime = p_360824_.getClientSideAttackTime() + p_361770_;
            p_360947_.attackTargetPosition = this.getPosition($$4, (double)$$4.getBbHeight() * 0.5, p_361770_);
        } else {
            p_360947_.attackTargetPosition = null;
        }
    }

    @Nullable
    private static Entity getEntityToLookAt(Guardian p_364936_) {
        Entity $$1 = Minecraft.getInstance().getCameraEntity();
        if (p_364936_.hasActiveAttackTarget()) {
            return p_364936_.getActiveAttackTarget();
        }
        return $$1;
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((GuardianRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

