/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FishingHookRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class FishingHookRenderer
extends EntityRenderer<FishingHook, FishingHookRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout(TEXTURE_LOCATION);
    private static final double VIEW_BOBBING_SCALE = 960.0;

    public FishingHookRenderer(EntityRendererProvider.Context p_174117_) {
        super(p_174117_);
    }

    @Override
    public boolean shouldRender(FishingHook p_363069_, Frustum p_362635_, double p_361840_, double p_361502_, double p_360380_) {
        return super.shouldRender(p_363069_, p_362635_, p_361840_, p_361502_, p_360380_) && p_363069_.getPlayerOwner() != null;
    }

    @Override
    public void render(FishingHookRenderState p_362456_, PoseStack p_114699_, MultiBufferSource p_114700_, int p_114701_) {
        p_114699_.pushPose();
        p_114699_.pushPose();
        p_114699_.scale(0.5f, 0.5f, 0.5f);
        p_114699_.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose $$4 = p_114699_.last();
        VertexConsumer $$5 = p_114700_.getBuffer(RENDER_TYPE);
        FishingHookRenderer.vertex($$5, $$4, p_114701_, 0.0f, 0, 0, 1);
        FishingHookRenderer.vertex($$5, $$4, p_114701_, 1.0f, 0, 1, 1);
        FishingHookRenderer.vertex($$5, $$4, p_114701_, 1.0f, 1, 1, 0);
        FishingHookRenderer.vertex($$5, $$4, p_114701_, 0.0f, 1, 0, 0);
        p_114699_.popPose();
        float $$6 = (float)p_362456_.lineOriginOffset.x;
        float $$7 = (float)p_362456_.lineOriginOffset.y;
        float $$8 = (float)p_362456_.lineOriginOffset.z;
        VertexConsumer $$9 = p_114700_.getBuffer(RenderType.lineStrip());
        PoseStack.Pose $$10 = p_114699_.last();
        int $$11 = 16;
        for (int $$12 = 0; $$12 <= 16; ++$$12) {
            FishingHookRenderer.stringVertex($$6, $$7, $$8, $$9, $$10, FishingHookRenderer.fraction($$12, 16), FishingHookRenderer.fraction($$12 + 1, 16));
        }
        p_114699_.popPose();
        super.render(p_362456_, p_114699_, p_114700_, p_114701_);
    }

    public static HumanoidArm getHoldingArm(Player p_386900_) {
        return p_386900_.getMainHandItem().getItem() instanceof FishingRodItem ? p_386900_.getMainArm() : p_386900_.getMainArm().getOpposite();
    }

    private Vec3 getPlayerHandPos(Player p_340935_, float p_340872_, float p_341261_) {
        int $$3;
        int n = $$3 = FishingHookRenderer.getHoldingArm(p_340935_) == HumanoidArm.RIGHT ? 1 : -1;
        if (!this.entityRenderDispatcher.options.getCameraType().isFirstPerson() || p_340935_ != Minecraft.getInstance().player) {
            float $$4 = Mth.lerp(p_341261_, p_340935_.yBodyRotO, p_340935_.yBodyRot) * ((float)Math.PI / 180);
            double $$5 = Mth.sin($$4);
            double $$6 = Mth.cos($$4);
            float $$7 = p_340935_.getScale();
            double $$8 = (double)$$3 * 0.35 * (double)$$7;
            double $$9 = 0.8 * (double)$$7;
            float $$10 = p_340935_.isCrouching() ? -0.1875f : 0.0f;
            return p_340935_.getEyePosition(p_341261_).add(-$$6 * $$8 - $$5 * $$9, (double)$$10 - 0.45 * (double)$$7, -$$5 * $$8 + $$6 * $$9);
        }
        double $$11 = 960.0 / (double)this.entityRenderDispatcher.options.fov().get().intValue();
        Vec3 $$12 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)$$3 * 0.525f, -0.1f).scale($$11).yRot(p_340872_ * 0.5f).xRot(-p_340872_ * 0.7f);
        return p_340935_.getEyePosition(p_341261_).add($$12);
    }

    private static float fraction(int p_114691_, int p_114692_) {
        return (float)p_114691_ / (float)p_114692_;
    }

    private static void vertex(VertexConsumer p_254464_, PoseStack.Pose p_323724_, int p_254296_, float p_253632_, int p_254132_, int p_254171_, int p_254026_) {
        p_254464_.addVertex(p_323724_, p_253632_ - 0.5f, (float)p_254132_ - 0.5f, 0.0f).setColor(-1).setUv(p_254171_, p_254026_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254296_).setNormal(p_323724_, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer p_174122_, PoseStack.Pose p_174123_, float p_174124_, float p_174125_) {
        float $$7 = p_174119_ * p_174124_;
        float $$8 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float $$9 = p_174121_ * p_174124_;
        float $$10 = p_174119_ * p_174125_ - $$7;
        float $$11 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - $$8;
        float $$12 = p_174121_ * p_174125_ - $$9;
        float $$13 = Mth.sqrt($$10 * $$10 + $$11 * $$11 + $$12 * $$12);
        p_174122_.addVertex(p_174123_, $$7, $$8, $$9).setColor(-16777216).setNormal(p_174123_, $$10 /= $$13, $$11 /= $$13, $$12 /= $$13);
    }

    @Override
    public FishingHookRenderState createRenderState() {
        return new FishingHookRenderState();
    }

    @Override
    public void extractRenderState(FishingHook p_361584_, FishingHookRenderState p_364824_, float p_360891_) {
        super.extractRenderState(p_361584_, p_364824_, p_360891_);
        Player $$3 = p_361584_.getPlayerOwner();
        if ($$3 == null) {
            p_364824_.lineOriginOffset = Vec3.ZERO;
            return;
        }
        float $$4 = $$3.getAttackAnim(p_360891_);
        float $$5 = Mth.sin(Mth.sqrt($$4) * (float)Math.PI);
        Vec3 $$6 = this.getPlayerHandPos($$3, $$5, p_360891_);
        Vec3 $$7 = p_361584_.getPosition(p_360891_).add(0.0, 0.25, 0.0);
        p_364824_.lineOriginOffset = $$6.subtract($$7);
    }

    @Override
    protected boolean affectedByCulling(FishingHook p_365042_) {
        return false;
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ boolean affectedByCulling(Entity entity) {
        return this.affectedByCulling((FishingHook)entity);
    }
}

