/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.entity.state.HitboxesRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.entity.state.ServerHitboxesRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityRenderDispatcher
implements ResourceManagerReloadListener {
    private static final RenderType SHADOW_RENDER_TYPE = RenderType.entityShadow(ResourceLocation.withDefaultNamespace("textures/misc/shadow.png"));
    private static final float MAX_SHADOW_RADIUS = 32.0f;
    private static final float SHADOW_POWER_FALLOFF_Y = 0.5f;
    private Map<EntityType<?>, EntityRenderer<?, ?>> renderers = ImmutableMap.of();
    private Map<PlayerSkin.Model, EntityRenderer<? extends Player, ?>> playerRenderers = Map.of();
    public final TextureManager textureManager;
    private Level level;
    public Camera camera;
    private Quaternionf cameraOrientation;
    public Entity crosshairPickEntity;
    private final ItemModelResolver itemModelResolver;
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final ItemInHandRenderer itemInHandRenderer;
    private final Font font;
    public final Options options;
    private final Supplier<EntityModelSet> entityModels;
    private final EquipmentAssetManager equipmentAssets;
    private boolean shouldRenderShadow = true;
    private boolean renderHitBoxes;

    public <E extends Entity> int getPackedLightCoords(E p_114395_, float p_114396_) {
        return this.getRenderer((EntityRenderState)((Object)p_114395_)).getPackedLightCoords(p_114395_, p_114396_);
    }

    public EntityRenderDispatcher(Minecraft p_234579_, TextureManager p_234580_, ItemModelResolver p_388181_, ItemRenderer p_234581_, MapRenderer p_361209_, BlockRenderDispatcher p_234582_, Font p_234583_, Options p_234584_, Supplier<EntityModelSet> p_387861_, EquipmentAssetManager p_386713_) {
        this.textureManager = p_234580_;
        this.itemModelResolver = p_388181_;
        this.mapRenderer = p_361209_;
        this.itemInHandRenderer = new ItemInHandRenderer(p_234579_, this, p_234581_, p_388181_);
        this.blockRenderDispatcher = p_234582_;
        this.font = p_234583_;
        this.options = p_234584_;
        this.entityModels = p_387861_;
        this.equipmentAssets = p_386713_;
    }

    public <T extends Entity> EntityRenderer<? super T, ?> getRenderer(T p_114383_) {
        if (p_114383_ instanceof AbstractClientPlayer) {
            AbstractClientPlayer $$1 = (AbstractClientPlayer)p_114383_;
            PlayerSkin.Model $$2 = $$1.getSkin().model();
            EntityRenderer<? extends Player, ?> $$3 = this.playerRenderers.get((Object)$$2);
            if ($$3 != null) {
                return $$3;
            }
            return this.playerRenderers.get((Object)PlayerSkin.Model.WIDE);
        }
        return this.renderers.get(p_114383_.getType());
    }

    public <S extends EntityRenderState> EntityRenderer<?, ? super S> getRenderer(S p_412312_) {
        if (p_412312_ instanceof PlayerRenderState) {
            PlayerRenderState $$1 = (PlayerRenderState)p_412312_;
            PlayerSkin.Model $$2 = $$1.skin.model();
            EntityRenderer<? extends Player, ?> $$3 = this.playerRenderers.get((Object)$$2);
            if ($$3 != null) {
                return $$3;
            }
            return this.playerRenderers.get((Object)PlayerSkin.Model.WIDE);
        }
        return this.renderers.get(p_412312_.entityType);
    }

    public void prepare(Level p_114409_, Camera p_114410_, Entity p_114411_) {
        this.level = p_114409_;
        this.camera = p_114410_;
        this.cameraOrientation = p_114410_.rotation();
        this.crosshairPickEntity = p_114411_;
    }

    public void overrideCameraOrientation(Quaternionf p_254264_) {
        this.cameraOrientation = p_254264_;
    }

    public void setRenderShadow(boolean p_114469_) {
        this.shouldRenderShadow = p_114469_;
    }

    public void setRenderHitBoxes(boolean p_114474_) {
        this.renderHitBoxes = p_114474_;
    }

    public boolean shouldRenderHitBoxes() {
        return this.renderHitBoxes;
    }

    public <E extends Entity> boolean shouldRender(E p_114398_, Frustum p_114399_, double p_114400_, double p_114401_, double p_114402_) {
        EntityRenderer<?, E> $$5 = this.getRenderer((EntityRenderState)((Object)p_114398_));
        return $$5.shouldRender(p_114398_, p_114399_, p_114400_, p_114401_, p_114402_);
    }

    public <E extends Entity> void render(E p_114385_, double p_114386_, double p_114387_, double p_114388_, float p_114389_, PoseStack p_114391_, MultiBufferSource p_114392_, int p_114393_) {
        EntityRenderer<?, E> $$8 = this.getRenderer((EntityRenderState)((Object)p_114385_));
        this.render(p_114385_, p_114386_, p_114387_, p_114388_, p_114389_, p_114391_, p_114392_, p_114393_, $$8);
    }

    /*
     * WARNING - void declaration
     */
    private <E extends Entity, S extends EntityRenderState> void render(E p_365426_, double p_364222_, double p_360564_, double p_365367_, float p_364461_, PoseStack p_363537_, MultiBufferSource p_364290_, int p_363520_, EntityRenderer<? super E, S> p_360327_) {
        try {
            S $$9 = p_360327_.createRenderState(p_365426_, p_364461_);
        }
        catch (Throwable $$10) {
            CrashReport $$11 = CrashReport.forThrowable($$10, "Extracting render state for an entity in world");
            CrashReportCategory $$12 = $$11.addCategory("Entity being extracted");
            p_365426_.fillCrashReportCategory($$12);
            CrashReportCategory $$13 = this.fillRendererDetails(p_364222_, p_360564_, p_365367_, p_360327_, $$11);
            $$13.setDetail("Delta", Float.valueOf(p_364461_));
            throw new ReportedException($$11);
        }
        try {
            void $$14;
            this.render($$14, p_364222_, p_360564_, p_365367_, p_363537_, p_364290_, p_363520_, p_360327_);
        }
        catch (Throwable $$15) {
            CrashReport $$16 = CrashReport.forThrowable($$15, "Rendering entity in world");
            CrashReportCategory $$17 = $$16.addCategory("Entity being rendered");
            p_365426_.fillCrashReportCategory($$17);
            throw new ReportedException($$16);
        }
    }

    public <S extends EntityRenderState> void render(S p_412464_, double p_412191_, double p_412733_, double p_412728_, PoseStack p_412550_, MultiBufferSource p_412452_, int p_412119_) {
        EntityRenderer<?, S> $$7 = this.getRenderer(p_412464_);
        this.render(p_412464_, p_412191_, p_412733_, p_412728_, p_412550_, p_412452_, p_412119_, $$7);
    }

    private <S extends EntityRenderState> void render(S p_412595_, double p_412285_, double p_412620_, double p_412059_, PoseStack p_412055_, MultiBufferSource p_412539_, int p_412431_, EntityRenderer<?, S> p_412321_) {
        try {
            double $$13;
            float $$14;
            float $$12;
            Vec3 $$8 = p_412321_.getRenderOffset(p_412595_);
            double $$9 = p_412285_ + $$8.x();
            double $$10 = p_412620_ + $$8.y();
            double $$11 = p_412059_ + $$8.z();
            p_412055_.pushPose();
            p_412055_.translate($$9, $$10, $$11);
            p_412321_.render(p_412595_, p_412055_, p_412539_, p_412431_);
            if (p_412595_.displayFireAnimation) {
                this.renderFlame(p_412055_, p_412539_, p_412595_, Mth.rotationAroundAxis(Mth.Y_AXIS, this.cameraOrientation, new Quaternionf()));
            }
            if (p_412595_ instanceof PlayerRenderState) {
                p_412055_.translate(-$$8.x(), -$$8.y(), -$$8.z());
            }
            if (this.options.entityShadows().get().booleanValue() && this.shouldRenderShadow && !p_412595_.isInvisible && ($$12 = p_412321_.getShadowRadius(p_412595_)) > 0.0f && ($$14 = (float)((1.0 - ($$13 = p_412595_.distanceToCameraSq) / 256.0) * (double)p_412321_.getShadowStrength(p_412595_))) > 0.0f) {
                EntityRenderDispatcher.renderShadow(p_412055_, p_412539_, p_412595_, $$14, this.level, Math.min($$12, 32.0f));
            }
            if (!(p_412595_ instanceof PlayerRenderState)) {
                p_412055_.translate(-$$8.x(), -$$8.y(), -$$8.z());
            }
            if (p_412595_.hitboxesRenderState != null) {
                this.renderHitboxes(p_412055_, p_412595_, p_412595_.hitboxesRenderState, p_412539_);
            }
            p_412055_.popPose();
        }
        catch (Throwable $$15) {
            CrashReport $$16 = CrashReport.forThrowable($$15, "Rendering entity in world");
            CrashReportCategory $$17 = $$16.addCategory("EntityRenderState being rendered");
            p_412595_.fillCrashReportCategory($$17);
            this.fillRendererDetails(p_412285_, p_412620_, p_412059_, p_412321_, $$16);
            throw new ReportedException($$16);
        }
    }

    private <S extends EntityRenderState> CrashReportCategory fillRendererDetails(double p_412658_, double p_412212_, double p_412493_, EntityRenderer<?, S> p_412221_, CrashReport p_412241_) {
        CrashReportCategory $$5 = p_412241_.addCategory("Renderer details");
        $$5.setDetail("Assigned renderer", p_412221_);
        $$5.setDetail("Location", CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_412658_, p_412212_, p_412493_));
        return $$5;
    }

    private void renderHitboxes(PoseStack p_412605_, EntityRenderState p_412741_, HitboxesRenderState p_412691_, MultiBufferSource p_412667_) {
        VertexConsumer $$4 = p_412667_.getBuffer(RenderType.lines());
        EntityRenderDispatcher.renderHitboxesAndViewVector(p_412605_, p_412691_, $$4, p_412741_.eyeHeight);
        ServerHitboxesRenderState $$5 = p_412741_.serverHitboxesRenderState;
        if ($$5 != null) {
            if ($$5.missing()) {
                HitboxRenderState $$6 = (HitboxRenderState)p_412691_.hitboxes().getFirst();
                DebugRenderer.renderFloatingText(p_412605_, p_412667_, "Missing", p_412741_.x, $$6.y1() + 1.5, p_412741_.z, -65536);
            } else if ($$5.hitboxes() != null) {
                p_412605_.pushPose();
                p_412605_.translate($$5.serverEntityX() - p_412741_.x, $$5.serverEntityY() - p_412741_.y, $$5.serverEntityZ() - p_412741_.z);
                EntityRenderDispatcher.renderHitboxesAndViewVector(p_412605_, $$5.hitboxes(), $$4, $$5.eyeHeight());
                Vec3 $$7 = new Vec3($$5.deltaMovementX(), $$5.deltaMovementY(), $$5.deltaMovementZ());
                ShapeRenderer.renderVector(p_412605_, $$4, new Vector3f(), $$7, -256);
                p_412605_.popPose();
            }
        }
    }

    private static void renderHitboxesAndViewVector(PoseStack p_412542_, HitboxesRenderState p_412760_, VertexConsumer p_412159_, float p_412372_) {
        for (HitboxRenderState $$4 : p_412760_.hitboxes()) {
            EntityRenderDispatcher.renderHitbox(p_412542_, p_412159_, $$4);
        }
        Vec3 $$5 = new Vec3(p_412760_.viewX(), p_412760_.viewY(), p_412760_.viewZ());
        ShapeRenderer.renderVector(p_412542_, p_412159_, new Vector3f(0.0f, p_412372_, 0.0f), $$5.scale(2.0), -16776961);
    }

    private static void renderHitbox(PoseStack p_114442_, VertexConsumer p_114443_, HitboxRenderState p_412284_) {
        p_114442_.pushPose();
        p_114442_.translate(p_412284_.offsetX(), p_412284_.offsetY(), p_412284_.offsetZ());
        ShapeRenderer.renderLineBox(p_114442_, p_114443_, p_412284_.x0(), p_412284_.y0(), p_412284_.z0(), p_412284_.x1(), p_412284_.y1(), p_412284_.z1(), p_412284_.red(), p_412284_.green(), p_412284_.blue(), 1.0f);
        p_114442_.popPose();
    }

    private void renderFlame(PoseStack p_114454_, MultiBufferSource p_114455_, EntityRenderState p_363731_, Quaternionf p_304964_) {
        TextureAtlasSprite $$4 = ModelBakery.FIRE_0.sprite();
        TextureAtlasSprite $$5 = ModelBakery.FIRE_1.sprite();
        p_114454_.pushPose();
        float $$6 = p_363731_.boundingBoxWidth * 1.4f;
        p_114454_.scale($$6, $$6, $$6);
        float $$7 = 0.5f;
        float $$8 = 0.0f;
        float $$9 = p_363731_.boundingBoxHeight / $$6;
        float $$10 = 0.0f;
        p_114454_.mulPose((Quaternionfc)p_304964_);
        p_114454_.translate(0.0f, 0.0f, 0.3f - (float)((int)$$9) * 0.02f);
        float $$11 = 0.0f;
        int $$12 = 0;
        VertexConsumer $$13 = p_114455_.getBuffer(Sheets.cutoutBlockSheet());
        PoseStack.Pose $$14 = p_114454_.last();
        while ($$9 > 0.0f) {
            TextureAtlasSprite $$15 = $$12 % 2 == 0 ? $$4 : $$5;
            float $$16 = $$15.getU0();
            float $$17 = $$15.getV0();
            float $$18 = $$15.getU1();
            float $$19 = $$15.getV1();
            if ($$12 / 2 % 2 == 0) {
                float $$20 = $$18;
                $$18 = $$16;
                $$16 = $$20;
            }
            EntityRenderDispatcher.fireVertex($$14, $$13, -$$7 - 0.0f, 0.0f - $$10, $$11, $$18, $$19);
            EntityRenderDispatcher.fireVertex($$14, $$13, $$7 - 0.0f, 0.0f - $$10, $$11, $$16, $$19);
            EntityRenderDispatcher.fireVertex($$14, $$13, $$7 - 0.0f, 1.4f - $$10, $$11, $$16, $$17);
            EntityRenderDispatcher.fireVertex($$14, $$13, -$$7 - 0.0f, 1.4f - $$10, $$11, $$18, $$17);
            $$9 -= 0.45f;
            $$10 -= 0.45f;
            $$7 *= 0.9f;
            $$11 -= 0.03f;
            ++$$12;
        }
        p_114454_.popPose();
    }

    private static void fireVertex(PoseStack.Pose p_114415_, VertexConsumer p_114416_, float p_114417_, float p_114418_, float p_114419_, float p_114420_, float p_114421_) {
        p_114416_.addVertex(p_114415_, p_114417_, p_114418_, p_114419_).setColor(-1).setUv(p_114420_, p_114421_).setUv1(0, 10).setLight(240).setNormal(p_114415_, 0.0f, 1.0f, 0.0f);
    }

    private static void renderShadow(PoseStack p_114458_, MultiBufferSource p_114459_, EntityRenderState p_365403_, float p_114461_, LevelReader p_114463_, float p_114462_) {
        float $$6 = Math.min(p_114461_ / 0.5f, p_114462_);
        int $$7 = Mth.floor(p_365403_.x - (double)p_114462_);
        int $$8 = Mth.floor(p_365403_.x + (double)p_114462_);
        int $$9 = Mth.floor(p_365403_.y - (double)$$6);
        int $$10 = Mth.floor(p_365403_.y);
        int $$11 = Mth.floor(p_365403_.z - (double)p_114462_);
        int $$12 = Mth.floor(p_365403_.z + (double)p_114462_);
        PoseStack.Pose $$13 = p_114458_.last();
        VertexConsumer $$14 = p_114459_.getBuffer(SHADOW_RENDER_TYPE);
        BlockPos.MutableBlockPos $$15 = new BlockPos.MutableBlockPos();
        for (int $$16 = $$11; $$16 <= $$12; ++$$16) {
            for (int $$17 = $$7; $$17 <= $$8; ++$$17) {
                $$15.set($$17, 0, $$16);
                ChunkAccess $$18 = p_114463_.getChunk($$15);
                for (int $$19 = $$9; $$19 <= $$10; ++$$19) {
                    $$15.setY($$19);
                    float $$20 = p_114461_ - (float)(p_365403_.y - (double)$$15.getY()) * 0.5f;
                    EntityRenderDispatcher.renderBlockShadow($$13, $$14, $$18, p_114463_, $$15, p_365403_.x, p_365403_.y, p_365403_.z, p_114462_, $$20);
                }
            }
        }
    }

    private static void renderBlockShadow(PoseStack.Pose p_277956_, VertexConsumer p_277533_, ChunkAccess p_277501_, LevelReader p_277622_, BlockPos p_277911_, double p_277682_, double p_278099_, double p_277806_, float p_277844_, float p_277496_) {
        BlockPos $$10 = p_277911_.below();
        BlockState $$11 = p_277501_.getBlockState($$10);
        if ($$11.getRenderShape() == RenderShape.INVISIBLE || p_277622_.getMaxLocalRawBrightness(p_277911_) <= 3) {
            return;
        }
        if (!$$11.isCollisionShapeFullBlock(p_277501_, $$10)) {
            return;
        }
        VoxelShape $$12 = $$11.getShape(p_277501_, $$10);
        if ($$12.isEmpty()) {
            return;
        }
        float $$13 = LightTexture.getBrightness(p_277622_.dimensionType(), p_277622_.getMaxLocalRawBrightness(p_277911_));
        float $$14 = p_277496_ * 0.5f * $$13;
        if ($$14 >= 0.0f) {
            if ($$14 > 1.0f) {
                $$14 = 1.0f;
            }
            int $$15 = ARGB.color(Mth.floor($$14 * 255.0f), 255, 255, 255);
            AABB $$16 = $$12.bounds();
            double $$17 = (double)p_277911_.getX() + $$16.minX;
            double $$18 = (double)p_277911_.getX() + $$16.maxX;
            double $$19 = (double)p_277911_.getY() + $$16.minY;
            double $$20 = (double)p_277911_.getZ() + $$16.minZ;
            double $$21 = (double)p_277911_.getZ() + $$16.maxZ;
            float $$22 = (float)($$17 - p_277682_);
            float $$23 = (float)($$18 - p_277682_);
            float $$24 = (float)($$19 - p_278099_);
            float $$25 = (float)($$20 - p_277806_);
            float $$26 = (float)($$21 - p_277806_);
            float $$27 = -$$22 / 2.0f / p_277844_ + 0.5f;
            float $$28 = -$$23 / 2.0f / p_277844_ + 0.5f;
            float $$29 = -$$25 / 2.0f / p_277844_ + 0.5f;
            float $$30 = -$$26 / 2.0f / p_277844_ + 0.5f;
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$22, $$24, $$25, $$27, $$29);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$22, $$24, $$26, $$27, $$30);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$23, $$24, $$26, $$28, $$30);
            EntityRenderDispatcher.shadowVertex(p_277956_, p_277533_, $$15, $$23, $$24, $$25, $$28, $$29);
        }
    }

    private static void shadowVertex(PoseStack.Pose p_114423_, VertexConsumer p_114424_, int p_350992_, float p_114425_, float p_114426_, float p_114427_, float p_114428_, float p_114429_) {
        Vector3f $$8 = p_114423_.pose().transformPosition(p_114425_, p_114426_, p_114427_, new Vector3f());
        p_114424_.addVertex($$8.x(), $$8.y(), $$8.z(), p_350992_, p_114428_, p_114429_, OverlayTexture.NO_OVERLAY, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }

    public void setLevel(@Nullable Level p_114407_) {
        this.level = p_114407_;
        if (p_114407_ == null) {
            this.camera = null;
        }
    }

    public double distanceToSqr(Entity p_114472_) {
        return this.camera.getPosition().distanceToSqr(p_114472_.position());
    }

    public double distanceToSqr(double p_114379_, double p_114380_, double p_114381_) {
        return this.camera.getPosition().distanceToSqr(p_114379_, p_114380_, p_114381_);
    }

    public Quaternionf cameraOrientation() {
        return this.cameraOrientation;
    }

    public ItemInHandRenderer getItemInHandRenderer() {
        return this.itemInHandRenderer;
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_174004_) {
        EntityRendererProvider.Context $$1 = new EntityRendererProvider.Context(this, this.itemModelResolver, this.mapRenderer, this.blockRenderDispatcher, p_174004_, this.entityModels.get(), this.equipmentAssets, this.font);
        this.renderers = EntityRenderers.createEntityRenderers($$1);
        this.playerRenderers = EntityRenderers.createPlayerRenderers($$1);
    }
}

