/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.dragon.EnderDragonModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EnderDragonRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HitboxRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EnderDragonRenderer
extends EntityRenderer<EnderDragon, EnderDragonRenderState> {
    public static final ResourceLocation CRYSTAL_BEAM_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/end_crystal/end_crystal_beam.png");
    private static final ResourceLocation DRAGON_EXPLODING_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_exploding.png");
    private static final ResourceLocation DRAGON_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon.png");
    private static final ResourceLocation DRAGON_EYES_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enderdragon/dragon_eyes.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull(DRAGON_LOCATION);
    private static final RenderType DECAL = RenderType.entityDecal(DRAGON_LOCATION);
    private static final RenderType EYES = RenderType.eyes(DRAGON_EYES_LOCATION);
    private static final RenderType BEAM = RenderType.entitySmoothCutout(CRYSTAL_BEAM_LOCATION);
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final EnderDragonModel model;

    public EnderDragonRenderer(EntityRendererProvider.Context p_173973_) {
        super(p_173973_);
        this.shadowRadius = 0.5f;
        this.model = new EnderDragonModel(p_173973_.bakeLayer(ModelLayers.ENDER_DRAGON));
    }

    @Override
    public void render(EnderDragonRenderState p_364805_, PoseStack p_114211_, MultiBufferSource p_114212_, int p_114213_) {
        p_114211_.pushPose();
        float $$4 = p_364805_.getHistoricalPos(7).yRot();
        float $$5 = (float)(p_364805_.getHistoricalPos(5).y() - p_364805_.getHistoricalPos(10).y());
        p_114211_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-$$4));
        p_114211_.mulPose((Quaternionfc)Axis.XP.rotationDegrees($$5 * 10.0f));
        p_114211_.translate(0.0f, 0.0f, 1.0f);
        p_114211_.scale(-1.0f, -1.0f, 1.0f);
        p_114211_.translate(0.0f, -1.501f, 0.0f);
        this.model.setupAnim(p_364805_);
        if (p_364805_.deathTime > 0.0f) {
            float $$6 = p_364805_.deathTime / 200.0f;
            int $$7 = ARGB.color(Mth.floor($$6 * 255.0f), -1);
            VertexConsumer $$8 = p_114212_.getBuffer(RenderType.dragonExplosionAlpha(DRAGON_EXPLODING_LOCATION));
            this.model.renderToBuffer(p_114211_, $$8, p_114213_, OverlayTexture.NO_OVERLAY, $$7);
            VertexConsumer $$9 = p_114212_.getBuffer(DECAL);
            this.model.renderToBuffer(p_114211_, $$9, p_114213_, OverlayTexture.pack(0.0f, p_364805_.hasRedOverlay));
        } else {
            VertexConsumer $$10 = p_114212_.getBuffer(RENDER_TYPE);
            this.model.renderToBuffer(p_114211_, $$10, p_114213_, OverlayTexture.pack(0.0f, p_364805_.hasRedOverlay));
        }
        VertexConsumer $$11 = p_114212_.getBuffer(EYES);
        this.model.renderToBuffer(p_114211_, $$11, p_114213_, OverlayTexture.NO_OVERLAY);
        if (p_364805_.deathTime > 0.0f) {
            float $$12 = p_364805_.deathTime / 200.0f;
            p_114211_.pushPose();
            p_114211_.translate(0.0f, -1.0f, -2.0f);
            EnderDragonRenderer.renderRays(p_114211_, $$12, p_114212_.getBuffer(RenderType.dragonRays()));
            EnderDragonRenderer.renderRays(p_114211_, $$12, p_114212_.getBuffer(RenderType.dragonRaysDepth()));
            p_114211_.popPose();
        }
        p_114211_.popPose();
        if (p_364805_.beamOffset != null) {
            EnderDragonRenderer.renderCrystalBeams((float)p_364805_.beamOffset.x, (float)p_364805_.beamOffset.y, (float)p_364805_.beamOffset.z, p_364805_.ageInTicks, p_114211_, p_114212_, p_114213_);
        }
        super.render(p_364805_, p_114211_, p_114212_, p_114213_);
    }

    private static void renderRays(PoseStack p_352922_, float p_352903_, VertexConsumer p_352894_) {
        p_352922_.pushPose();
        float $$3 = Math.min(p_352903_ > 0.8f ? (p_352903_ - 0.8f) / 0.2f : 0.0f, 1.0f);
        int $$4 = ARGB.colorFromFloat(1.0f - $$3, 1.0f, 1.0f, 1.0f);
        int $$5 = 0xFF00FF;
        RandomSource $$6 = RandomSource.create(432L);
        Vector3f $$7 = new Vector3f();
        Vector3f $$8 = new Vector3f();
        Vector3f $$9 = new Vector3f();
        Vector3f $$10 = new Vector3f();
        Quaternionf $$11 = new Quaternionf();
        int $$12 = Mth.floor((p_352903_ + p_352903_ * p_352903_) / 2.0f * 60.0f);
        for (int $$13 = 0; $$13 < $$12; ++$$13) {
            $$11.rotationXYZ($$6.nextFloat() * ((float)Math.PI * 2), $$6.nextFloat() * ((float)Math.PI * 2), $$6.nextFloat() * ((float)Math.PI * 2)).rotateXYZ($$6.nextFloat() * ((float)Math.PI * 2), $$6.nextFloat() * ((float)Math.PI * 2), $$6.nextFloat() * ((float)Math.PI * 2) + p_352903_ * 1.5707964f);
            p_352922_.mulPose((Quaternionfc)$$11);
            float $$14 = $$6.nextFloat() * 20.0f + 5.0f + $$3 * 10.0f;
            float $$15 = $$6.nextFloat() * 2.0f + 1.0f + $$3 * 2.0f;
            $$8.set(-HALF_SQRT_3 * $$15, $$14, -0.5f * $$15);
            $$9.set(HALF_SQRT_3 * $$15, $$14, -0.5f * $$15);
            $$10.set(0.0f, $$14, $$15);
            PoseStack.Pose $$16 = p_352922_.last();
            p_352894_.addVertex($$16, $$7).setColor($$4);
            p_352894_.addVertex($$16, $$8).setColor(0xFF00FF);
            p_352894_.addVertex($$16, $$9).setColor(0xFF00FF);
            p_352894_.addVertex($$16, $$7).setColor($$4);
            p_352894_.addVertex($$16, $$9).setColor(0xFF00FF);
            p_352894_.addVertex($$16, $$10).setColor(0xFF00FF);
            p_352894_.addVertex($$16, $$7).setColor($$4);
            p_352894_.addVertex($$16, $$10).setColor(0xFF00FF);
            p_352894_.addVertex($$16, $$8).setColor(0xFF00FF);
        }
        p_352922_.popPose();
    }

    public static void renderCrystalBeams(float p_114188_, float p_114189_, float p_114190_, float p_114191_, PoseStack p_114193_, MultiBufferSource p_114194_, int p_114192_) {
        float $$7 = Mth.sqrt(p_114188_ * p_114188_ + p_114190_ * p_114190_);
        float $$8 = Mth.sqrt(p_114188_ * p_114188_ + p_114189_ * p_114189_ + p_114190_ * p_114190_);
        p_114193_.pushPose();
        p_114193_.translate(0.0f, 2.0f, 0.0f);
        p_114193_.mulPose((Quaternionfc)Axis.YP.rotation((float)(-Math.atan2(p_114190_, p_114188_)) - 1.5707964f));
        p_114193_.mulPose((Quaternionfc)Axis.XP.rotation((float)(-Math.atan2($$7, p_114189_)) - 1.5707964f));
        VertexConsumer $$9 = p_114194_.getBuffer(BEAM);
        float $$10 = 0.0f - p_114191_ * 0.01f;
        float $$11 = $$8 / 32.0f - p_114191_ * 0.01f;
        int $$12 = 8;
        float $$13 = 0.0f;
        float $$14 = 0.75f;
        float $$15 = 0.0f;
        PoseStack.Pose $$16 = p_114193_.last();
        for (int $$17 = 1; $$17 <= 8; ++$$17) {
            float $$18 = Mth.sin((float)$$17 * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float $$19 = Mth.cos((float)$$17 * ((float)Math.PI * 2) / 8.0f) * 0.75f;
            float $$20 = (float)$$17 / 8.0f;
            $$9.addVertex($$16, $$13 * 0.2f, $$14 * 0.2f, 0.0f).setColor(-16777216).setUv($$15, $$10).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal($$16, 0.0f, -1.0f, 0.0f);
            $$9.addVertex($$16, $$13, $$14, $$8).setColor(-1).setUv($$15, $$11).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal($$16, 0.0f, -1.0f, 0.0f);
            $$9.addVertex($$16, $$18, $$19, $$8).setColor(-1).setUv($$20, $$11).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal($$16, 0.0f, -1.0f, 0.0f);
            $$9.addVertex($$16, $$18 * 0.2f, $$19 * 0.2f, 0.0f).setColor(-16777216).setUv($$20, $$10).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_114192_).setNormal($$16, 0.0f, -1.0f, 0.0f);
            $$13 = $$18;
            $$14 = $$19;
            $$15 = $$20;
        }
        p_114193_.popPose();
    }

    @Override
    public EnderDragonRenderState createRenderState() {
        return new EnderDragonRenderState();
    }

    @Override
    public void extractRenderState(EnderDragon p_361171_, EnderDragonRenderState p_363002_, float p_363418_) {
        super.extractRenderState(p_361171_, p_363002_, p_363418_);
        p_363002_.flapTime = Mth.lerp(p_363418_, p_361171_.oFlapTime, p_361171_.flapTime);
        p_363002_.deathTime = p_361171_.dragonDeathTime > 0 ? (float)p_361171_.dragonDeathTime + p_363418_ : 0.0f;
        p_363002_.hasRedOverlay = p_361171_.hurtTime > 0;
        EndCrystal $$3 = p_361171_.nearestCrystal;
        if ($$3 != null) {
            Vec3 $$4 = $$3.getPosition(p_363418_).add(0.0, EndCrystalRenderer.getY((float)$$3.time + p_363418_), 0.0);
            p_363002_.beamOffset = $$4.subtract(p_361171_.getPosition(p_363418_));
        } else {
            p_363002_.beamOffset = null;
        }
        DragonPhaseInstance $$5 = p_361171_.getPhaseManager().getCurrentPhase();
        p_363002_.isLandingOrTakingOff = $$5 == EnderDragonPhase.LANDING || $$5 == EnderDragonPhase.TAKEOFF;
        p_363002_.isSitting = $$5.isSitting();
        BlockPos $$6 = p_361171_.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.getLocation(p_361171_.getFightOrigin()));
        p_363002_.distanceToEgg = $$6.distToCenterSqr(p_361171_.position());
        p_363002_.partialTicks = p_361171_.isDeadOrDying() ? 0.0f : p_363418_;
        p_363002_.flightHistory.copyFrom(p_361171_.flightHistory);
    }

    @Override
    protected void extractAdditionalHitboxes(EnderDragon p_412673_, ImmutableList.Builder<HitboxRenderState> p_412323_, float p_412176_) {
        super.extractAdditionalHitboxes(p_412673_, p_412323_, p_412176_);
        double $$3 = -Mth.lerp((double)p_412176_, p_412673_.xOld, p_412673_.getX());
        double $$4 = -Mth.lerp((double)p_412176_, p_412673_.yOld, p_412673_.getY());
        double $$5 = -Mth.lerp((double)p_412176_, p_412673_.zOld, p_412673_.getZ());
        for (EnderDragonPart $$6 : p_412673_.getSubEntities()) {
            AABB $$7 = $$6.getBoundingBox();
            HitboxRenderState $$8 = new HitboxRenderState($$7.minX - $$6.getX(), $$7.minY - $$6.getY(), $$7.minZ - $$6.getZ(), $$7.maxX - $$6.getX(), $$7.maxY - $$6.getY(), $$7.maxZ - $$6.getZ(), (float)($$3 + Mth.lerp((double)p_412176_, $$6.xOld, $$6.getX())), (float)($$4 + Mth.lerp((double)p_412176_, $$6.yOld, $$6.getY())), (float)($$5 + Mth.lerp((double)p_412176_, $$6.zOld, $$6.getZ())), 0.25f, 1.0f, 0.0f);
            p_412323_.add((Object)$$8);
        }
    }

    @Override
    protected boolean affectedByCulling(EnderDragon p_361699_) {
        return false;
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }

    @Override
    protected /* synthetic */ boolean affectedByCulling(Entity entity) {
        return this.affectedByCulling((EnderDragon)entity);
    }
}

