/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EndCrystalModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EndCrystalRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.phys.Vec3;

public class EndCrystalRenderer
extends EntityRenderer<EndCrystal, EndCrystalRenderState> {
    private static final ResourceLocation END_CRYSTAL_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/end_crystal/end_crystal.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull(END_CRYSTAL_LOCATION);
    private final EndCrystalModel model;

    public EndCrystalRenderer(EntityRendererProvider.Context p_173970_) {
        super(p_173970_);
        this.shadowRadius = 0.5f;
        this.model = new EndCrystalModel(p_173970_.bakeLayer(ModelLayers.END_CRYSTAL));
    }

    @Override
    public void render(EndCrystalRenderState p_362403_, PoseStack p_114147_, MultiBufferSource p_114148_, int p_114149_) {
        p_114147_.pushPose();
        p_114147_.scale(2.0f, 2.0f, 2.0f);
        p_114147_.translate(0.0f, -0.5f, 0.0f);
        this.model.setupAnim(p_362403_);
        this.model.renderToBuffer(p_114147_, p_114148_.getBuffer(RENDER_TYPE), p_114149_, OverlayTexture.NO_OVERLAY);
        p_114147_.popPose();
        Vec3 $$4 = p_362403_.beamOffset;
        if ($$4 != null) {
            float $$5 = EndCrystalRenderer.getY(p_362403_.ageInTicks);
            float $$6 = (float)$$4.x;
            float $$7 = (float)$$4.y;
            float $$8 = (float)$$4.z;
            p_114147_.translate($$4);
            EnderDragonRenderer.renderCrystalBeams(-$$6, -$$7 + $$5, -$$8, p_362403_.ageInTicks, p_114147_, p_114148_, p_114149_);
        }
        super.render(p_362403_, p_114147_, p_114148_, p_114149_);
    }

    public static float getY(float p_114160_) {
        float $$1 = Mth.sin(p_114160_ * 0.2f) / 2.0f + 0.5f;
        $$1 = ($$1 * $$1 + $$1) * 0.4f;
        return $$1 - 1.4f;
    }

    @Override
    public EndCrystalRenderState createRenderState() {
        return new EndCrystalRenderState();
    }

    @Override
    public void extractRenderState(EndCrystal p_362185_, EndCrystalRenderState p_364683_, float p_362440_) {
        super.extractRenderState(p_362185_, p_364683_, p_362440_);
        p_364683_.ageInTicks = (float)p_362185_.time + p_362440_;
        p_364683_.showsBottom = p_362185_.showsBottom();
        BlockPos $$3 = p_362185_.getBeamTarget();
        p_364683_.beamOffset = $$3 != null ? Vec3.atCenterOf($$3).subtract(p_362185_.getPosition(p_362440_)) : null;
    }

    @Override
    public boolean shouldRender(EndCrystal p_114169_, Frustum p_114170_, double p_114171_, double p_114172_, double p_114173_) {
        return super.shouldRender(p_114169_, p_114170_, p_114171_, p_114172_, p_114173_) || p_114169_.getBeamTarget() != null;
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

