/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.CreeperPowerLayer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Creeper;

public class CreeperRenderer
extends MobRenderer<Creeper, CreeperRenderState, CreeperModel> {
    private static final ResourceLocation CREEPER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/creeper/creeper.png");

    public CreeperRenderer(EntityRendererProvider.Context p_173958_) {
        super(p_173958_, new CreeperModel(p_173958_.bakeLayer(ModelLayers.CREEPER)), 0.5f);
        this.addLayer(new CreeperPowerLayer(this, p_173958_.getModelSet()));
    }

    @Override
    protected void scale(CreeperRenderState p_362568_, PoseStack p_114047_) {
        float $$2 = p_362568_.swelling;
        float $$3 = 1.0f + Mth.sin($$2 * 100.0f) * $$2 * 0.01f;
        $$2 = Mth.clamp($$2, 0.0f, 1.0f);
        $$2 *= $$2;
        $$2 *= $$2;
        float $$4 = (1.0f + $$2 * 0.4f) * $$3;
        float $$5 = (1.0f + $$2 * 0.1f) / $$3;
        p_114047_.scale($$4, $$5, $$4);
    }

    @Override
    protected float getWhiteOverlayProgress(CreeperRenderState p_360678_) {
        float $$1 = p_360678_.swelling;
        if ((int)($$1 * 10.0f) % 2 == 0) {
            return 0.0f;
        }
        return Mth.clamp($$1, 0.5f, 1.0f);
    }

    @Override
    public ResourceLocation getTextureLocation(CreeperRenderState p_363813_) {
        return CREEPER_LOCATION;
    }

    @Override
    public CreeperRenderState createRenderState() {
        return new CreeperRenderState();
    }

    @Override
    public void extractRenderState(Creeper p_364394_, CreeperRenderState p_361451_, float p_364659_) {
        super.extractRenderState(p_364394_, p_361451_, p_364659_);
        p_361451_.swelling = p_364394_.getSwelling(p_364659_);
        p_361451_.isPowered = p_364394_.isPowered();
    }

    @Override
    protected /* synthetic */ float getWhiteOverlayProgress(LivingEntityRenderState livingEntityRenderState) {
        return this.getWhiteOverlayProgress((CreeperRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

