/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.BeeRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Bee;

public class BeeRenderer
extends AgeableMobRenderer<Bee, BeeRenderState, BeeModel> {
    private static final ResourceLocation ANGRY_BEE_TEXTURE = ResourceLocation.withDefaultNamespace("textures/entity/bee/bee_angry.png");
    private static final ResourceLocation ANGRY_NECTAR_BEE_TEXTURE = ResourceLocation.withDefaultNamespace("textures/entity/bee/bee_angry_nectar.png");
    private static final ResourceLocation BEE_TEXTURE = ResourceLocation.withDefaultNamespace("textures/entity/bee/bee.png");
    private static final ResourceLocation NECTAR_BEE_TEXTURE = ResourceLocation.withDefaultNamespace("textures/entity/bee/bee_nectar.png");

    public BeeRenderer(EntityRendererProvider.Context p_173931_) {
        super(p_173931_, new BeeModel(p_173931_.bakeLayer(ModelLayers.BEE)), new BeeModel(p_173931_.bakeLayer(ModelLayers.BEE_BABY)), 0.4f);
    }

    @Override
    public ResourceLocation getTextureLocation(BeeRenderState p_363810_) {
        if (p_363810_.isAngry) {
            if (p_363810_.hasNectar) {
                return ANGRY_NECTAR_BEE_TEXTURE;
            }
            return ANGRY_BEE_TEXTURE;
        }
        if (p_363810_.hasNectar) {
            return NECTAR_BEE_TEXTURE;
        }
        return BEE_TEXTURE;
    }

    @Override
    public BeeRenderState createRenderState() {
        return new BeeRenderState();
    }

    @Override
    public void extractRenderState(Bee p_362879_, BeeRenderState p_360596_, float p_365357_) {
        super.extractRenderState(p_362879_, p_360596_, p_365357_);
        p_360596_.rollAmount = p_362879_.getRollAmount(p_365357_);
        p_360596_.hasStinger = !p_362879_.hasStung();
        p_360596_.isOnGround = p_362879_.onGround() && p_362879_.getDeltaMovement().lengthSqr() < 1.0E-7;
        p_360596_.isAngry = p_362879_.isAngry();
        p_360596_.hasNectar = p_362879_.hasNectar();
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((BeeRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

