/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.AxolotlModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.AxolotlRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.axolotl.Axolotl;

public class AxolotlRenderer
extends AgeableMobRenderer<Axolotl, AxolotlRenderState, AxolotlModel> {
    private static final Map<Axolotl.Variant, ResourceLocation> TEXTURE_BY_TYPE = Util.make(Maps.newHashMap(), p_349898_ -> {
        for (Axolotl.Variant $$1 : Axolotl.Variant.values()) {
            p_349898_.put($$1, ResourceLocation.withDefaultNamespace(String.format(Locale.ROOT, "textures/entity/axolotl/axolotl_%s.png", $$1.getName())));
        }
    });

    public AxolotlRenderer(EntityRendererProvider.Context p_173921_) {
        super(p_173921_, new AxolotlModel(p_173921_.bakeLayer(ModelLayers.AXOLOTL)), new AxolotlModel(p_173921_.bakeLayer(ModelLayers.AXOLOTL_BABY)), 0.5f);
    }

    @Override
    public ResourceLocation getTextureLocation(AxolotlRenderState p_362427_) {
        return TEXTURE_BY_TYPE.get(p_362427_.variant);
    }

    @Override
    public AxolotlRenderState createRenderState() {
        return new AxolotlRenderState();
    }

    @Override
    public void extractRenderState(Axolotl p_363864_, AxolotlRenderState p_364989_, float p_363532_) {
        super.extractRenderState(p_363864_, p_364989_, p_363532_);
        p_364989_.variant = p_363864_.getVariant();
        p_364989_.playingDeadFactor = p_363864_.playingDeadAnimator.getFactor(p_363532_);
        p_364989_.inWaterFactor = p_363864_.inWaterAnimator.getFactor(p_363532_);
        p_364989_.onGroundFactor = p_363864_.onGroundAnimator.getFactor(p_363532_);
        p_364989_.movingFactor = p_363864_.movingAnimator.getFactor(p_363532_);
    }

    @Override
    public /* synthetic */ ResourceLocation getTextureLocation(LivingEntityRenderState livingEntityRenderState) {
        return this.getTextureLocation((AxolotlRenderState)livingEntityRenderState);
    }

    @Override
    public /* synthetic */ EntityRenderState createRenderState() {
        return this.createRenderState();
    }
}

