/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.network.protocol.common.custom.RedstoneWireOrientationsDebugPayload;
import net.minecraft.world.level.redstone.Orientation;
import org.joml.Vector3f;

public class RedstoneWireOrientationsRenderer
implements DebugRenderer.SimpleDebugRenderer {
    public static final int TIMEOUT = 200;
    private final Minecraft minecraft;
    private final List<RedstoneWireOrientationsDebugPayload> updatedWires = Lists.newArrayList();

    RedstoneWireOrientationsRenderer(Minecraft p_364109_) {
        this.minecraft = p_364109_;
    }

    public void addWireOrientations(RedstoneWireOrientationsDebugPayload p_365234_) {
        this.updatedWires.add(p_365234_);
    }

    @Override
    public void render(PoseStack p_363820_, MultiBufferSource p_363043_, double p_364261_, double p_361975_, double p_365341_) {
        VertexConsumer $$5 = p_363043_.getBuffer(RenderType.lines());
        long $$6 = this.minecraft.level.getGameTime();
        Iterator<RedstoneWireOrientationsDebugPayload> $$7 = this.updatedWires.iterator();
        while ($$7.hasNext()) {
            RedstoneWireOrientationsDebugPayload $$8 = $$7.next();
            long $$9 = $$6 - $$8.time();
            if ($$9 > 200L) {
                $$7.remove();
                continue;
            }
            for (RedstoneWireOrientationsDebugPayload.Wire $$10 : $$8.wires()) {
                Vector3f $$11 = $$10.pos().getBottomCenter().subtract(p_364261_, p_361975_ - 0.1, p_365341_).toVector3f();
                Orientation $$12 = $$10.orientation();
                ShapeRenderer.renderVector(p_363820_, $$5, $$11, $$12.getFront().getUnitVec3().scale(0.5), -16776961);
                ShapeRenderer.renderVector(p_363820_, $$5, $$11, $$12.getUp().getUnitVec3().scale(0.4), -65536);
                ShapeRenderer.renderVector(p_363820_, $$5, $$11, $$12.getSide().getUnitVec3().scale(0.3), -256);
            }
        }
    }
}

