/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.SectionBuffers;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.client.renderer.chunk.SectionMesh;
import net.minecraft.client.renderer.chunk.TranslucencyPointOfView;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CompiledSectionMesh
implements SectionMesh {
    public static final SectionMesh UNCOMPILED = new SectionMesh(){

        @Override
        public boolean facesCanSeeEachother(Direction p_427455_, Direction p_427422_) {
            return false;
        }
    };
    public static final SectionMesh EMPTY = new SectionMesh(){

        @Override
        public boolean facesCanSeeEachother(Direction p_427417_, Direction p_427302_) {
            return true;
        }
    };
    private final List<BlockEntity> renderableBlockEntities;
    private final VisibilitySet visibilitySet;
    @Nullable
    private final MeshData.SortState transparencyState;
    @Nullable
    private TranslucencyPointOfView translucencyPointOfView;
    private final Map<ChunkSectionLayer, SectionBuffers> buffers = new EnumMap<ChunkSectionLayer, SectionBuffers>(ChunkSectionLayer.class);

    public CompiledSectionMesh(TranslucencyPointOfView p_427516_, SectionCompiler.Results p_427448_) {
        this.translucencyPointOfView = p_427516_;
        this.visibilitySet = p_427448_.visibilitySet;
        this.renderableBlockEntities = p_427448_.blockEntities;
        this.transparencyState = p_427448_.transparencyState;
    }

    public void setTranslucencyPointOfView(TranslucencyPointOfView p_427440_) {
        this.translucencyPointOfView = p_427440_;
    }

    @Override
    public boolean isDifferentPointOfView(TranslucencyPointOfView p_427247_) {
        return !p_427247_.equals(this.translucencyPointOfView);
    }

    @Override
    public boolean hasRenderableLayers() {
        return !this.buffers.isEmpty();
    }

    @Override
    public boolean isEmpty(ChunkSectionLayer p_427390_) {
        return !this.buffers.containsKey((Object)p_427390_);
    }

    @Override
    public List<BlockEntity> getRenderableBlockEntities() {
        return this.renderableBlockEntities;
    }

    @Override
    public boolean facesCanSeeEachother(Direction p_427348_, Direction p_427368_) {
        return this.visibilitySet.visibilityBetween(p_427348_, p_427368_);
    }

    @Override
    @Nullable
    public SectionBuffers getBuffers(ChunkSectionLayer p_427316_) {
        return this.buffers.get((Object)p_427316_);
    }

    public void uploadMeshLayer(ChunkSectionLayer p_427297_, MeshData p_427250_, long p_427371_) {
        CommandEncoder $$3 = RenderSystem.getDevice().createCommandEncoder();
        SectionBuffers $$4 = this.getBuffers(p_427297_);
        if ($$4 != null) {
            if ($$4.getVertexBuffer().size() < p_427250_.vertexBuffer().remaining()) {
                $$4.getVertexBuffer().close();
                $$4.setVertexBuffer(RenderSystem.getDevice().createBuffer(() -> "Section vertex buffer - layer: " + p_427297_.label() + "; cords: " + SectionPos.x(p_427371_) + ", " + SectionPos.y(p_427371_) + ", " + SectionPos.z(p_427371_), 40, p_427250_.vertexBuffer()));
            } else if (!$$4.getVertexBuffer().isClosed()) {
                $$3.writeToBuffer($$4.getVertexBuffer().slice(), p_427250_.vertexBuffer());
            }
            ByteBuffer $$5 = p_427250_.indexBuffer();
            if ($$5 != null) {
                if ($$4.getIndexBuffer() == null || $$4.getIndexBuffer().size() < $$5.remaining()) {
                    if ($$4.getIndexBuffer() != null) {
                        $$4.getIndexBuffer().close();
                    }
                    $$4.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "Section index buffer - layer: " + p_427297_.label() + "; cords: " + SectionPos.x(p_427371_) + ", " + SectionPos.y(p_427371_) + ", " + SectionPos.z(p_427371_), 72, $$5));
                } else if (!$$4.getIndexBuffer().isClosed()) {
                    $$3.writeToBuffer($$4.getIndexBuffer().slice(), $$5);
                }
            } else if ($$4.getIndexBuffer() != null) {
                $$4.getIndexBuffer().close();
                $$4.setIndexBuffer(null);
            }
            $$4.setIndexCount(p_427250_.drawState().indexCount());
            $$4.setIndexType(p_427250_.drawState().indexType());
        } else {
            GpuBuffer $$6 = RenderSystem.getDevice().createBuffer(() -> "Section vertex buffer - layer: " + p_427297_.label() + "; cords: " + SectionPos.x(p_427371_) + ", " + SectionPos.y(p_427371_) + ", " + SectionPos.z(p_427371_), 40, p_427250_.vertexBuffer());
            ByteBuffer $$7 = p_427250_.indexBuffer();
            GpuBuffer $$8 = $$7 != null ? RenderSystem.getDevice().createBuffer(() -> "Section index buffer - layer: " + p_427297_.label() + "; cords: " + SectionPos.x(p_427371_) + ", " + SectionPos.y(p_427371_) + ", " + SectionPos.z(p_427371_), 72, $$7) : null;
            SectionBuffers $$9 = new SectionBuffers($$6, $$8, p_427250_.drawState().indexCount(), p_427250_.drawState().indexType());
            this.buffers.put(p_427297_, $$9);
        }
    }

    public void uploadLayerIndexBuffer(ChunkSectionLayer p_427505_, ByteBufferBuilder.Result p_427275_, long p_427419_) {
        SectionBuffers $$3 = this.getBuffers(p_427505_);
        if ($$3 == null) {
            return;
        }
        if ($$3.getIndexBuffer() == null) {
            $$3.setIndexBuffer(RenderSystem.getDevice().createBuffer(() -> "Section index buffer - layer: " + p_427505_.label() + "; cords: " + SectionPos.x(p_427419_) + ", " + SectionPos.y(p_427419_) + ", " + SectionPos.z(p_427419_), 72, p_427275_.byteBuffer()));
        } else {
            CommandEncoder $$4 = RenderSystem.getDevice().createCommandEncoder();
            if (!$$3.getIndexBuffer().isClosed()) {
                $$4.writeToBuffer($$3.getIndexBuffer().slice(), p_427275_.byteBuffer());
            }
        }
    }

    @Override
    public boolean hasTranslucentGeometry() {
        return this.buffers.containsKey((Object)ChunkSectionLayer.TRANSLUCENT);
    }

    @Nullable
    public MeshData.SortState getTransparencyState() {
        return this.transparencyState;
    }

    @Override
    public void close() {
        this.buffers.values().forEach(SectionBuffers::close);
        this.buffers.clear();
    }
}

