/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class VaultRenderer
implements BlockEntityRenderer<VaultBlockEntity> {
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();
    private final ItemClusterRenderState renderState = new ItemClusterRenderState();

    public VaultRenderer(BlockEntityRendererProvider.Context p_324525_) {
        this.itemModelResolver = p_324525_.getItemModelResolver();
    }

    @Override
    public void render(VaultBlockEntity p_323921_, float p_324166_, PoseStack p_324316_, MultiBufferSource p_323716_, int p_324311_, int p_324178_, Vec3 p_401121_) {
        if (!VaultBlockEntity.Client.shouldDisplayActiveEffects(p_323921_.getSharedData())) {
            return;
        }
        Level $$7 = p_323921_.getLevel();
        if ($$7 == null) {
            return;
        }
        ItemStack $$8 = p_323921_.getSharedData().getDisplayItem();
        if ($$8.isEmpty()) {
            return;
        }
        this.itemModelResolver.updateForTopItem(this.renderState.item, $$8, ItemDisplayContext.GROUND, $$7, null, 0);
        this.renderState.count = ItemClusterRenderState.getRenderedAmount($$8.getCount());
        this.renderState.seed = ItemClusterRenderState.getSeedForItemStack($$8);
        VaultClientData $$9 = p_323921_.getClientData();
        p_324316_.pushPose();
        p_324316_.translate(0.5f, 0.4f, 0.5f);
        p_324316_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.rotLerp(p_324166_, $$9.previousSpin(), $$9.currentSpin())));
        ItemEntityRenderer.renderMultipleFromCount(p_324316_, p_323716_, p_324311_, this.renderState, this.random);
        p_324316_.popPose();
    }
}

