/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.AbstractSignRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class HangingSignRenderer
extends AbstractSignRenderer {
    private static final String PLANK = "plank";
    private static final String V_CHAINS = "vChains";
    private static final String NORMAL_CHAINS = "normalChains";
    private static final String CHAIN_L_1 = "chainL1";
    private static final String CHAIN_L_2 = "chainL2";
    private static final String CHAIN_R_1 = "chainR1";
    private static final String CHAIN_R_2 = "chainR2";
    private static final String BOARD = "board";
    public static final float MODEL_RENDER_SCALE = 1.0f;
    private static final float TEXT_RENDER_SCALE = 0.9f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, -0.32f, 0.073f);
    private final Map<ModelKey, Model> hangingSignModels;

    public HangingSignRenderer(BlockEntityRendererProvider.Context p_248772_) {
        super(p_248772_);
        Stream $$1 = WoodType.values().flatMap(p_382549_ -> Arrays.stream(AttachmentType.values()).map(p_382553_ -> new ModelKey((WoodType)p_382549_, (AttachmentType)p_382553_)));
        this.hangingSignModels = (Map)$$1.collect(ImmutableMap.toImmutableMap(p_382879_ -> p_382879_, p_389337_ -> HangingSignRenderer.createSignModel(p_248772_.getModelSet(), p_389337_.woodType, p_389337_.attachmentType)));
    }

    public static Model createSignModel(EntityModelSet p_389708_, WoodType p_389565_, AttachmentType p_389605_) {
        return new Model.Simple(p_389708_.bakeLayer(ModelLayers.createHangingSignModelName(p_389565_, p_389605_)), RenderType::entityCutoutNoCull);
    }

    @Override
    protected float getSignModelRenderScale() {
        return 1.0f;
    }

    @Override
    protected float getSignTextRenderScale() {
        return 0.9f;
    }

    public static void translateBase(PoseStack p_389495_, float p_389681_) {
        p_389495_.translate(0.5, 0.9375, 0.5);
        p_389495_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(p_389681_));
        p_389495_.translate(0.0f, -0.3125f, 0.0f);
    }

    @Override
    protected void translateSign(PoseStack p_277807_, float p_277917_, BlockState p_277638_) {
        HangingSignRenderer.translateBase(p_277807_, p_277917_);
    }

    @Override
    protected Model getSignModel(BlockState p_389435_, WoodType p_389454_) {
        AttachmentType $$2 = AttachmentType.byBlockState(p_389435_);
        return this.hangingSignModels.get(new ModelKey(p_389454_, $$2));
    }

    @Override
    protected Material getSignMaterial(WoodType p_251791_) {
        return Sheets.getHangingSignMaterial(p_251791_);
    }

    @Override
    protected Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    public static void renderInHand(PoseStack p_389446_, MultiBufferSource p_389729_, int p_389488_, int p_389717_, Model p_389611_, Material p_389587_) {
        p_389446_.pushPose();
        HangingSignRenderer.translateBase(p_389446_, 0.0f);
        p_389446_.scale(1.0f, -1.0f, -1.0f);
        VertexConsumer $$6 = p_389587_.buffer(p_389729_, p_389611_::renderType);
        p_389611_.renderToBuffer(p_389446_, $$6, p_389488_, p_389717_);
        p_389446_.popPose();
    }

    public static LayerDefinition createHangingSignLayer(AttachmentType p_382784_) {
        MeshDefinition $$1 = new MeshDefinition();
        PartDefinition $$2 = $$1.getRoot();
        $$2.addOrReplaceChild(BOARD, CubeListBuilder.create().texOffs(0, 12).addBox(-7.0f, 0.0f, -1.0f, 14.0f, 10.0f, 2.0f), PartPose.ZERO);
        if (p_382784_ == AttachmentType.WALL) {
            $$2.addOrReplaceChild(PLANK, CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -6.0f, -2.0f, 16.0f, 2.0f, 4.0f), PartPose.ZERO);
        }
        if (p_382784_ == AttachmentType.WALL || p_382784_ == AttachmentType.CEILING) {
            PartDefinition $$3 = $$2.addOrReplaceChild(NORMAL_CHAINS, CubeListBuilder.create(), PartPose.ZERO);
            $$3.addOrReplaceChild(CHAIN_L_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(-5.0f, -6.0f, 0.0f, 0.0f, -0.7853982f, 0.0f));
            $$3.addOrReplaceChild(CHAIN_L_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(-5.0f, -6.0f, 0.0f, 0.0f, 0.7853982f, 0.0f));
            $$3.addOrReplaceChild(CHAIN_R_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(5.0f, -6.0f, 0.0f, 0.0f, -0.7853982f, 0.0f));
            $$3.addOrReplaceChild(CHAIN_R_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(5.0f, -6.0f, 0.0f, 0.0f, 0.7853982f, 0.0f));
        }
        if (p_382784_ == AttachmentType.CEILING_MIDDLE) {
            $$2.addOrReplaceChild(V_CHAINS, CubeListBuilder.create().texOffs(14, 6).addBox(-6.0f, -6.0f, 0.0f, 12.0f, 6.0f, 0.0f), PartPose.ZERO);
        }
        return LayerDefinition.create($$1, 64, 32);
    }

    public static enum AttachmentType implements StringRepresentable
    {
        WALL("wall"),
        CEILING("ceiling"),
        CEILING_MIDDLE("ceiling_middle");

        private final String name;

        private AttachmentType(String p_382886_) {
            this.name = p_382886_;
        }

        public static AttachmentType byBlockState(BlockState p_383233_) {
            if (p_383233_.getBlock() instanceof CeilingHangingSignBlock) {
                return p_383233_.getValue(BlockStateProperties.ATTACHED) != false ? CEILING_MIDDLE : CEILING;
            }
            return WALL;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }

    public record ModelKey(WoodType woodType, AttachmentType attachmentType) {
    }
}

