/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MaterialMapper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ConduitRenderer
implements BlockEntityRenderer<ConduitBlockEntity> {
    public static final MaterialMapper MAPPER = new MaterialMapper(TextureAtlas.LOCATION_BLOCKS, "entity/conduit");
    public static final Material SHELL_TEXTURE = MAPPER.defaultNamespaceApply("base");
    public static final Material ACTIVE_SHELL_TEXTURE = MAPPER.defaultNamespaceApply("cage");
    public static final Material WIND_TEXTURE = MAPPER.defaultNamespaceApply("wind");
    public static final Material VERTICAL_WIND_TEXTURE = MAPPER.defaultNamespaceApply("wind_vertical");
    public static final Material OPEN_EYE_TEXTURE = MAPPER.defaultNamespaceApply("open_eye");
    public static final Material CLOSED_EYE_TEXTURE = MAPPER.defaultNamespaceApply("closed_eye");
    private final ModelPart eye;
    private final ModelPart wind;
    private final ModelPart shell;
    private final ModelPart cage;
    private final BlockEntityRenderDispatcher renderer;

    public ConduitRenderer(BlockEntityRendererProvider.Context p_173613_) {
        this.renderer = p_173613_.getBlockEntityRenderDispatcher();
        this.eye = p_173613_.bakeLayer(ModelLayers.CONDUIT_EYE);
        this.wind = p_173613_.bakeLayer(ModelLayers.CONDUIT_WIND);
        this.shell = p_173613_.bakeLayer(ModelLayers.CONDUIT_SHELL);
        this.cage = p_173613_.bakeLayer(ModelLayers.CONDUIT_CAGE);
    }

    public static LayerDefinition createEyeLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("eye", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.ZERO);
        return LayerDefinition.create($$0, 16, 16);
    }

    public static LayerDefinition createWindLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("wind", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create($$0, 64, 32);
    }

    public static LayerDefinition createShellLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.ZERO);
        return LayerDefinition.create($$0, 32, 16);
    }

    public static LayerDefinition createCageLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("shell", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        return LayerDefinition.create($$0, 32, 16);
    }

    @Override
    public void render(ConduitBlockEntity p_112399_, float p_112400_, PoseStack p_112401_, MultiBufferSource p_112402_, int p_112403_, int p_112404_, Vec3 p_401311_) {
        float $$7 = (float)p_112399_.tickCount + p_112400_;
        if (!p_112399_.isActive()) {
            float $$8 = p_112399_.getActiveRotation(0.0f);
            VertexConsumer $$9 = SHELL_TEXTURE.buffer(p_112402_, RenderType::entitySolid);
            p_112401_.pushPose();
            p_112401_.translate(0.5f, 0.5f, 0.5f);
            p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationY($$8 * ((float)Math.PI / 180)));
            this.shell.render(p_112401_, $$9, p_112403_, p_112404_);
            p_112401_.popPose();
            return;
        }
        float $$10 = p_112399_.getActiveRotation(p_112400_) * 57.295776f;
        float $$11 = Mth.sin($$7 * 0.1f) / 2.0f + 0.5f;
        $$11 = $$11 * $$11 + $$11;
        p_112401_.pushPose();
        p_112401_.translate(0.5f, 0.3f + $$11 * 0.2f, 0.5f);
        Vector3f $$12 = new Vector3f(0.5f, 1.0f, 0.5f).normalize();
        p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationAxis($$10 * ((float)Math.PI / 180), (Vector3fc)$$12));
        this.cage.render(p_112401_, ACTIVE_SHELL_TEXTURE.buffer(p_112402_, RenderType::entityCutoutNoCull), p_112403_, p_112404_);
        p_112401_.popPose();
        int $$13 = p_112399_.tickCount / 66 % 3;
        p_112401_.pushPose();
        p_112401_.translate(0.5f, 0.5f, 0.5f);
        if ($$13 == 1) {
            p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationX(1.5707964f));
        } else if ($$13 == 2) {
            p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationZ(1.5707964f));
        }
        VertexConsumer $$14 = ($$13 == 1 ? VERTICAL_WIND_TEXTURE : WIND_TEXTURE).buffer(p_112402_, RenderType::entityCutoutNoCull);
        this.wind.render(p_112401_, $$14, p_112403_, p_112404_);
        p_112401_.popPose();
        p_112401_.pushPose();
        p_112401_.translate(0.5f, 0.5f, 0.5f);
        p_112401_.scale(0.875f, 0.875f, 0.875f);
        p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationXYZ((float)Math.PI, 0.0f, (float)Math.PI));
        this.wind.render(p_112401_, $$14, p_112403_, p_112404_);
        p_112401_.popPose();
        Camera $$15 = this.renderer.camera;
        p_112401_.pushPose();
        p_112401_.translate(0.5f, 0.3f + $$11 * 0.2f, 0.5f);
        p_112401_.scale(0.5f, 0.5f, 0.5f);
        float $$16 = -$$15.getYRot();
        p_112401_.mulPose((Quaternionfc)new Quaternionf().rotationYXZ($$16 * ((float)Math.PI / 180), $$15.getXRot() * ((float)Math.PI / 180), (float)Math.PI));
        float $$17 = 1.3333334f;
        p_112401_.scale(1.3333334f, 1.3333334f, 1.3333334f);
        this.eye.render(p_112401_, (p_112399_.isHunting() ? OPEN_EYE_TEXTURE : CLOSED_EYE_TEXTURE).buffer(p_112402_, RenderType::entityCutoutNoCull), p_112403_, p_112404_);
        p_112401_.popPose();
    }
}

