/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class BlockEntityWithBoundingBoxRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public BlockEntityWithBoundingBoxRenderer(BlockEntityRendererProvider.Context p_397760_) {
    }

    @Override
    public void render(T p_397324_, float p_397611_, PoseStack p_397388_, MultiBufferSource p_397625_, int p_397985_, int p_397795_, Vec3 p_401190_) {
        if (!Minecraft.getInstance().player.canUseGameMasterBlocks() && !Minecraft.getInstance().player.isSpectator()) {
            return;
        }
        BoundingBoxRenderable.Mode $$7 = ((BoundingBoxRenderable)p_397324_).renderMode();
        if ($$7 == BoundingBoxRenderable.Mode.NONE) {
            return;
        }
        BoundingBoxRenderable.RenderableBox $$8 = ((BoundingBoxRenderable)p_397324_).getRenderableBox();
        BlockPos $$9 = $$8.localPos();
        Vec3i $$10 = $$8.size();
        if ($$10.getX() < 1 || $$10.getY() < 1 || $$10.getZ() < 1) {
            return;
        }
        float $$11 = 1.0f;
        float $$12 = 0.9f;
        float $$13 = 0.5f;
        VertexConsumer $$14 = p_397625_.getBuffer(RenderType.lines());
        BlockPos $$15 = $$9.offset($$10);
        ShapeRenderer.renderLineBox(p_397388_, $$14, $$9.getX(), $$9.getY(), $$9.getZ(), $$15.getX(), $$15.getY(), $$15.getZ(), 0.9f, 0.9f, 0.9f, 1.0f, 0.5f, 0.5f, 0.5f);
        if ($$7 == BoundingBoxRenderable.Mode.BOX_AND_INVISIBLE_BLOCKS && ((BlockEntity)p_397324_).getLevel() != null) {
            this.renderInvisibleBlocks(p_397324_, ((BlockEntity)p_397324_).getLevel(), $$9, $$10, p_397625_, p_397388_);
        }
    }

    private void renderInvisibleBlocks(T p_397069_, BlockGetter p_397190_, BlockPos p_397106_, Vec3i p_397027_, MultiBufferSource p_397495_, PoseStack p_396990_) {
        VertexConsumer $$6 = p_397495_.getBuffer(RenderType.lines());
        BlockPos $$7 = ((BlockEntity)p_397069_).getBlockPos();
        BlockPos $$8 = $$7.offset(p_397106_);
        for (BlockPos $$9 : BlockPos.betweenClosed($$8, $$8.offset(p_397027_).offset(-1, -1, -1))) {
            boolean $$15;
            BlockState $$10 = p_397190_.getBlockState($$9);
            boolean $$11 = $$10.isAir();
            boolean $$12 = $$10.is(Blocks.STRUCTURE_VOID);
            boolean $$13 = $$10.is(Blocks.BARRIER);
            boolean $$14 = $$10.is(Blocks.LIGHT);
            boolean bl = $$15 = $$12 || $$13 || $$14;
            if (!$$11 && !$$15) continue;
            float $$16 = $$11 ? 0.05f : 0.0f;
            double $$17 = (float)($$9.getX() - $$7.getX()) + 0.45f - $$16;
            double $$18 = (float)($$9.getY() - $$7.getY()) + 0.45f - $$16;
            double $$19 = (float)($$9.getZ() - $$7.getZ()) + 0.45f - $$16;
            double $$20 = (float)($$9.getX() - $$7.getX()) + 0.55f + $$16;
            double $$21 = (float)($$9.getY() - $$7.getY()) + 0.55f + $$16;
            double $$22 = (float)($$9.getZ() - $$7.getZ()) + 0.55f + $$16;
            if ($$11) {
                ShapeRenderer.renderLineBox(p_396990_, $$6, $$17, $$18, $$19, $$20, $$21, $$22, 0.5f, 0.5f, 1.0f, 1.0f, 0.5f, 0.5f, 1.0f);
                continue;
            }
            if ($$12) {
                ShapeRenderer.renderLineBox(p_396990_, $$6, $$17, $$18, $$19, $$20, $$21, $$22, 1.0f, 0.75f, 0.75f, 1.0f, 1.0f, 0.75f, 0.75f);
                continue;
            }
            if ($$13) {
                ShapeRenderer.renderLineBox(p_396990_, $$6, $$17, $$18, $$19, $$20, $$21, $$22, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f);
                continue;
            }
            if (!$$14) continue;
            ShapeRenderer.renderLineBox(p_396990_, $$6, $$17, $$18, $$19, $$20, $$21, $$22, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    private void renderStructureVoids(T p_397113_, BlockPos p_397422_, Vec3i p_398022_, VertexConsumer p_397021_, PoseStack p_397646_) {
        Level $$5 = ((BlockEntity)p_397113_).getLevel();
        if ($$5 == null) {
            return;
        }
        BlockPos $$6 = ((BlockEntity)p_397113_).getBlockPos();
        BitSetDiscreteVoxelShape $$7 = new BitSetDiscreteVoxelShape(p_398022_.getX(), p_398022_.getY(), p_398022_.getZ());
        for (BlockPos $$8 : BlockPos.betweenClosed(p_397422_, p_397422_.offset(p_398022_).offset(-1, -1, -1))) {
            if (!$$5.getBlockState($$8).is(Blocks.STRUCTURE_VOID)) continue;
            ((DiscreteVoxelShape)$$7).fill($$8.getX() - p_397422_.getX(), $$8.getY() - p_397422_.getY(), $$8.getZ() - p_397422_.getZ());
        }
        $$7.forAllFaces((p_397952_, p_397448_, p_397536_, p_397862_) -> {
            float $$8 = 0.48f;
            float $$9 = (float)(p_397448_ + p_397422_.getX() - $$6.getX()) + 0.5f - 0.48f;
            float $$10 = (float)(p_397536_ + p_397422_.getY() - $$6.getY()) + 0.5f - 0.48f;
            float $$11 = (float)(p_397862_ + p_397422_.getZ() - $$6.getZ()) + 0.5f - 0.48f;
            float $$12 = (float)(p_397448_ + p_397422_.getX() - $$6.getX()) + 0.5f + 0.48f;
            float $$13 = (float)(p_397536_ + p_397422_.getY() - $$6.getY()) + 0.5f + 0.48f;
            float $$14 = (float)(p_397862_ + p_397422_.getZ() - $$6.getZ()) + 0.5f + 0.48f;
            ShapeRenderer.renderFace(p_397646_, p_397021_, p_397952_, $$9, $$10, $$11, $$12, $$13, $$14, 0.75f, 0.75f, 1.0f, 0.2f);
        });
    }

    @Override
    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    public int getViewDistance() {
        return 96;
    }
}

