/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.model.BannerFlagModel;
import net.minecraft.client.model.BannerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BannerRenderer
implements BlockEntityRenderer<BannerBlockEntity> {
    private static final int MAX_PATTERNS = 16;
    private static final float SIZE = 0.6666667f;
    private final BannerModel standingModel;
    private final BannerModel wallModel;
    private final BannerFlagModel standingFlagModel;
    private final BannerFlagModel wallFlagModel;

    public BannerRenderer(BlockEntityRendererProvider.Context p_173521_) {
        this(p_173521_.getModelSet());
    }

    public BannerRenderer(EntityModelSet p_387622_) {
        this.standingModel = new BannerModel(p_387622_.bakeLayer(ModelLayers.STANDING_BANNER));
        this.wallModel = new BannerModel(p_387622_.bakeLayer(ModelLayers.WALL_BANNER));
        this.standingFlagModel = new BannerFlagModel(p_387622_.bakeLayer(ModelLayers.STANDING_BANNER_FLAG));
        this.wallFlagModel = new BannerFlagModel(p_387622_.bakeLayer(ModelLayers.WALL_BANNER_FLAG));
    }

    @Override
    public void render(BannerBlockEntity p_112052_, float p_112053_, PoseStack p_112054_, MultiBufferSource p_112055_, int p_112056_, int p_112057_, Vec3 p_401132_) {
        BannerFlagModel $$13;
        BannerModel $$12;
        float $$11;
        BlockState $$7 = p_112052_.getBlockState();
        if ($$7.getBlock() instanceof BannerBlock) {
            float $$8 = -RotationSegment.convertToDegrees($$7.getValue(BannerBlock.ROTATION));
            BannerModel $$9 = this.standingModel;
            BannerFlagModel $$10 = this.standingFlagModel;
        } else {
            $$11 = -$$7.getValue(WallBannerBlock.FACING).toYRot();
            $$12 = this.wallModel;
            $$13 = this.wallFlagModel;
        }
        long $$14 = p_112052_.getLevel().getGameTime();
        BlockPos $$15 = p_112052_.getBlockPos();
        float $$16 = ((float)Math.floorMod((long)($$15.getX() * 7 + $$15.getY() * 9 + $$15.getZ() * 13) + $$14, 100L) + p_112053_) / 100.0f;
        BannerRenderer.renderBanner(p_112054_, p_112055_, p_112056_, p_112057_, $$11, $$12, $$13, $$16, p_112052_.getBaseColor(), p_112052_.getPatterns());
    }

    public void renderInHand(PoseStack p_387128_, MultiBufferSource p_387289_, int p_386943_, int p_387938_, DyeColor p_388253_, BannerPatternLayers p_388428_) {
        BannerRenderer.renderBanner(p_387128_, p_387289_, p_386943_, p_387938_, 0.0f, this.standingModel, this.standingFlagModel, 0.0f, p_388253_, p_388428_);
    }

    private static void renderBanner(PoseStack p_388373_, MultiBufferSource p_388314_, int p_386449_, int p_388689_, float p_387344_, BannerModel p_386469_, BannerFlagModel p_387874_, float p_387444_, DyeColor p_388367_, BannerPatternLayers p_388938_) {
        p_388373_.pushPose();
        p_388373_.translate(0.5f, 0.0f, 0.5f);
        p_388373_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(p_387344_));
        p_388373_.scale(0.6666667f, -0.6666667f, -0.6666667f);
        p_386469_.renderToBuffer(p_388373_, ModelBakery.BANNER_BASE.buffer(p_388314_, RenderType::entitySolid), p_386449_, p_388689_);
        p_387874_.setupAnim(p_387444_);
        BannerRenderer.renderPatterns(p_388373_, p_388314_, p_386449_, p_388689_, p_387874_.root(), ModelBakery.BANNER_BASE, true, p_388367_, p_388938_);
        p_388373_.popPose();
    }

    public static void renderPatterns(PoseStack p_112066_, MultiBufferSource p_112067_, int p_112068_, int p_112069_, ModelPart p_112070_, Material p_112071_, boolean p_112072_, DyeColor p_332660_, BannerPatternLayers p_330986_) {
        BannerRenderer.renderPatterns(p_112066_, p_112067_, p_112068_, p_112069_, p_112070_, p_112071_, p_112072_, p_332660_, p_330986_, false, true);
    }

    public static void renderPatterns(PoseStack p_112075_, MultiBufferSource p_112076_, int p_112077_, int p_112078_, ModelPart p_112079_, Material p_112080_, boolean p_112081_, DyeColor p_332652_, BannerPatternLayers p_331851_, boolean p_332823_, boolean p_364162_) {
        p_112079_.render(p_112075_, p_112080_.buffer(p_112076_, RenderType::entitySolid, p_364162_, p_332823_), p_112077_, p_112078_);
        BannerRenderer.renderPatternLayer(p_112075_, p_112076_, p_112077_, p_112078_, p_112079_, p_112081_ ? Sheets.BANNER_BASE : Sheets.SHIELD_BASE, p_332652_);
        for (int $$11 = 0; $$11 < 16 && $$11 < p_331851_.layers().size(); ++$$11) {
            BannerPatternLayers.Layer $$12 = p_331851_.layers().get($$11);
            Material $$13 = p_112081_ ? Sheets.getBannerMaterial($$12.pattern()) : Sheets.getShieldMaterial($$12.pattern());
            BannerRenderer.renderPatternLayer(p_112075_, p_112076_, p_112077_, p_112078_, p_112079_, $$13, $$12.color());
        }
    }

    private static void renderPatternLayer(PoseStack p_332737_, MultiBufferSource p_332758_, int p_332821_, int p_332828_, ModelPart p_332732_, Material p_332704_, DyeColor p_332728_) {
        int $$7 = p_332728_.getTextureDiffuseColor();
        p_332732_.render(p_332737_, p_332704_.buffer(p_332758_, RenderType::entityNoOutline), p_332821_, p_332828_, $$7);
    }

    public void getExtents(Set<Vector3f> p_428247_) {
        PoseStack $$1 = new PoseStack();
        $$1.translate(0.5f, 0.0f, 0.5f);
        $$1.scale(0.6666667f, -0.6666667f, -0.6666667f);
        this.standingModel.root().getExtentsForGui($$1, p_428247_);
        this.standingFlagModel.setupAnim(0.0f);
        this.standingFlagModel.root().getExtentsForGui($$1, p_428247_);
    }
}

