/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class MultiPartModel
implements BlockStateModel {
    private final SharedBakedState shared;
    private final BlockState blockState;
    @Nullable
    private List<BlockStateModel> models;

    MultiPartModel(SharedBakedState p_409947_, BlockState p_410377_) {
        this.shared = p_409947_;
        this.blockState = p_410377_;
    }

    @Override
    public TextureAtlasSprite particleIcon() {
        return this.shared.particleIcon;
    }

    @Override
    public void collectParts(RandomSource p_410101_, List<BlockModelPart> p_410550_) {
        if (this.models == null) {
            this.models = this.shared.selectModels(this.blockState);
        }
        long $$2 = p_410101_.nextLong();
        for (BlockStateModel $$3 : this.models) {
            p_410101_.setSeed($$2);
            $$3.collectParts(p_410101_, p_410550_);
        }
    }

    static final class SharedBakedState {
        private final List<Selector<BlockStateModel>> selectors;
        final TextureAtlasSprite particleIcon;
        private final Map<BitSet, List<BlockStateModel>> subsets = new ConcurrentHashMap<BitSet, List<BlockStateModel>>();

        private static BlockStateModel getFirstModel(List<Selector<BlockStateModel>> p_409686_) {
            if (p_409686_.isEmpty()) {
                throw new IllegalArgumentException("Model must have at least one selector");
            }
            return p_409686_.getFirst().model();
        }

        public SharedBakedState(List<Selector<BlockStateModel>> p_410541_) {
            this.selectors = p_410541_;
            BlockStateModel $$1 = SharedBakedState.getFirstModel(p_410541_);
            this.particleIcon = $$1.particleIcon();
        }

        public List<BlockStateModel> selectModels(BlockState p_410842_) {
            BitSet $$1 = new BitSet();
            for (int $$2 = 0; $$2 < this.selectors.size(); ++$$2) {
                if (!this.selectors.get((int)$$2).condition.test(p_410842_)) continue;
                $$1.set($$2);
            }
            return this.subsets.computeIfAbsent($$1, p_409792_ -> {
                ImmutableList.Builder $$1 = ImmutableList.builder();
                for (int $$2 = 0; $$2 < this.selectors.size(); ++$$2) {
                    if (!p_409792_.get($$2)) continue;
                    $$1.add((Object)((BlockStateModel)this.selectors.get((int)$$2).model));
                }
                return $$1.build();
            });
        }
    }

    public static class Unbaked
    implements BlockStateModel.UnbakedRoot {
        final List<Selector<BlockStateModel.Unbaked>> selectors;
        private final ModelBaker.SharedOperationKey<SharedBakedState> sharedStateKey = new ModelBaker.SharedOperationKey<SharedBakedState>(){

            @Override
            public SharedBakedState compute(ModelBaker p_410269_) {
                ImmutableList.Builder $$1 = ImmutableList.builderWithExpectedSize((int)selectors.size());
                for (Selector<BlockStateModel.Unbaked> $$2 : selectors) {
                    $$1.add($$2.with(((BlockStateModel.Unbaked)$$2.model).bake(p_410269_)));
                }
                return new SharedBakedState((List<Selector<BlockStateModel>>)$$1.build());
            }

            @Override
            public /* synthetic */ Object compute(ModelBaker modelBaker) {
                return this.compute(modelBaker);
            }
        };

        public Unbaked(List<Selector<BlockStateModel.Unbaked>> p_410734_) {
            this.selectors = p_410734_;
        }

        @Override
        public Object visualEqualityGroup(BlockState p_409924_) {
            IntArrayList $$1 = new IntArrayList();
            for (int $$2 = 0; $$2 < this.selectors.size(); ++$$2) {
                if (!this.selectors.get((int)$$2).condition.test(p_409924_)) continue;
                $$1.add($$2);
            }
            record Key(Unbaked model, IntList selectors) {
            }
            return new Key(this, (IntList)$$1);
        }

        @Override
        public void resolveDependencies(ResolvableModel.Resolver p_410079_) {
            this.selectors.forEach(p_410388_ -> ((BlockStateModel.Unbaked)p_410388_.model).resolveDependencies(p_410079_));
        }

        @Override
        public BlockStateModel bake(BlockState p_410876_, ModelBaker p_410500_) {
            SharedBakedState $$2 = p_410500_.compute(this.sharedStateKey);
            return new MultiPartModel($$2, p_410876_);
        }
    }

    public record Selector<T>(Predicate<BlockState> condition, T model) {
        public <S> Selector<S> with(S p_409701_) {
            return new Selector<S>(this.condition, p_409701_);
        }
    }
}

