/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.math.Quadrant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ItemModelGenerator
implements UnbakedModel {
    public static final ResourceLocation GENERATED_ITEM_MODEL_ID = ResourceLocation.withDefaultNamespace("builtin/generated");
    public static final List<String> LAYERS = List.of("layer0", "layer1", "layer2", "layer3", "layer4");
    private static final float MIN_Z = 7.5f;
    private static final float MAX_Z = 8.5f;
    private static final TextureSlots.Data TEXTURE_SLOTS = new TextureSlots.Data.Builder().addReference("particle", "layer0").build();
    private static final BlockElementFace.UVs SOUTH_FACE_UVS = new BlockElementFace.UVs(0.0f, 0.0f, 16.0f, 16.0f);
    private static final BlockElementFace.UVs NORTH_FACE_UVS = new BlockElementFace.UVs(16.0f, 0.0f, 0.0f, 16.0f);

    @Override
    public TextureSlots.Data textureSlots() {
        return TEXTURE_SLOTS;
    }

    @Override
    public UnbakedGeometry geometry() {
        return ItemModelGenerator::bake;
    }

    @Override
    @Nullable
    public UnbakedModel.GuiLight guiLight() {
        return UnbakedModel.GuiLight.FRONT;
    }

    private static QuadCollection bake(TextureSlots p_387202_, ModelBaker p_405519_, ModelState p_387172_, ModelDebugName p_405600_) {
        return ItemModelGenerator.bake(p_387202_, p_405519_.sprites(), p_387172_, p_405600_);
    }

    private static QuadCollection bake(TextureSlots p_386773_, SpriteGetter p_405238_, ModelState p_386536_, ModelDebugName p_404999_) {
        String $$6;
        Material $$7;
        ArrayList<BlockElement> $$4 = new ArrayList<BlockElement>();
        for (int $$5 = 0; $$5 < LAYERS.size() && ($$7 = p_386773_.getMaterial($$6 = LAYERS.get($$5))) != null; ++$$5) {
            SpriteContents $$8 = p_405238_.get($$7, p_404999_).contents();
            $$4.addAll(ItemModelGenerator.processFrames($$5, $$6, $$8));
        }
        return SimpleUnbakedGeometry.bake($$4, p_386773_, p_405238_, p_386536_, p_404999_);
    }

    private static List<BlockElement> processFrames(int p_111639_, String p_111640_, SpriteContents p_251768_) {
        Map<Direction, BlockElementFace> $$3 = Map.of(Direction.SOUTH, new BlockElementFace(null, p_111639_, p_111640_, SOUTH_FACE_UVS, Quadrant.R0), Direction.NORTH, new BlockElementFace(null, p_111639_, p_111640_, NORTH_FACE_UVS, Quadrant.R0));
        ArrayList<BlockElement> $$4 = new ArrayList<BlockElement>();
        $$4.add(new BlockElement((Vector3fc)new Vector3f(0.0f, 0.0f, 7.5f), (Vector3fc)new Vector3f(16.0f, 16.0f, 8.5f), $$3));
        $$4.addAll(ItemModelGenerator.createSideElements(p_251768_, p_111640_, p_111639_));
        return $$4;
    }

    private static List<BlockElement> createSideElements(SpriteContents p_248810_, String p_111663_, int p_111664_) {
        float $$3 = p_248810_.width();
        float $$4 = p_248810_.height();
        ArrayList<BlockElement> $$5 = new ArrayList<BlockElement>();
        for (Span $$6 : ItemModelGenerator.getSpans(p_248810_)) {
            float $$7 = 0.0f;
            float $$8 = 0.0f;
            float $$9 = 0.0f;
            float $$10 = 0.0f;
            float $$11 = 0.0f;
            float $$12 = 0.0f;
            float $$13 = 0.0f;
            float $$14 = 0.0f;
            float $$15 = 16.0f / $$3;
            float $$16 = 16.0f / $$4;
            float $$17 = $$6.getMin();
            float $$18 = $$6.getMax();
            float $$19 = $$6.getAnchor();
            SpanFacing $$20 = $$6.getFacing();
            switch ($$20.ordinal()) {
                case 0: {
                    $$7 = $$11 = $$17;
                    $$9 = $$12 = $$18 + 1.0f;
                    $$8 = $$13 = $$19;
                    $$10 = $$19;
                    $$14 = $$19 + 1.0f;
                    break;
                }
                case 1: {
                    $$13 = $$19;
                    $$14 = $$19 + 1.0f;
                    $$7 = $$11 = $$17;
                    $$9 = $$12 = $$18 + 1.0f;
                    $$8 = $$19 + 1.0f;
                    $$10 = $$19 + 1.0f;
                    break;
                }
                case 2: {
                    $$7 = $$11 = $$19;
                    $$9 = $$19;
                    $$12 = $$19 + 1.0f;
                    $$8 = $$14 = $$17;
                    $$10 = $$13 = $$18 + 1.0f;
                    break;
                }
                case 3: {
                    $$11 = $$19;
                    $$12 = $$19 + 1.0f;
                    $$7 = $$19 + 1.0f;
                    $$9 = $$19 + 1.0f;
                    $$8 = $$14 = $$17;
                    $$10 = $$13 = $$18 + 1.0f;
                }
            }
            $$7 *= $$15;
            $$9 *= $$15;
            $$8 *= $$16;
            $$10 *= $$16;
            $$8 = 16.0f - $$8;
            $$10 = 16.0f - $$10;
            Map<Direction, BlockElementFace> $$21 = Map.of($$20.getDirection(), new BlockElementFace(null, p_111664_, p_111663_, new BlockElementFace.UVs($$11 *= $$15, $$13 *= $$16, $$12 *= $$15, $$14 *= $$16), Quadrant.R0));
            switch ($$20.ordinal()) {
                case 0: {
                    $$5.add(new BlockElement((Vector3fc)new Vector3f($$7, $$8, 7.5f), (Vector3fc)new Vector3f($$9, $$8, 8.5f), $$21));
                    break;
                }
                case 1: {
                    $$5.add(new BlockElement((Vector3fc)new Vector3f($$7, $$10, 7.5f), (Vector3fc)new Vector3f($$9, $$10, 8.5f), $$21));
                    break;
                }
                case 2: {
                    $$5.add(new BlockElement((Vector3fc)new Vector3f($$7, $$8, 7.5f), (Vector3fc)new Vector3f($$7, $$10, 8.5f), $$21));
                    break;
                }
                case 3: {
                    $$5.add(new BlockElement((Vector3fc)new Vector3f($$9, $$8, 7.5f), (Vector3fc)new Vector3f($$9, $$10, 8.5f), $$21));
                }
            }
        }
        return $$5;
    }

    private static List<Span> getSpans(SpriteContents p_250338_) {
        int $$1 = p_250338_.width();
        int $$2 = p_250338_.height();
        ArrayList<Span> $$3 = new ArrayList<Span>();
        p_250338_.getUniqueFrames().forEach(p_404071_ -> {
            for (int $$5 = 0; $$5 < $$2; ++$$5) {
                for (int $$6 = 0; $$6 < $$1; ++$$6) {
                    boolean $$7 = !ItemModelGenerator.isTransparent(p_250338_, p_404071_, $$6, $$5, $$1, $$2);
                    ItemModelGenerator.checkTransition(SpanFacing.UP, $$3, p_250338_, p_404071_, $$6, $$5, $$1, $$2, $$7);
                    ItemModelGenerator.checkTransition(SpanFacing.DOWN, $$3, p_250338_, p_404071_, $$6, $$5, $$1, $$2, $$7);
                    ItemModelGenerator.checkTransition(SpanFacing.LEFT, $$3, p_250338_, p_404071_, $$6, $$5, $$1, $$2, $$7);
                    ItemModelGenerator.checkTransition(SpanFacing.RIGHT, $$3, p_250338_, p_404071_, $$6, $$5, $$1, $$2, $$7);
                }
            }
        });
        return $$3;
    }

    private static void checkTransition(SpanFacing p_251572_, List<Span> p_248882_, SpriteContents p_249847_, int p_250616_, int p_251416_, int p_249664_, int p_250174_, int p_250897_, boolean p_248773_) {
        boolean $$9;
        boolean bl = $$9 = ItemModelGenerator.isTransparent(p_249847_, p_250616_, p_251416_ + p_251572_.getXOffset(), p_249664_ + p_251572_.getYOffset(), p_250174_, p_250897_) && p_248773_;
        if ($$9) {
            ItemModelGenerator.createOrExpandSpan(p_248882_, p_251572_, p_251416_, p_249664_);
        }
    }

    private static void createOrExpandSpan(List<Span> p_111666_, SpanFacing p_111667_, int p_111668_, int p_111669_) {
        int $$8;
        Span $$4 = null;
        for (Span $$5 : p_111666_) {
            int $$6;
            if ($$5.getFacing() != p_111667_) continue;
            int n = $$6 = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
            if ($$5.getAnchor() != $$6) continue;
            $$4 = $$5;
            break;
        }
        int $$7 = p_111667_.isHorizontal() ? p_111669_ : p_111668_;
        int n = $$8 = p_111667_.isHorizontal() ? p_111668_ : p_111669_;
        if ($$4 == null) {
            p_111666_.add(new Span(p_111667_, $$8, $$7));
        } else {
            $$4.expand($$8);
        }
    }

    private static boolean isTransparent(SpriteContents p_249650_, int p_250692_, int p_251914_, int p_252343_, int p_250258_, int p_248997_) {
        if (p_251914_ < 0 || p_252343_ < 0 || p_251914_ >= p_250258_ || p_252343_ >= p_248997_) {
            return true;
        }
        return p_249650_.isTransparent(p_250692_, p_251914_, p_252343_);
    }

    static class Span {
        private final SpanFacing facing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing p_111680_, int p_111681_, int p_111682_) {
            this.facing = p_111680_;
            this.min = p_111681_;
            this.max = p_111681_;
            this.anchor = p_111682_;
        }

        public void expand(int p_111685_) {
            if (p_111685_ < this.min) {
                this.min = p_111685_;
            } else if (p_111685_ > this.max) {
                this.max = p_111685_;
            }
        }

        public SpanFacing getFacing() {
            return this.facing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction direction;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(Direction p_111701_, int p_111702_, int p_111703_) {
            this.direction = p_111701_;
            this.xOffset = p_111702_;
            this.yOffset = p_111703_;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

