/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.VariantSelector;
import net.minecraft.client.renderer.block.model.multipart.MultiPartModel;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.slf4j.Logger;

public record BlockModelDefinition(Optional<SimpleModelSelectors> simpleModels, Optional<MultiPartDefinition> multiPart) {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BlockModelDefinition> CODEC = RecordCodecBuilder.create(p_409074_ -> p_409074_.group((App)SimpleModelSelectors.CODEC.optionalFieldOf("variants").forGetter(BlockModelDefinition::simpleModels), (App)MultiPartDefinition.CODEC.optionalFieldOf("multipart").forGetter(BlockModelDefinition::multiPart)).apply((Applicative)p_409074_, BlockModelDefinition::new)).validate(p_409078_ -> {
        if (p_409078_.simpleModels().isEmpty() && p_409078_.multiPart().isEmpty()) {
            return DataResult.error(() -> "Neither 'variants' nor 'multipart' found");
        }
        return DataResult.success((Object)p_409078_);
    });

    public Map<BlockState, BlockStateModel.UnbakedRoot> instantiate(StateDefinition<Block, BlockState> p_360641_, Supplier<String> p_405739_) {
        IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot> $$2 = new IdentityHashMap<BlockState, BlockStateModel.UnbakedRoot>();
        this.simpleModels.ifPresent(p_409073_ -> p_409073_.instantiate(p_360641_, p_405739_, (p_409076_, p_409077_) -> {
            BlockStateModel.UnbakedRoot $$3 = $$2.put((BlockState)p_409076_, (BlockStateModel.UnbakedRoot)p_409077_);
            if ($$3 != null) {
                throw new IllegalArgumentException("Overlapping definition on state: " + String.valueOf(p_409076_));
            }
        }));
        this.multiPart.ifPresent(p_409069_ -> {
            ImmutableList $$3 = p_360641_.getPossibleStates();
            MultiPartModel.Unbaked $$4 = p_409069_.instantiate(p_360641_);
            for (BlockState $$5 : $$3) {
                $$2.putIfAbsent($$5, $$4);
            }
        });
        return $$2;
    }

    public record MultiPartDefinition(List<Selector> selectors) {
        public static final Codec<MultiPartDefinition> CODEC = ExtraCodecs.nonEmptyList(Selector.CODEC.listOf()).xmap(MultiPartDefinition::new, MultiPartDefinition::selectors);

        public MultiPartModel.Unbaked instantiate(StateDefinition<Block, BlockState> p_409848_) {
            ImmutableList.Builder $$1 = ImmutableList.builderWithExpectedSize((int)this.selectors.size());
            for (Selector $$2 : this.selectors) {
                $$1.add(new MultiPartModel.Selector<BlockStateModel.Unbaked>($$2.instantiate(p_409848_), $$2.variant()));
            }
            return new MultiPartModel.Unbaked((List<MultiPartModel.Selector<BlockStateModel.Unbaked>>)$$1.build());
        }
    }

    public record SimpleModelSelectors(Map<String, BlockStateModel.Unbaked> models) {
        public static final Codec<SimpleModelSelectors> CODEC = ExtraCodecs.nonEmptyMap(Codec.unboundedMap((Codec)Codec.STRING, BlockStateModel.Unbaked.CODEC)).xmap(SimpleModelSelectors::new, SimpleModelSelectors::models);

        public void instantiate(StateDefinition<Block, BlockState> p_410043_, Supplier<String> p_410061_, BiConsumer<BlockState, BlockStateModel.UnbakedRoot> p_410161_) {
            this.models.forEach((p_410328_, p_410410_) -> {
                try {
                    Predicate $$5 = VariantSelector.predicate(p_410043_, p_410328_);
                    BlockStateModel.UnbakedRoot $$6 = p_410410_.asRoot();
                    for (BlockState $$7 : p_410043_.getPossibleStates()) {
                        if (!$$5.test($$7)) continue;
                        p_410161_.accept($$7, $$6);
                    }
                }
                catch (Exception $$8) {
                    LOGGER.warn("Exception loading blockstate definition: '{}' for variant: '{}': {}", new Object[]{p_410061_.get(), p_410328_, $$8.getMessage()});
                }
            });
        }
    }
}

