/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public record BlockModel(@Nullable UnbakedGeometry geometry, @Nullable UnbakedModel.GuiLight guiLight, @Nullable Boolean ambientOcclusion, @Nullable ItemTransforms transforms, TextureSlots.Data textureSlots, @Nullable ResourceLocation parent) implements UnbakedModel
{
    @VisibleForTesting
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).create();

    public static BlockModel fromStream(Reader p_111462_) {
        return GsonHelper.fromJson(GSON, p_111462_, BlockModel.class);
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        public BlockModel deserialize(JsonElement p_111498_, Type p_111499_, JsonDeserializationContext p_111500_) throws JsonParseException {
            JsonObject $$3 = p_111498_.getAsJsonObject();
            UnbakedGeometry $$4 = this.getElements(p_111500_, $$3);
            String $$5 = this.getParentName($$3);
            TextureSlots.Data $$6 = this.getTextureMap($$3);
            Boolean $$7 = this.getAmbientOcclusion($$3);
            ItemTransforms $$8 = null;
            if ($$3.has("display")) {
                JsonObject $$9 = GsonHelper.getAsJsonObject($$3, "display");
                $$8 = (ItemTransforms)p_111500_.deserialize((JsonElement)$$9, ItemTransforms.class);
            }
            UnbakedModel.GuiLight $$10 = null;
            if ($$3.has("gui_light")) {
                $$10 = UnbakedModel.GuiLight.getByName(GsonHelper.getAsString($$3, "gui_light"));
            }
            ResourceLocation $$11 = $$5.isEmpty() ? null : ResourceLocation.parse($$5);
            return new BlockModel($$4, $$10, $$7, $$8, $$6, $$11);
        }

        private TextureSlots.Data getTextureMap(JsonObject p_111510_) {
            if (p_111510_.has("textures")) {
                JsonObject $$1 = GsonHelper.getAsJsonObject(p_111510_, "textures");
                return TextureSlots.parseTextureMap($$1, TextureAtlas.LOCATION_BLOCKS);
            }
            return TextureSlots.Data.EMPTY;
        }

        private String getParentName(JsonObject p_111512_) {
            return GsonHelper.getAsString(p_111512_, "parent", "");
        }

        @Nullable
        protected Boolean getAmbientOcclusion(JsonObject p_273052_) {
            if (p_273052_.has("ambientocclusion")) {
                return GsonHelper.getAsBoolean(p_273052_, "ambientocclusion");
            }
            return null;
        }

        @Nullable
        protected UnbakedGeometry getElements(JsonDeserializationContext p_111507_, JsonObject p_111508_) {
            if (p_111508_.has("elements")) {
                ArrayList<BlockElement> $$2 = new ArrayList<BlockElement>();
                for (JsonElement $$3 : GsonHelper.getAsJsonArray(p_111508_, "elements")) {
                    $$2.add((BlockElement)p_111507_.deserialize($$3, BlockElement.class));
                }
                return new SimpleUnbakedGeometry($$2);
            }
            return null;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

