/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Quadrant;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;

public record BlockElementFace(@Nullable Direction cullForDirection, int tintIndex, String texture, @Nullable UVs uvs, Quadrant rotation) {
    public static final int NO_TINT = -1;

    public static float getU(UVs p_405199_, Quadrant p_404689_, int p_404785_) {
        return p_405199_.getVertexU(p_404689_.rotateVertexIndex(p_404785_)) / 16.0f;
    }

    public static float getV(UVs p_405500_, Quadrant p_404709_, int p_405113_) {
        return p_405500_.getVertexV(p_404709_.rotateVertexIndex(p_405113_)) / 16.0f;
    }

    public record UVs(float minU, float minV, float maxU, float maxV) {
        public float getVertexU(int p_405872_) {
            return p_405872_ == 0 || p_405872_ == 1 ? this.minU : this.maxU;
        }

        public float getVertexV(int p_405480_) {
            return p_405480_ == 0 || p_405480_ == 3 ? this.minV : this.maxV;
        }
    }

    protected static class Deserializer
    implements JsonDeserializer<BlockElementFace> {
        private static final int DEFAULT_TINT_INDEX = -1;
        private static final int DEFAULT_ROTATION = 0;

        protected Deserializer() {
        }

        public BlockElementFace deserialize(JsonElement p_111365_, Type p_111366_, JsonDeserializationContext p_111367_) throws JsonParseException {
            JsonObject $$3 = p_111365_.getAsJsonObject();
            Direction $$4 = Deserializer.getCullFacing($$3);
            int $$5 = Deserializer.getTintIndex($$3);
            String $$6 = Deserializer.getTexture($$3);
            UVs $$7 = Deserializer.getUVs($$3);
            Quadrant $$8 = Deserializer.getRotation($$3);
            return new BlockElementFace($$4, $$5, $$6, $$7, $$8);
        }

        private static int getTintIndex(JsonObject p_111369_) {
            return GsonHelper.getAsInt(p_111369_, "tintindex", -1);
        }

        private static String getTexture(JsonObject p_111371_) {
            return GsonHelper.getAsString(p_111371_, "texture");
        }

        @Nullable
        private static Direction getCullFacing(JsonObject p_111373_) {
            String $$1 = GsonHelper.getAsString(p_111373_, "cullface", "");
            return Direction.byName($$1);
        }

        private static Quadrant getRotation(JsonObject p_404961_) {
            int $$1 = GsonHelper.getAsInt(p_404961_, "rotation", 0);
            return Quadrant.parseJson($$1);
        }

        @Nullable
        private static UVs getUVs(JsonObject p_405376_) {
            if (!p_405376_.has("uv")) {
                return null;
            }
            JsonArray $$1 = GsonHelper.getAsJsonArray(p_405376_, "uv");
            if ($$1.size() != 4) {
                throw new JsonParseException("Expected 4 uv values, found: " + $$1.size());
            }
            float $$2 = GsonHelper.convertToFloat($$1.get(0), "minU");
            float $$3 = GsonHelper.convertToFloat($$1.get(1), "minV");
            float $$4 = GsonHelper.convertToFloat($$1.get(2), "maxU");
            float $$5 = GsonHelper.convertToFloat($$1.get(3), "maxV");
            return new UVs($$2, $$3, $$4, $$5);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

