/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ModelBlockRenderer {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final BlockColors blockColors;
    private static final int CACHE_SIZE = 100;
    static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(Cache::new);

    public ModelBlockRenderer(BlockColors p_110999_) {
        this.blockColors = p_110999_;
    }

    public void tesselateBlock(BlockAndTintGetter p_234380_, List<BlockModelPart> p_410025_, BlockState p_234382_, BlockPos p_234383_, PoseStack p_234384_, VertexConsumer p_234385_, boolean p_234386_, int p_234389_) {
        if (p_410025_.isEmpty()) {
            return;
        }
        boolean $$8 = Minecraft.useAmbientOcclusion() && p_234382_.getLightEmission() == 0 && p_410025_.getFirst().useAmbientOcclusion();
        p_234384_.translate(p_234382_.getOffset(p_234383_));
        try {
            if ($$8) {
                this.tesselateWithAO(p_234380_, p_410025_, p_234382_, p_234383_, p_234384_, p_234385_, p_234386_, p_234389_);
            } else {
                this.tesselateWithoutAO(p_234380_, p_410025_, p_234382_, p_234383_, p_234384_, p_234385_, p_234386_, p_234389_);
            }
        }
        catch (Throwable $$9) {
            CrashReport $$10 = CrashReport.forThrowable($$9, "Tesselating block model");
            CrashReportCategory $$11 = $$10.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails($$11, p_234380_, p_234383_, p_234382_);
            $$11.setDetail("Using AO", $$8);
            throw new ReportedException($$10);
        }
    }

    private static boolean shouldRenderFace(BlockAndTintGetter p_412640_, BlockState p_412168_, boolean p_412054_, Direction p_412130_, BlockPos p_412608_) {
        if (!p_412054_) {
            return true;
        }
        BlockState $$5 = p_412640_.getBlockState(p_412608_);
        return Block.shouldRenderFace(p_412168_, $$5, p_412130_);
    }

    public void tesselateWithAO(BlockAndTintGetter p_234391_, List<BlockModelPart> p_410478_, BlockState p_234393_, BlockPos p_234394_, PoseStack p_234395_, VertexConsumer p_234396_, boolean p_234397_, int p_234400_) {
        AmbientOcclusionRenderStorage $$8 = new AmbientOcclusionRenderStorage();
        int $$9 = 0;
        int $$10 = 0;
        for (BlockModelPart $$11 : p_410478_) {
            for (Direction $$12 : DIRECTIONS) {
                List<BakedQuad> $$16;
                boolean $$15;
                int $$13 = 1 << $$12.ordinal();
                boolean $$14 = ($$9 & $$13) == 1;
                boolean bl = $$15 = ($$10 & $$13) == 1;
                if ($$14 && !$$15 || ($$16 = $$11.getQuads($$12)).isEmpty()) continue;
                if (!$$14) {
                    $$15 = ModelBlockRenderer.shouldRenderFace(p_234391_, p_234393_, p_234397_, $$12, $$8.scratchPos.setWithOffset((Vec3i)p_234394_, $$12));
                    $$9 |= $$13;
                    if ($$15) {
                        $$10 |= $$13;
                    }
                }
                if (!$$15) continue;
                this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, $$16, $$8, p_234400_);
            }
            List<BakedQuad> $$17 = $$11.getQuads(null);
            if ($$17.isEmpty()) continue;
            this.renderModelFaceAO(p_234391_, p_234393_, p_234394_, p_234395_, p_234396_, $$17, $$8, p_234400_);
        }
    }

    public void tesselateWithoutAO(BlockAndTintGetter p_234402_, List<BlockModelPart> p_410604_, BlockState p_234404_, BlockPos p_234405_, PoseStack p_234406_, VertexConsumer p_234407_, boolean p_234408_, int p_234411_) {
        CommonRenderStorage $$8 = new CommonRenderStorage();
        int $$9 = 0;
        int $$10 = 0;
        for (BlockModelPart $$11 : p_410604_) {
            for (Direction $$12 : DIRECTIONS) {
                List<BakedQuad> $$16;
                boolean $$15;
                int $$13 = 1 << $$12.ordinal();
                boolean $$14 = ($$9 & $$13) == 1;
                boolean bl = $$15 = ($$10 & $$13) == 1;
                if ($$14 && !$$15 || ($$16 = $$11.getQuads($$12)).isEmpty()) continue;
                BlockPos.MutableBlockPos $$17 = $$8.scratchPos.setWithOffset((Vec3i)p_234405_, $$12);
                if (!$$14) {
                    $$15 = ModelBlockRenderer.shouldRenderFace(p_234402_, p_234404_, p_234408_, $$12, $$17);
                    $$9 |= $$13;
                    if ($$15) {
                        $$10 |= $$13;
                    }
                }
                if (!$$15) continue;
                int $$18 = $$8.cache.getLightColor(p_234404_, p_234402_, $$17);
                this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, $$18, p_234411_, false, p_234406_, p_234407_, $$16, $$8);
            }
            List<BakedQuad> $$19 = $$11.getQuads(null);
            if ($$19.isEmpty()) continue;
            this.renderModelFaceFlat(p_234402_, p_234404_, p_234405_, -1, p_234411_, true, p_234406_, p_234407_, $$19, $$8);
        }
    }

    private void renderModelFaceAO(BlockAndTintGetter p_111013_, BlockState p_111014_, BlockPos p_111015_, PoseStack p_111016_, VertexConsumer p_111017_, List<BakedQuad> p_111018_, AmbientOcclusionRenderStorage p_412172_, int p_111022_) {
        for (BakedQuad $$8 : p_111018_) {
            ModelBlockRenderer.calculateShape(p_111013_, p_111014_, p_111015_, $$8.vertices(), $$8.direction(), p_412172_);
            p_412172_.calculate(p_111013_, p_111014_, p_111015_, $$8.direction(), $$8.shade());
            this.putQuadData(p_111013_, p_111014_, p_111015_, p_111017_, p_111016_.last(), $$8, p_412172_, p_111022_);
        }
    }

    private void putQuadData(BlockAndTintGetter p_111024_, BlockState p_111025_, BlockPos p_111026_, VertexConsumer p_111027_, PoseStack.Pose p_111028_, BakedQuad p_111029_, CommonRenderStorage p_412412_, int p_111034_) {
        float $$16;
        float $$15;
        float $$14;
        int $$8 = p_111029_.tintIndex();
        if ($$8 != -1) {
            int $$10;
            if (p_412412_.tintCacheIndex == $$8) {
                int $$9 = p_412412_.tintCacheValue;
            } else {
                $$10 = this.blockColors.getColor(p_111025_, p_111024_, p_111026_, $$8);
                p_412412_.tintCacheIndex = $$8;
                p_412412_.tintCacheValue = $$10;
            }
            float $$11 = ARGB.redFloat($$10);
            float $$12 = ARGB.greenFloat($$10);
            float $$13 = ARGB.blueFloat($$10);
        } else {
            $$14 = 1.0f;
            $$15 = 1.0f;
            $$16 = 1.0f;
        }
        p_111027_.putBulkData(p_111028_, p_111029_, p_412412_.brightness, $$14, $$15, $$16, 1.0f, p_412412_.lightmap, p_111034_, true);
    }

    private static void calculateShape(BlockAndTintGetter p_111040_, BlockState p_111041_, BlockPos p_111042_, int[] p_111043_, Direction p_111044_, CommonRenderStorage p_412438_) {
        float $$6 = 32.0f;
        float $$7 = 32.0f;
        float $$8 = 32.0f;
        float $$9 = -32.0f;
        float $$10 = -32.0f;
        float $$11 = -32.0f;
        for (int $$12 = 0; $$12 < 4; ++$$12) {
            float $$13 = Float.intBitsToFloat(p_111043_[$$12 * 8]);
            float $$14 = Float.intBitsToFloat(p_111043_[$$12 * 8 + 1]);
            float $$15 = Float.intBitsToFloat(p_111043_[$$12 * 8 + 2]);
            $$6 = Math.min($$6, $$13);
            $$7 = Math.min($$7, $$14);
            $$8 = Math.min($$8, $$15);
            $$9 = Math.max($$9, $$13);
            $$10 = Math.max($$10, $$14);
            $$11 = Math.max($$11, $$15);
        }
        if (p_412438_ instanceof AmbientOcclusionRenderStorage) {
            AmbientOcclusionRenderStorage $$16 = (AmbientOcclusionRenderStorage)p_412438_;
            $$16.faceShape[SizeInfo.WEST.index] = $$6;
            $$16.faceShape[SizeInfo.EAST.index] = $$9;
            $$16.faceShape[SizeInfo.DOWN.index] = $$7;
            $$16.faceShape[SizeInfo.UP.index] = $$10;
            $$16.faceShape[SizeInfo.NORTH.index] = $$8;
            $$16.faceShape[SizeInfo.SOUTH.index] = $$11;
            $$16.faceShape[SizeInfo.FLIP_WEST.index] = 1.0f - $$6;
            $$16.faceShape[SizeInfo.FLIP_EAST.index] = 1.0f - $$9;
            $$16.faceShape[SizeInfo.FLIP_DOWN.index] = 1.0f - $$7;
            $$16.faceShape[SizeInfo.FLIP_UP.index] = 1.0f - $$10;
            $$16.faceShape[SizeInfo.FLIP_NORTH.index] = 1.0f - $$8;
            $$16.faceShape[SizeInfo.FLIP_SOUTH.index] = 1.0f - $$11;
        }
        float $$17 = 1.0E-4f;
        float $$18 = 0.9999f;
        p_412438_.facePartial = switch (p_111044_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> {
                if ($$6 >= 1.0E-4f || $$8 >= 1.0E-4f || $$9 <= 0.9999f || $$11 <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH, Direction.SOUTH -> {
                if ($$6 >= 1.0E-4f || $$7 >= 1.0E-4f || $$9 <= 0.9999f || $$10 <= 0.9999f) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST, Direction.EAST -> $$7 >= 1.0E-4f || $$8 >= 1.0E-4f || $$10 <= 0.9999f || $$11 <= 0.9999f;
        };
        p_412438_.faceCubic = switch (p_111044_) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                if ($$7 == $$10 && ($$7 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.UP -> {
                if ($$7 == $$10 && ($$10 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.NORTH -> {
                if ($$8 == $$11 && ($$8 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if ($$8 == $$11 && ($$11 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if ($$6 == $$9 && ($$6 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_))) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> $$6 == $$9 && ($$9 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_));
        };
    }

    private void renderModelFaceFlat(BlockAndTintGetter p_111002_, BlockState p_111003_, BlockPos p_111004_, int p_111005_, int p_111006_, boolean p_111007_, PoseStack p_111008_, VertexConsumer p_111009_, List<BakedQuad> p_111010_, CommonRenderStorage p_412163_) {
        for (BakedQuad $$10 : p_111010_) {
            float $$12;
            if (p_111007_) {
                ModelBlockRenderer.calculateShape(p_111002_, p_111003_, p_111004_, $$10.vertices(), $$10.direction(), p_412163_);
                BlockPos $$11 = p_412163_.faceCubic ? p_412163_.scratchPos.setWithOffset((Vec3i)p_111004_, $$10.direction()) : p_111004_;
                p_111005_ = p_412163_.cache.getLightColor(p_111003_, p_111002_, $$11);
            }
            p_412163_.brightness[0] = $$12 = p_111002_.getShade($$10.direction(), $$10.shade());
            p_412163_.brightness[1] = $$12;
            p_412163_.brightness[2] = $$12;
            p_412163_.brightness[3] = $$12;
            p_412163_.lightmap[0] = p_111005_;
            p_412163_.lightmap[1] = p_111005_;
            p_412163_.lightmap[2] = p_111005_;
            p_412163_.lightmap[3] = p_111005_;
            this.putQuadData(p_111002_, p_111003_, p_111004_, p_111009_, p_111008_.last(), $$10, p_412163_, p_111006_);
        }
    }

    public static void renderModel(PoseStack.Pose p_111068_, VertexConsumer p_111069_, BlockStateModel p_405848_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_) {
        for (BlockModelPart $$8 : p_405848_.collectParts(RandomSource.create(42L))) {
            for (Direction $$9 : DIRECTIONS) {
                ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, $$8.getQuads($$9), p_111075_, p_111076_);
            }
            ModelBlockRenderer.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, $$8.getQuads(null), p_111075_, p_111076_);
        }
    }

    private static void renderQuadList(PoseStack.Pose p_111059_, VertexConsumer p_111060_, float p_111061_, float p_111062_, float p_111063_, List<BakedQuad> p_111064_, int p_111065_, int p_111066_) {
        for (BakedQuad $$8 : p_111064_) {
            float $$14;
            float $$13;
            float $$12;
            if ($$8.isTinted()) {
                float $$9 = Mth.clamp(p_111061_, 0.0f, 1.0f);
                float $$10 = Mth.clamp(p_111062_, 0.0f, 1.0f);
                float $$11 = Mth.clamp(p_111063_, 0.0f, 1.0f);
            } else {
                $$12 = 1.0f;
                $$13 = 1.0f;
                $$14 = 1.0f;
            }
            p_111060_.putBulkData(p_111059_, $$8, $$12, $$13, $$14, 1.0f, p_111065_, p_111066_);
        }
    }

    public static void enableCaching() {
        CACHE.get().enable();
    }

    public static void clearCache() {
        CACHE.get().disable();
    }

    static class AmbientOcclusionRenderStorage
    extends CommonRenderStorage {
        final float[] faceShape = new float[SizeInfo.COUNT];

        public void calculate(BlockAndTintGetter p_412286_, BlockState p_412102_, BlockPos p_412730_, Direction p_412336_, boolean p_412430_) {
            int $$47;
            float $$46;
            int $$42;
            float $$41;
            int $$37;
            float $$36;
            int $$32;
            float $$31;
            boolean $$27;
            BlockPos $$5 = this.faceCubic ? p_412730_.relative(p_412336_) : p_412730_;
            AdjacencyInfo $$6 = AdjacencyInfo.fromFacing(p_412336_);
            BlockPos.MutableBlockPos $$7 = this.scratchPos;
            $$7.setWithOffset((Vec3i)$$5, $$6.corners[0]);
            BlockState $$8 = p_412286_.getBlockState($$7);
            int $$9 = this.cache.getLightColor($$8, p_412286_, $$7);
            float $$10 = this.cache.getShadeBrightness($$8, p_412286_, $$7);
            $$7.setWithOffset((Vec3i)$$5, $$6.corners[1]);
            BlockState $$11 = p_412286_.getBlockState($$7);
            int $$12 = this.cache.getLightColor($$11, p_412286_, $$7);
            float $$13 = this.cache.getShadeBrightness($$11, p_412286_, $$7);
            $$7.setWithOffset((Vec3i)$$5, $$6.corners[2]);
            BlockState $$14 = p_412286_.getBlockState($$7);
            int $$15 = this.cache.getLightColor($$14, p_412286_, $$7);
            float $$16 = this.cache.getShadeBrightness($$14, p_412286_, $$7);
            $$7.setWithOffset((Vec3i)$$5, $$6.corners[3]);
            BlockState $$17 = p_412286_.getBlockState($$7);
            int $$18 = this.cache.getLightColor($$17, p_412286_, $$7);
            float $$19 = this.cache.getShadeBrightness($$17, p_412286_, $$7);
            BlockState $$20 = p_412286_.getBlockState($$7.setWithOffset((Vec3i)$$5, $$6.corners[0]).move(p_412336_));
            boolean $$21 = !$$20.isViewBlocking(p_412286_, $$7) || $$20.getLightBlock() == 0;
            BlockState $$22 = p_412286_.getBlockState($$7.setWithOffset((Vec3i)$$5, $$6.corners[1]).move(p_412336_));
            boolean $$23 = !$$22.isViewBlocking(p_412286_, $$7) || $$22.getLightBlock() == 0;
            BlockState $$24 = p_412286_.getBlockState($$7.setWithOffset((Vec3i)$$5, $$6.corners[2]).move(p_412336_));
            boolean $$25 = !$$24.isViewBlocking(p_412286_, $$7) || $$24.getLightBlock() == 0;
            BlockState $$26 = p_412286_.getBlockState($$7.setWithOffset((Vec3i)$$5, $$6.corners[3]).move(p_412336_));
            boolean bl = $$27 = !$$26.isViewBlocking(p_412286_, $$7) || $$26.getLightBlock() == 0;
            if ($$25 || $$21) {
                $$7.setWithOffset((Vec3i)$$5, $$6.corners[0]).move($$6.corners[2]);
                BlockState $$28 = p_412286_.getBlockState($$7);
                float $$29 = this.cache.getShadeBrightness($$28, p_412286_, $$7);
                int $$30 = this.cache.getLightColor($$28, p_412286_, $$7);
            } else {
                $$31 = $$10;
                $$32 = $$9;
            }
            if ($$27 || $$21) {
                $$7.setWithOffset((Vec3i)$$5, $$6.corners[0]).move($$6.corners[3]);
                BlockState $$33 = p_412286_.getBlockState($$7);
                float $$34 = this.cache.getShadeBrightness($$33, p_412286_, $$7);
                int $$35 = this.cache.getLightColor($$33, p_412286_, $$7);
            } else {
                $$36 = $$10;
                $$37 = $$9;
            }
            if ($$25 || $$23) {
                $$7.setWithOffset((Vec3i)$$5, $$6.corners[1]).move($$6.corners[2]);
                BlockState $$38 = p_412286_.getBlockState($$7);
                float $$39 = this.cache.getShadeBrightness($$38, p_412286_, $$7);
                int $$40 = this.cache.getLightColor($$38, p_412286_, $$7);
            } else {
                $$41 = $$10;
                $$42 = $$9;
            }
            if ($$27 || $$23) {
                $$7.setWithOffset((Vec3i)$$5, $$6.corners[1]).move($$6.corners[3]);
                BlockState $$43 = p_412286_.getBlockState($$7);
                float $$44 = this.cache.getShadeBrightness($$43, p_412286_, $$7);
                int $$45 = this.cache.getLightColor($$43, p_412286_, $$7);
            } else {
                $$46 = $$10;
                $$47 = $$9;
            }
            int $$48 = this.cache.getLightColor(p_412102_, p_412286_, p_412730_);
            $$7.setWithOffset((Vec3i)p_412730_, p_412336_);
            BlockState $$49 = p_412286_.getBlockState($$7);
            if (this.faceCubic || !$$49.isSolidRender()) {
                $$48 = this.cache.getLightColor($$49, p_412286_, $$7);
            }
            float $$50 = this.faceCubic ? this.cache.getShadeBrightness(p_412286_.getBlockState($$5), p_412286_, $$5) : this.cache.getShadeBrightness(p_412286_.getBlockState(p_412730_), p_412286_, p_412730_);
            AmbientVertexRemap $$51 = AmbientVertexRemap.fromFacing(p_412336_);
            if (!this.facePartial || !$$6.doNonCubicWeight) {
                float $$52 = ($$19 + $$10 + $$36 + $$50) * 0.25f;
                float $$53 = ($$16 + $$10 + $$31 + $$50) * 0.25f;
                float $$54 = ($$16 + $$13 + $$41 + $$50) * 0.25f;
                float $$55 = ($$19 + $$13 + $$46 + $$50) * 0.25f;
                this.lightmap[$$51.vert0] = AmbientOcclusionRenderStorage.blend($$18, $$9, $$37, $$48);
                this.lightmap[$$51.vert1] = AmbientOcclusionRenderStorage.blend($$15, $$9, $$32, $$48);
                this.lightmap[$$51.vert2] = AmbientOcclusionRenderStorage.blend($$15, $$12, $$42, $$48);
                this.lightmap[$$51.vert3] = AmbientOcclusionRenderStorage.blend($$18, $$12, $$47, $$48);
                this.brightness[$$51.vert0] = $$52;
                this.brightness[$$51.vert1] = $$53;
                this.brightness[$$51.vert2] = $$54;
                this.brightness[$$51.vert3] = $$55;
            } else {
                float $$56 = ($$19 + $$10 + $$36 + $$50) * 0.25f;
                float $$57 = ($$16 + $$10 + $$31 + $$50) * 0.25f;
                float $$58 = ($$16 + $$13 + $$41 + $$50) * 0.25f;
                float $$59 = ($$19 + $$13 + $$46 + $$50) * 0.25f;
                float $$60 = this.faceShape[$$6.vert0Weights[0].index] * this.faceShape[$$6.vert0Weights[1].index];
                float $$61 = this.faceShape[$$6.vert0Weights[2].index] * this.faceShape[$$6.vert0Weights[3].index];
                float $$62 = this.faceShape[$$6.vert0Weights[4].index] * this.faceShape[$$6.vert0Weights[5].index];
                float $$63 = this.faceShape[$$6.vert0Weights[6].index] * this.faceShape[$$6.vert0Weights[7].index];
                float $$64 = this.faceShape[$$6.vert1Weights[0].index] * this.faceShape[$$6.vert1Weights[1].index];
                float $$65 = this.faceShape[$$6.vert1Weights[2].index] * this.faceShape[$$6.vert1Weights[3].index];
                float $$66 = this.faceShape[$$6.vert1Weights[4].index] * this.faceShape[$$6.vert1Weights[5].index];
                float $$67 = this.faceShape[$$6.vert1Weights[6].index] * this.faceShape[$$6.vert1Weights[7].index];
                float $$68 = this.faceShape[$$6.vert2Weights[0].index] * this.faceShape[$$6.vert2Weights[1].index];
                float $$69 = this.faceShape[$$6.vert2Weights[2].index] * this.faceShape[$$6.vert2Weights[3].index];
                float $$70 = this.faceShape[$$6.vert2Weights[4].index] * this.faceShape[$$6.vert2Weights[5].index];
                float $$71 = this.faceShape[$$6.vert2Weights[6].index] * this.faceShape[$$6.vert2Weights[7].index];
                float $$72 = this.faceShape[$$6.vert3Weights[0].index] * this.faceShape[$$6.vert3Weights[1].index];
                float $$73 = this.faceShape[$$6.vert3Weights[2].index] * this.faceShape[$$6.vert3Weights[3].index];
                float $$74 = this.faceShape[$$6.vert3Weights[4].index] * this.faceShape[$$6.vert3Weights[5].index];
                float $$75 = this.faceShape[$$6.vert3Weights[6].index] * this.faceShape[$$6.vert3Weights[7].index];
                this.brightness[$$51.vert0] = Math.clamp($$56 * $$60 + $$57 * $$61 + $$58 * $$62 + $$59 * $$63, 0.0f, 1.0f);
                this.brightness[$$51.vert1] = Math.clamp($$56 * $$64 + $$57 * $$65 + $$58 * $$66 + $$59 * $$67, 0.0f, 1.0f);
                this.brightness[$$51.vert2] = Math.clamp($$56 * $$68 + $$57 * $$69 + $$58 * $$70 + $$59 * $$71, 0.0f, 1.0f);
                this.brightness[$$51.vert3] = Math.clamp($$56 * $$72 + $$57 * $$73 + $$58 * $$74 + $$59 * $$75, 0.0f, 1.0f);
                int $$76 = AmbientOcclusionRenderStorage.blend($$18, $$9, $$37, $$48);
                int $$77 = AmbientOcclusionRenderStorage.blend($$15, $$9, $$32, $$48);
                int $$78 = AmbientOcclusionRenderStorage.blend($$15, $$12, $$42, $$48);
                int $$79 = AmbientOcclusionRenderStorage.blend($$18, $$12, $$47, $$48);
                this.lightmap[$$51.vert0] = AmbientOcclusionRenderStorage.blend($$76, $$77, $$78, $$79, $$60, $$61, $$62, $$63);
                this.lightmap[$$51.vert1] = AmbientOcclusionRenderStorage.blend($$76, $$77, $$78, $$79, $$64, $$65, $$66, $$67);
                this.lightmap[$$51.vert2] = AmbientOcclusionRenderStorage.blend($$76, $$77, $$78, $$79, $$68, $$69, $$70, $$71);
                this.lightmap[$$51.vert3] = AmbientOcclusionRenderStorage.blend($$76, $$77, $$78, $$79, $$72, $$73, $$74, $$75);
            }
            float $$80 = p_412286_.getShade(p_412336_, p_412430_);
            int $$81 = 0;
            while ($$81 < this.brightness.length) {
                int n = $$81++;
                this.brightness[n] = this.brightness[n] * $$80;
            }
        }

        private static int blend(int p_412676_, int p_412469_, int p_412736_, int p_412253_) {
            if (p_412676_ == 0) {
                p_412676_ = p_412253_;
            }
            if (p_412469_ == 0) {
                p_412469_ = p_412253_;
            }
            if (p_412736_ == 0) {
                p_412736_ = p_412253_;
            }
            return p_412676_ + p_412469_ + p_412736_ + p_412253_ >> 2 & 0xFF00FF;
        }

        private static int blend(int p_412759_, int p_412518_, int p_412118_, int p_412415_, float p_412783_, float p_412051_, float p_412530_, float p_412587_) {
            int $$8 = (int)((float)(p_412759_ >> 16 & 0xFF) * p_412783_ + (float)(p_412518_ >> 16 & 0xFF) * p_412051_ + (float)(p_412118_ >> 16 & 0xFF) * p_412530_ + (float)(p_412415_ >> 16 & 0xFF) * p_412587_) & 0xFF;
            int $$9 = (int)((float)(p_412759_ & 0xFF) * p_412783_ + (float)(p_412518_ & 0xFF) * p_412051_ + (float)(p_412118_ & 0xFF) * p_412530_ + (float)(p_412415_ & 0xFF) * p_412587_) & 0xFF;
            return $$8 << 16 | $$9;
        }
    }

    static class CommonRenderStorage {
        public final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
        public boolean faceCubic;
        public boolean facePartial;
        public final float[] brightness = new float[4];
        public final int[] lightmap = new int[4];
        public int tintCacheIndex = -1;
        public int tintCacheValue;
        public final Cache cache = CACHE.get();

        CommonRenderStorage() {
        }
    }

    static class Cache {
        private boolean enabled;
        private final Long2IntLinkedOpenHashMap colorCache = Util.make(() -> {
            Long2IntLinkedOpenHashMap $$0 = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111238_) {
                }
            };
            $$0.defaultReturnValue(Integer.MAX_VALUE);
            return $$0;
        });
        private final Long2FloatLinkedOpenHashMap brightnessCache = Util.make(() -> {
            Long2FloatLinkedOpenHashMap $$0 = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111245_) {
                }
            };
            $$0.defaultReturnValue(Float.NaN);
            return $$0;
        });
        private final LevelRenderer.BrightnessGetter cachedBrightnessGetter = (p_412965_, p_412966_) -> {
            long $$2 = p_412966_.asLong();
            int $$3 = this.colorCache.get($$2);
            if ($$3 != Integer.MAX_VALUE) {
                return $$3;
            }
            int $$4 = LevelRenderer.BrightnessGetter.DEFAULT.packedBrightness(p_412965_, p_412966_);
            if (this.colorCache.size() == 100) {
                this.colorCache.removeFirstInt();
            }
            this.colorCache.put($$2, $$4);
            return $$4;
        };

        private Cache() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
            this.colorCache.clear();
            this.brightnessCache.clear();
        }

        public int getLightColor(BlockState p_111222_, BlockAndTintGetter p_111223_, BlockPos p_111224_) {
            return LevelRenderer.getLightColor(this.enabled ? this.cachedBrightnessGetter : LevelRenderer.BrightnessGetter.DEFAULT, p_111223_, p_111222_, p_111224_);
        }

        public float getShadeBrightness(BlockState p_111227_, BlockAndTintGetter p_111228_, BlockPos p_111229_) {
            float $$4;
            long $$3 = p_111229_.asLong();
            if (this.enabled && !Float.isNaN($$4 = this.brightnessCache.get($$3))) {
                return $$4;
            }
            float $$5 = p_111227_.getShadeBrightness(p_111228_, p_111229_);
            if (this.enabled) {
                if (this.brightnessCache.size() == 100) {
                    this.brightnessCache.removeFirstFloat();
                }
                this.brightnessCache.put($$3, $$5);
            }
            return $$5;
        }
    }

    protected static enum SizeInfo {
        DOWN(0),
        UP(1),
        NORTH(2),
        SOUTH(3),
        WEST(4),
        EAST(5),
        FLIP_DOWN(6),
        FLIP_UP(7),
        FLIP_NORTH(8),
        FLIP_SOUTH(9),
        FLIP_WEST(10),
        FLIP_EAST(11);

        public static final int COUNT;
        final int index;

        private SizeInfo(int p_412421_) {
            this.index = p_412421_;
        }

        static {
            COUNT = SizeInfo.values().length;
        }
    }

    protected static enum AdjacencyInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new SizeInfo[]{SizeInfo.EAST, SizeInfo.SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.EAST, SizeInfo.NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.UP, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.DOWN, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.DOWN, SizeInfo.EAST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.UP, SizeInfo.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.UP, SizeInfo.NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.SOUTH});

        final Direction[] corners;
        final boolean doNonCubicWeight;
        final SizeInfo[] vert0Weights;
        final SizeInfo[] vert1Weights;
        final SizeInfo[] vert2Weights;
        final SizeInfo[] vert3Weights;
        private static final AdjacencyInfo[] BY_FACING;

        private AdjacencyInfo(Direction[] p_111122_, float p_111123_, boolean p_111124_, SizeInfo[] p_111125_, SizeInfo[] p_111126_, SizeInfo[] p_111127_, SizeInfo[] p_111128_) {
            this.corners = p_111122_;
            this.doNonCubicWeight = p_111124_;
            this.vert0Weights = p_111125_;
            this.vert1Weights = p_111126_;
            this.vert2Weights = p_111127_;
            this.vert3Weights = p_111128_;
        }

        public static AdjacencyInfo fromFacing(Direction p_111132_) {
            return BY_FACING[p_111132_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AdjacencyInfo[6], p_111134_ -> {
                p_111134_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111134_[Direction.UP.get3DDataValue()] = UP;
                p_111134_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111134_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111134_[Direction.WEST.get3DDataValue()] = WEST;
                p_111134_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }

    static enum AmbientVertexRemap {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        final int vert0;
        final int vert1;
        final int vert2;
        final int vert3;
        private static final AmbientVertexRemap[] BY_FACING;

        private AmbientVertexRemap(int p_111195_, int p_111196_, int p_111197_, int p_111198_) {
            this.vert0 = p_111195_;
            this.vert1 = p_111196_;
            this.vert2 = p_111197_;
            this.vert3 = p_111198_;
        }

        public static AmbientVertexRemap fromFacing(Direction p_111202_) {
            return BY_FACING[p_111202_.get3DDataValue()];
        }

        static {
            BY_FACING = Util.make(new AmbientVertexRemap[6], p_111204_ -> {
                p_111204_[Direction.DOWN.get3DDataValue()] = DOWN;
                p_111204_[Direction.UP.get3DDataValue()] = UP;
                p_111204_[Direction.NORTH.get3DDataValue()] = NORTH;
                p_111204_[Direction.SOUTH.get3DDataValue()] = SOUTH;
                p_111204_[Direction.WEST.get3DDataValue()] = WEST;
                p_111204_[Direction.EAST.get3DDataValue()] = EAST;
            });
        }
    }
}

