/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;

public class ViewArea {
    protected final LevelRenderer levelRenderer;
    protected final Level level;
    protected int sectionGridSizeY;
    protected int sectionGridSizeX;
    protected int sectionGridSizeZ;
    private int viewDistance;
    private SectionPos cameraSectionPos;
    public SectionRenderDispatcher.RenderSection[] sections;

    public ViewArea(SectionRenderDispatcher p_296460_, Level p_110846_, int p_110847_, LevelRenderer p_110848_) {
        this.levelRenderer = p_110848_;
        this.level = p_110846_;
        this.setViewDistance(p_110847_);
        this.createSections(p_296460_);
        this.cameraSectionPos = SectionPos.of(this.viewDistance + 1, 0, this.viewDistance + 1);
    }

    protected void createSections(SectionRenderDispatcher p_294825_) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new IllegalStateException("createSections called from wrong thread: " + Thread.currentThread().getName());
        }
        int $$1 = this.sectionGridSizeX * this.sectionGridSizeY * this.sectionGridSizeZ;
        this.sections = new SectionRenderDispatcher.RenderSection[$$1];
        for (int $$2 = 0; $$2 < this.sectionGridSizeX; ++$$2) {
            for (int $$3 = 0; $$3 < this.sectionGridSizeY; ++$$3) {
                for (int $$4 = 0; $$4 < this.sectionGridSizeZ; ++$$4) {
                    int $$5 = this.getSectionIndex($$2, $$3, $$4);
                    SectionRenderDispatcher sectionRenderDispatcher = p_294825_;
                    Objects.requireNonNull(sectionRenderDispatcher);
                    this.sections[$$5] = new SectionRenderDispatcher.RenderSection(sectionRenderDispatcher, $$5, SectionPos.asLong($$2, $$3 + this.level.getMinSectionY(), $$4));
                }
            }
        }
    }

    public void releaseAllBuffers() {
        for (SectionRenderDispatcher.RenderSection $$0 : this.sections) {
            $$0.reset();
        }
    }

    private int getSectionIndex(int p_295999_, int p_294097_, int p_294966_) {
        return (p_294966_ * this.sectionGridSizeY + p_294097_) * this.sectionGridSizeX + p_295999_;
    }

    protected void setViewDistance(int p_110854_) {
        int $$1;
        this.sectionGridSizeX = $$1 = p_110854_ * 2 + 1;
        this.sectionGridSizeY = this.level.getSectionsCount();
        this.sectionGridSizeZ = $$1;
        this.viewDistance = p_110854_;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public LevelHeightAccessor getLevelHeightAccessor() {
        return this.level;
    }

    public void repositionCamera(SectionPos p_366723_) {
        for (int $$1 = 0; $$1 < this.sectionGridSizeX; ++$$1) {
            int $$2 = p_366723_.x() - this.viewDistance;
            int $$3 = $$2 + Math.floorMod($$1 - $$2, this.sectionGridSizeX);
            for (int $$4 = 0; $$4 < this.sectionGridSizeZ; ++$$4) {
                int $$5 = p_366723_.z() - this.viewDistance;
                int $$6 = $$5 + Math.floorMod($$4 - $$5, this.sectionGridSizeZ);
                for (int $$7 = 0; $$7 < this.sectionGridSizeY; ++$$7) {
                    int $$8 = this.level.getMinSectionY() + $$7;
                    SectionRenderDispatcher.RenderSection $$9 = this.sections[this.getSectionIndex($$1, $$7, $$4)];
                    long $$10 = $$9.getSectionNode();
                    if ($$10 == SectionPos.asLong($$3, $$8, $$6)) continue;
                    $$9.setSectionNode(SectionPos.asLong($$3, $$8, $$6));
                }
            }
        }
        this.cameraSectionPos = p_366723_;
        this.levelRenderer.getSectionOcclusionGraph().invalidate();
    }

    public SectionPos getCameraSectionPos() {
        return this.cameraSectionPos;
    }

    public void setDirty(int p_110860_, int p_110861_, int p_110862_, boolean p_110863_) {
        SectionRenderDispatcher.RenderSection $$4 = this.getRenderSection(p_110860_, p_110861_, p_110862_);
        if ($$4 != null) {
            $$4.setDirty(p_110863_);
        }
    }

    @Nullable
    protected SectionRenderDispatcher.RenderSection getRenderSectionAt(BlockPos p_294239_) {
        return this.getRenderSection(SectionPos.asLong(p_294239_));
    }

    @Nullable
    protected SectionRenderDispatcher.RenderSection getRenderSection(long p_366845_) {
        int $$1 = SectionPos.x(p_366845_);
        int $$2 = SectionPos.y(p_366845_);
        int $$3 = SectionPos.z(p_366845_);
        return this.getRenderSection($$1, $$2, $$3);
    }

    @Nullable
    private SectionRenderDispatcher.RenderSection getRenderSection(int p_366548_, int p_366588_, int p_366508_) {
        if (!this.containsSection(p_366548_, p_366588_, p_366508_)) {
            return null;
        }
        int $$3 = p_366588_ - this.level.getMinSectionY();
        int $$4 = Math.floorMod(p_366548_, this.sectionGridSizeX);
        int $$5 = Math.floorMod(p_366508_, this.sectionGridSizeZ);
        return this.sections[this.getSectionIndex($$4, $$3, $$5)];
    }

    private boolean containsSection(int p_366483_, int p_366902_, int p_366901_) {
        if (p_366902_ < this.level.getMinSectionY() || p_366902_ > this.level.getMaxSectionY()) {
            return false;
        }
        if (p_366483_ < this.cameraSectionPos.x() - this.viewDistance || p_366483_ > this.cameraSectionPos.x() + this.viewDistance) {
            return false;
        }
        return p_366901_ >= this.cameraSectionPos.z() - this.viewDistance && p_366901_ <= this.cameraSectionPos.z() + this.viewDistance;
    }
}

