/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.CompiledRenderPipeline;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.ShaderType;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostChainConfig;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class ShaderManager
extends SimplePreparableReloadListener<Configs>
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_LOG_LENGTH = 32768;
    public static final String SHADER_PATH = "shaders";
    private static final String SHADER_INCLUDE_PATH = "shaders/include/";
    private static final FileToIdConverter POST_CHAIN_ID_CONVERTER = FileToIdConverter.json("post_effect");
    final TextureManager textureManager;
    private final Consumer<Exception> recoveryHandler;
    private CompilationCache compilationCache = new CompilationCache(Configs.EMPTY);
    final CachedOrthoProjectionMatrixBuffer postChainProjectionMatrixBuffer = new CachedOrthoProjectionMatrixBuffer("post", 0.1f, 1000.0f, false);

    public ShaderManager(TextureManager p_366478_, Consumer<Exception> p_368560_) {
        this.textureManager = p_366478_;
        this.recoveryHandler = p_368560_;
    }

    @Override
    protected Configs prepare(ResourceManager p_366761_, ProfilerFiller p_366562_) {
        ImmutableMap.Builder $$2 = ImmutableMap.builder();
        Map<ResourceLocation, Resource> $$3 = p_366761_.listResources(SHADER_PATH, ShaderManager::isShader);
        for (Map.Entry<ResourceLocation, Resource> $$4 : $$3.entrySet()) {
            ResourceLocation $$5 = $$4.getKey();
            ShaderType $$6 = ShaderType.byLocation($$5);
            if ($$6 == null) continue;
            ShaderManager.loadShader($$5, $$4.getValue(), $$6, $$3, (ImmutableMap.Builder<ShaderSourceKey, String>)$$2);
        }
        ImmutableMap.Builder $$7 = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, Resource> $$8 : POST_CHAIN_ID_CONVERTER.listMatchingResources(p_366761_).entrySet()) {
            ShaderManager.loadPostChain($$8.getKey(), $$8.getValue(), (ImmutableMap.Builder<ResourceLocation, PostChainConfig>)$$7);
        }
        return new Configs((Map<ShaderSourceKey, String>)$$2.build(), (Map<ResourceLocation, PostChainConfig>)$$7.build());
    }

    private static void loadShader(ResourceLocation p_366513_, Resource p_366763_, ShaderType p_410200_, Map<ResourceLocation, Resource> p_366725_, ImmutableMap.Builder<ShaderSourceKey, String> p_366733_) {
        ResourceLocation $$5 = p_410200_.idConverter().fileToId(p_366513_);
        GlslPreprocessor $$6 = ShaderManager.createPreprocessor(p_366725_, p_366513_);
        try (BufferedReader $$7 = p_366763_.openAsReader();){
            String $$8 = IOUtils.toString((Reader)$$7);
            p_366733_.put((Object)new ShaderSourceKey($$5, p_410200_), (Object)String.join((CharSequence)"", $$6.process($$8)));
        }
        catch (IOException $$9) {
            LOGGER.error("Failed to load shader source at {}", (Object)p_366513_, (Object)$$9);
        }
    }

    private static GlslPreprocessor createPreprocessor(final Map<ResourceLocation, Resource> p_366891_, ResourceLocation p_366860_) {
        final ResourceLocation $$2 = p_366860_.withPath(FileUtil::getFullResourcePath);
        return new GlslPreprocessor(){
            private final Set<ResourceLocation> importedLocations = new ObjectArraySet();

            /*
             * WARNING - void declaration
             */
            @Override
            public String applyImport(boolean p_366551_, String p_366739_) {
                String string;
                block13: {
                    void $$5;
                    try {
                        if (p_366551_) {
                            ResourceLocation $$22 = $$2.withPath(p_366623_ -> FileUtil.normalizeResourcePath(p_366623_ + p_366739_));
                        } else {
                            ResourceLocation $$3 = ResourceLocation.parse(p_366739_).withPrefix(ShaderManager.SHADER_INCLUDE_PATH);
                        }
                    }
                    catch (ResourceLocationException $$4) {
                        LOGGER.error("Malformed GLSL import {}: {}", (Object)p_366739_, (Object)$$4.getMessage());
                        return "#error " + $$4.getMessage();
                    }
                    if (!this.importedLocations.add((ResourceLocation)$$5)) {
                        return null;
                    }
                    BufferedReader $$6 = ((Resource)p_366891_.get($$5)).openAsReader();
                    try {
                        string = IOUtils.toString((Reader)$$6);
                        if ($$6 == null) break block13;
                    }
                    catch (Throwable throwable) {
                        try {
                            if ($$6 != null) {
                                try {
                                    ((Reader)$$6).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException $$7) {
                            LOGGER.error("Could not open GLSL import {}: {}", (Object)$$5, (Object)$$7.getMessage());
                            return "#error " + $$7.getMessage();
                        }
                    }
                    ((Reader)$$6).close();
                }
                return string;
            }
        };
    }

    private static void loadPostChain(ResourceLocation p_366838_, Resource p_366558_, ImmutableMap.Builder<ResourceLocation, PostChainConfig> p_366892_) {
        ResourceLocation $$3 = POST_CHAIN_ID_CONVERTER.fileToId(p_366838_);
        try (BufferedReader $$4 = p_366558_.openAsReader();){
            JsonElement $$5 = StrictJsonParser.parse($$4);
            p_366892_.put((Object)$$3, (Object)((PostChainConfig)PostChainConfig.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$5).getOrThrow(JsonSyntaxException::new)));
        }
        catch (JsonParseException | IOException $$6) {
            LOGGER.error("Failed to parse post chain at {}", (Object)p_366838_, (Object)$$6);
        }
    }

    private static boolean isShader(ResourceLocation p_366565_) {
        return ShaderType.byLocation(p_366565_) != null || p_366565_.getPath().endsWith(".glsl");
    }

    @Override
    protected void apply(Configs p_366597_, ResourceManager p_366533_, ProfilerFiller p_366866_) {
        CompilationCache $$3 = new CompilationCache(p_366597_);
        HashSet<RenderPipeline> $$4 = new HashSet<RenderPipeline>(RenderPipelines.getStaticPipelines());
        ArrayList<ResourceLocation> $$5 = new ArrayList<ResourceLocation>();
        GpuDevice $$6 = RenderSystem.getDevice();
        $$6.clearPipelineCache();
        for (RenderPipeline $$7 : $$4) {
            CompiledRenderPipeline $$8 = $$6.precompilePipeline($$7, $$3::getShaderSource);
            if ($$8.isValid()) continue;
            $$5.add($$7.getLocation());
        }
        if (!$$5.isEmpty()) {
            $$6.clearPipelineCache();
            throw new RuntimeException("Failed to load required shader programs:\n" + $$5.stream().map(p_409066_ -> " - " + String.valueOf(p_409066_)).collect(Collectors.joining("\n")));
        }
        this.compilationCache.close();
        this.compilationCache = $$3;
    }

    @Override
    public String getName() {
        return "Shader Loader";
    }

    private void tryTriggerRecovery(Exception p_383219_) {
        if (this.compilationCache.triggeredRecovery) {
            return;
        }
        this.recoveryHandler.accept(p_383219_);
        this.compilationCache.triggeredRecovery = true;
    }

    @Nullable
    public PostChain getPostChain(ResourceLocation p_366709_, Set<ResourceLocation> p_366652_) {
        try {
            return this.compilationCache.getOrLoadPostChain(p_366709_, p_366652_);
        }
        catch (CompilationException $$2) {
            LOGGER.error("Failed to load post chain: {}", (Object)p_366709_, (Object)$$2);
            this.compilationCache.postChains.put(p_366709_, Optional.empty());
            this.tryTriggerRecovery($$2);
            return null;
        }
    }

    @Override
    public void close() {
        this.compilationCache.close();
        this.postChainProjectionMatrixBuffer.close();
    }

    public String getShader(ResourceLocation p_410854_, ShaderType p_410496_) {
        return this.compilationCache.getShaderSource(p_410854_, p_410496_);
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }

    class CompilationCache
    implements AutoCloseable {
        private final Configs configs;
        final Map<ResourceLocation, Optional<PostChain>> postChains = new HashMap<ResourceLocation, Optional<PostChain>>();
        boolean triggeredRecovery;

        CompilationCache(Configs p_368510_) {
            this.configs = p_368510_;
        }

        @Nullable
        public PostChain getOrLoadPostChain(ResourceLocation p_368720_, Set<ResourceLocation> p_368722_) throws CompilationException {
            Optional<PostChain> $$2 = this.postChains.get(p_368720_);
            if ($$2 != null) {
                return $$2.orElse(null);
            }
            PostChain $$3 = this.loadPostChain(p_368720_, p_368722_);
            this.postChains.put(p_368720_, Optional.of($$3));
            return $$3;
        }

        private PostChain loadPostChain(ResourceLocation p_368578_, Set<ResourceLocation> p_368581_) throws CompilationException {
            PostChainConfig $$2 = this.configs.postChains.get(p_368578_);
            if ($$2 == null) {
                throw new CompilationException("Could not find post chain with id: " + String.valueOf(p_368578_));
            }
            return PostChain.load($$2, ShaderManager.this.textureManager, p_368581_, p_368578_, ShaderManager.this.postChainProjectionMatrixBuffer);
        }

        @Override
        public void close() {
            this.postChains.values().forEach(p_418047_ -> p_418047_.ifPresent(PostChain::close));
            this.postChains.clear();
        }

        public String getShaderSource(ResourceLocation p_409941_, ShaderType p_410764_) {
            return this.configs.shaderSources.get(new ShaderSourceKey(p_409941_, p_410764_));
        }
    }

    public record Configs(Map<ShaderSourceKey, String> shaderSources, Map<ResourceLocation, PostChainConfig> postChains) {
        public static final Configs EMPTY = new Configs(Map.of(), Map.of());
    }

    record ShaderSourceKey(ResourceLocation id, ShaderType type) {
        @Override
        public String toString() {
            return String.valueOf(this.id) + " (" + String.valueOf((Object)this.type) + ")";
        }
    }

    public static class CompilationException
    extends Exception {
        public CompilationException(String p_366771_) {
            super(p_366771_);
        }
    }
}

