/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class ScreenEffectRenderer {
    private static final ResourceLocation UNDERWATER_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/underwater.png");
    private final Minecraft minecraft;
    private final MultiBufferSource bufferSource;
    public static final int ITEM_ACTIVATION_ANIMATION_LENGTH = 40;
    @Nullable
    private ItemStack itemActivationItem;
    private int itemActivationTicks;
    private float itemActivationOffX;
    private float itemActivationOffY;

    public ScreenEffectRenderer(Minecraft p_416192_, MultiBufferSource p_416377_) {
        this.minecraft = p_416192_;
        this.bufferSource = p_416377_;
    }

    public void tick() {
        if (this.itemActivationTicks > 0) {
            --this.itemActivationTicks;
            if (this.itemActivationTicks == 0) {
                this.itemActivationItem = null;
            }
        }
    }

    public void renderScreenEffect(boolean p_416461_, float p_416655_) {
        PoseStack $$2 = new PoseStack();
        LocalPlayer $$3 = this.minecraft.player;
        if (this.minecraft.options.getCameraType().isFirstPerson() && !p_416461_) {
            BlockState $$4;
            if (!$$3.noPhysics && ($$4 = ScreenEffectRenderer.getViewBlockingState($$3)) != null) {
                ScreenEffectRenderer.renderTex(this.minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon($$4), $$2, this.bufferSource);
            }
            if (!this.minecraft.player.isSpectator()) {
                if (this.minecraft.player.isEyeInFluid(FluidTags.WATER)) {
                    ScreenEffectRenderer.renderWater(this.minecraft, $$2, this.bufferSource);
                }
                if (this.minecraft.player.isOnFire()) {
                    ScreenEffectRenderer.renderFire($$2, this.bufferSource);
                }
            }
        }
        if (!this.minecraft.options.hideGui) {
            this.renderItemActivationAnimation($$2, p_416655_);
        }
    }

    private void renderItemActivationAnimation(PoseStack p_416173_, float p_416588_) {
        if (this.itemActivationItem == null || this.itemActivationTicks <= 0) {
            return;
        }
        int $$2 = 40 - this.itemActivationTicks;
        float $$3 = ((float)$$2 + p_416588_) / 40.0f;
        float $$4 = $$3 * $$3;
        float $$5 = $$3 * $$4;
        float $$6 = 10.25f * $$5 * $$4 - 24.95f * $$4 * $$4 + 25.5f * $$5 - 13.8f * $$4 + 4.0f * $$3;
        float $$7 = $$6 * (float)Math.PI;
        float $$8 = (float)this.minecraft.getWindow().getWidth() / (float)this.minecraft.getWindow().getHeight();
        float $$9 = this.itemActivationOffX * 0.3f * $$8;
        float $$10 = this.itemActivationOffY * 0.3f;
        p_416173_.pushPose();
        p_416173_.translate($$9 * Mth.abs(Mth.sin($$7 * 2.0f)), $$10 * Mth.abs(Mth.sin($$7 * 2.0f)), -10.0f + 9.0f * Mth.sin($$7));
        float $$11 = 0.8f;
        p_416173_.scale(0.8f, 0.8f, 0.8f);
        p_416173_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(900.0f * Mth.abs(Mth.sin($$7))));
        p_416173_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(6.0f * Mth.cos($$3 * 8.0f)));
        p_416173_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(6.0f * Mth.cos($$3 * 8.0f)));
        this.minecraft.gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        this.minecraft.getItemRenderer().renderStatic(this.itemActivationItem, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, p_416173_, this.bufferSource, this.minecraft.level, 0);
        p_416173_.popPose();
    }

    public void resetItemActivation() {
        this.itemActivationItem = null;
    }

    public void displayItemActivation(ItemStack p_415543_, RandomSource p_416502_) {
        this.itemActivationItem = p_415543_;
        this.itemActivationTicks = 40;
        this.itemActivationOffX = p_416502_.nextFloat() * 2.0f - 1.0f;
        this.itemActivationOffY = p_416502_.nextFloat() * 2.0f - 1.0f;
    }

    @Nullable
    private static BlockState getViewBlockingState(Player p_110717_) {
        BlockPos.MutableBlockPos $$1 = new BlockPos.MutableBlockPos();
        for (int $$2 = 0; $$2 < 8; ++$$2) {
            double $$3 = p_110717_.getX() + (double)(((float)(($$2 >> 0) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            double $$4 = p_110717_.getEyeY() + (double)(((float)(($$2 >> 1) % 2) - 0.5f) * 0.1f * p_110717_.getScale());
            double $$5 = p_110717_.getZ() + (double)(((float)(($$2 >> 2) % 2) - 0.5f) * p_110717_.getBbWidth() * 0.8f);
            $$1.set($$3, $$4, $$5);
            BlockState $$6 = p_110717_.level().getBlockState($$1);
            if ($$6.getRenderShape() == RenderShape.INVISIBLE || !$$6.isViewBlocking(p_110717_.level(), $$1)) continue;
            return $$6;
        }
        return null;
    }

    private static void renderTex(TextureAtlasSprite p_173297_, PoseStack p_173298_, MultiBufferSource p_383030_) {
        float $$3 = 0.1f;
        int $$4 = ARGB.colorFromFloat(1.0f, 0.1f, 0.1f, 0.1f);
        float $$5 = -1.0f;
        float $$6 = 1.0f;
        float $$7 = -1.0f;
        float $$8 = 1.0f;
        float $$9 = -0.5f;
        float $$10 = p_173297_.getU0();
        float $$11 = p_173297_.getU1();
        float $$12 = p_173297_.getV0();
        float $$13 = p_173297_.getV1();
        Matrix4f $$14 = p_173298_.last().pose();
        VertexConsumer $$15 = p_383030_.getBuffer(RenderType.blockScreenEffect(p_173297_.atlasLocation()));
        $$15.addVertex($$14, -1.0f, -1.0f, -0.5f).setUv($$11, $$13).setColor($$4);
        $$15.addVertex($$14, 1.0f, -1.0f, -0.5f).setUv($$10, $$13).setColor($$4);
        $$15.addVertex($$14, 1.0f, 1.0f, -0.5f).setUv($$10, $$12).setColor($$4);
        $$15.addVertex($$14, -1.0f, 1.0f, -0.5f).setUv($$11, $$12).setColor($$4);
    }

    private static void renderWater(Minecraft p_110726_, PoseStack p_110727_, MultiBufferSource p_383128_) {
        BlockPos $$3 = BlockPos.containing(p_110726_.player.getX(), p_110726_.player.getEyeY(), p_110726_.player.getZ());
        float $$4 = LightTexture.getBrightness(p_110726_.player.level().dimensionType(), p_110726_.player.level().getMaxLocalRawBrightness($$3));
        int $$5 = ARGB.colorFromFloat(0.1f, $$4, $$4, $$4);
        float $$6 = 4.0f;
        float $$7 = -1.0f;
        float $$8 = 1.0f;
        float $$9 = -1.0f;
        float $$10 = 1.0f;
        float $$11 = -0.5f;
        float $$12 = -p_110726_.player.getYRot() / 64.0f;
        float $$13 = p_110726_.player.getXRot() / 64.0f;
        Matrix4f $$14 = p_110727_.last().pose();
        VertexConsumer $$15 = p_383128_.getBuffer(RenderType.blockScreenEffect(UNDERWATER_LOCATION));
        $$15.addVertex($$14, -1.0f, -1.0f, -0.5f).setUv(4.0f + $$12, 4.0f + $$13).setColor($$5);
        $$15.addVertex($$14, 1.0f, -1.0f, -0.5f).setUv(0.0f + $$12, 4.0f + $$13).setColor($$5);
        $$15.addVertex($$14, 1.0f, 1.0f, -0.5f).setUv(0.0f + $$12, 0.0f + $$13).setColor($$5);
        $$15.addVertex($$14, -1.0f, 1.0f, -0.5f).setUv(4.0f + $$12, 0.0f + $$13).setColor($$5);
    }

    private static void renderFire(PoseStack p_110730_, MultiBufferSource p_382958_) {
        TextureAtlasSprite $$2 = ModelBakery.FIRE_1.sprite();
        VertexConsumer $$3 = p_382958_.getBuffer(RenderType.fireScreenEffect($$2.atlasLocation()));
        float $$4 = $$2.getU0();
        float $$5 = $$2.getU1();
        float $$6 = ($$4 + $$5) / 2.0f;
        float $$7 = $$2.getV0();
        float $$8 = $$2.getV1();
        float $$9 = ($$7 + $$8) / 2.0f;
        float $$10 = $$2.uvShrinkRatio();
        float $$11 = Mth.lerp($$10, $$4, $$6);
        float $$12 = Mth.lerp($$10, $$5, $$6);
        float $$13 = Mth.lerp($$10, $$7, $$9);
        float $$14 = Mth.lerp($$10, $$8, $$9);
        float $$15 = 1.0f;
        for (int $$16 = 0; $$16 < 2; ++$$16) {
            p_110730_.pushPose();
            float $$17 = -0.5f;
            float $$18 = 0.5f;
            float $$19 = -0.5f;
            float $$20 = 0.5f;
            float $$21 = -0.5f;
            p_110730_.translate((float)(-($$16 * 2 - 1)) * 0.24f, -0.3f, 0.0f);
            p_110730_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)($$16 * 2 - 1) * 10.0f));
            Matrix4f $$22 = p_110730_.last().pose();
            $$3.addVertex($$22, -0.5f, -0.5f, -0.5f).setUv($$12, $$14).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$3.addVertex($$22, 0.5f, -0.5f, -0.5f).setUv($$11, $$14).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$3.addVertex($$22, 0.5f, 0.5f, -0.5f).setUv($$11, $$13).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            $$3.addVertex($$22, -0.5f, 0.5f, -0.5f).setUv($$12, $$13).setColor(1.0f, 1.0f, 1.0f, 0.9f);
            p_110730_.popPose();
        }
    }
}

