/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class PanoramaRenderer {
    public static final ResourceLocation PANORAMA_OVERLAY = ResourceLocation.withDefaultNamespace("textures/gui/title/background/panorama_overlay.png");
    private final Minecraft minecraft;
    private final CubeMap cubeMap;
    private float spin;

    public PanoramaRenderer(CubeMap p_110002_) {
        this.cubeMap = p_110002_;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(GuiGraphics p_334063_, int p_333839_, int p_333923_, boolean p_418077_) {
        if (p_418077_) {
            float $$4 = this.minecraft.getDeltaTracker().getRealtimeDeltaTicks();
            float $$5 = (float)((double)$$4 * this.minecraft.options.panoramaSpeed().get());
            this.spin = PanoramaRenderer.wrap(this.spin + $$5 * 0.1f, 360.0f);
        }
        this.cubeMap.render(this.minecraft, 10.0f, -this.spin);
        p_334063_.blit(RenderPipelines.GUI_TEXTURED, PANORAMA_OVERLAY, 0, 0, 0.0f, 0.0f, p_333839_, p_333923_, 16, 128, 16, 128);
    }

    private static float wrap(float p_249058_, float p_249548_) {
        return p_249058_ > p_249548_ ? p_249058_ - p_249548_ : p_249058_;
    }

    public void registerTextures(TextureManager p_423546_) {
        this.cubeMap.registerTextures(p_423546_);
    }
}

