/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MappableRingBuffer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightTexture
implements AutoCloseable {
    public static final int FULL_BRIGHT = 0xF000F0;
    public static final int FULL_SKY = 0xF00000;
    public static final int FULL_BLOCK = 240;
    private static final int TEXTURE_SIZE = 16;
    private static final int LIGHTMAP_UBO_SIZE = new Std140SizeCalculator().putFloat().putFloat().putFloat().putInt().putFloat().putFloat().putFloat().putFloat().putVec3().get();
    private final GpuTexture texture;
    private final GpuTextureView textureView;
    private boolean updateLightTexture;
    private float blockLightRedFlicker;
    private final GameRenderer renderer;
    private final Minecraft minecraft;
    private final MappableRingBuffer ubo;

    public LightTexture(GameRenderer p_109878_, Minecraft p_109879_) {
        this.renderer = p_109878_;
        this.minecraft = p_109879_;
        GpuDevice $$2 = RenderSystem.getDevice();
        this.texture = $$2.createTexture("Light Texture", 12, TextureFormat.RGBA8, 16, 16, 1, 1);
        this.texture.setTextureFilter(FilterMode.LINEAR, false);
        this.textureView = $$2.createTextureView(this.texture);
        $$2.createCommandEncoder().clearColorTexture(this.texture, -1);
        this.ubo = new MappableRingBuffer(() -> "Lightmap UBO", 130, LIGHTMAP_UBO_SIZE);
    }

    public GpuTextureView getTextureView() {
        return this.textureView;
    }

    @Override
    public void close() {
        this.texture.close();
        this.textureView.close();
        this.ubo.close();
    }

    public void tick() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.updateLightTexture = true;
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture(2, null);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture(2, this.textureView);
    }

    private float calculateDarknessScale(LivingEntity p_234313_, float p_234314_, float p_234315_) {
        float $$3 = 0.45f * p_234314_;
        return Math.max(0.0f, Mth.cos(((float)p_234313_.tickCount - p_234315_) * (float)Math.PI * 0.025f) * $$3);
    }

    public void updateLightTexture(float p_109882_) {
        float $$12;
        float $$5;
        if (!this.updateLightTexture) {
            return;
        }
        this.updateLightTexture = false;
        ProfilerFiller $$1 = Profiler.get();
        $$1.push("lightTex");
        ClientLevel $$2 = this.minecraft.level;
        if ($$2 == null) {
            return;
        }
        float $$3 = $$2.getSkyDarken(1.0f);
        if ($$2.getSkyFlashTime() > 0) {
            float $$4 = 1.0f;
        } else {
            $$5 = $$3 * 0.95f + 0.05f;
        }
        float $$6 = this.minecraft.options.darknessEffectScale().get().floatValue();
        float $$7 = this.minecraft.player.getEffectBlendFactor(MobEffects.DARKNESS, p_109882_) * $$6;
        float $$8 = this.calculateDarknessScale(this.minecraft.player, $$7, p_109882_) * $$6;
        float $$9 = this.minecraft.player.getWaterVision();
        if (this.minecraft.player.hasEffect(MobEffects.NIGHT_VISION)) {
            float $$10 = GameRenderer.getNightVisionScale(this.minecraft.player, p_109882_);
        } else if ($$9 > 0.0f && this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER)) {
            float $$11 = $$9;
        } else {
            $$12 = 0.0f;
        }
        Vector3f $$13 = new Vector3f($$3, $$3, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float $$14 = this.blockLightRedFlicker + 1.5f;
        float $$15 = $$2.dimensionType().ambientLight();
        boolean $$16 = $$2.effects().forceBrightLightmap();
        float $$17 = this.minecraft.options.gamma().get().floatValue();
        RenderSystem.AutoStorageIndexBuffer $$18 = RenderSystem.getSequentialBuffer(VertexFormat.Mode.QUADS);
        GpuBuffer $$19 = $$18.getBuffer(6);
        CommandEncoder $$20 = RenderSystem.getDevice().createCommandEncoder();
        try (GpuBuffer.MappedView $$21 = $$20.mapBuffer(this.ubo.currentBuffer(), false, true);){
            Std140Builder.intoBuffer($$21.data()).putFloat($$15).putFloat($$5).putFloat($$14).putInt($$16 ? 1 : 0).putFloat($$12).putFloat($$8).putFloat(this.renderer.getDarkenWorldAmount(p_109882_)).putFloat(Math.max(0.0f, $$17 - $$7)).putVec3((Vector3fc)$$13);
        }
        try (RenderPass $$22 = $$20.createRenderPass(() -> "Update light", this.textureView, OptionalInt.empty());){
            $$22.setPipeline(RenderPipelines.LIGHTMAP);
            RenderSystem.bindDefaultUniforms($$22);
            $$22.setUniform("LightmapInfo", this.ubo.currentBuffer());
            $$22.setVertexBuffer(0, RenderSystem.getQuadVertexBuffer());
            $$22.setIndexBuffer($$19, $$18.type());
            $$22.drawIndexed(0, 0, 6, 1);
        }
        this.ubo.rotate();
        $$1.pop();
    }

    public static float getBrightness(DimensionType p_234317_, int p_234318_) {
        return LightTexture.getBrightness(p_234317_.ambientLight(), p_234318_);
    }

    public static float getBrightness(float p_363336_, int p_361558_) {
        float $$2 = (float)p_361558_ / 15.0f;
        float $$3 = $$2 / (4.0f - 3.0f * $$2);
        return Mth.lerp(p_363336_, $$3, 1.0f);
    }

    public static int pack(int p_109886_, int p_109887_) {
        return p_109886_ << 4 | p_109887_ << 20;
    }

    public static int block(int p_109884_) {
        return p_109884_ >>> 4 & 0xF;
    }

    public static int sky(int p_109895_) {
        return p_109895_ >>> 20 & 0xF;
    }

    public static int lightCoordsWithEmission(int p_364253_, int p_362788_) {
        if (p_362788_ == 0) {
            return p_364253_;
        }
        int $$2 = Math.max(LightTexture.sky(p_364253_), p_362788_);
        int $$3 = Math.max(LightTexture.block(p_364253_), p_362788_);
        return LightTexture.pack($$3, $$2);
    }
}

