/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LevelEventHandler {
    private final Minecraft minecraft;
    private final Level level;
    private final LevelRenderer levelRenderer;
    private final Map<BlockPos, SoundInstance> playingJukeboxSongs = new HashMap<BlockPos, SoundInstance>();

    public LevelEventHandler(Minecraft p_365160_, Level p_362367_, LevelRenderer p_361552_) {
        this.minecraft = p_365160_;
        this.level = p_362367_;
        this.levelRenderer = p_361552_;
    }

    public void globalLevelEvent(int p_361814_, BlockPos p_361734_, int p_365242_) {
        switch (p_361814_) {
            case 1023: 
            case 1028: 
            case 1038: {
                Camera $$3 = this.minecraft.gameRenderer.getMainCamera();
                if (!$$3.isInitialized()) break;
                Vec3 $$4 = Vec3.atCenterOf(p_361734_).subtract($$3.getPosition()).normalize();
                Vec3 $$5 = $$3.getPosition().add($$4.scale(2.0));
                if (p_361814_ == 1023) {
                    this.level.playLocalSound($$5.x, $$5.y, $$5.z, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (p_361814_ == 1038) {
                    this.level.playLocalSound($$5.x, $$5.y, $$5.z, SoundEvents.END_PORTAL_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.level.playLocalSound($$5.x, $$5.y, $$5.z, SoundEvents.ENDER_DRAGON_DEATH, SoundSource.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void levelEvent(int p_364986_, BlockPos p_362181_, int p_360434_) {
        RandomSource $$3 = this.level.random;
        switch (p_364986_) {
            case 1035: {
                this.level.playLocalSound(p_362181_, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1033: {
                this.level.playLocalSound(p_362181_, SoundEvents.CHORUS_FLOWER_GROW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.level.playLocalSound(p_362181_, SoundEvents.CHORUS_FLOWER_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1032: {
                this.minecraft.getSoundManager().play(SimpleSoundInstance.forLocalAmbience(SoundEvents.PORTAL_TRAVEL, $$3.nextFloat() * 0.4f + 0.8f, 0.25f));
                break;
            }
            case 1001: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_FAIL, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1000: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_DISPENSE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1049: {
                this.level.playLocalSound(p_362181_, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1050: {
                this.level.playLocalSound(p_362181_, SoundEvents.CRAFTER_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1004: {
                this.level.playLocalSound(p_362181_, SoundEvents.FIREWORK_ROCKET_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.level.playLocalSound(p_362181_, SoundEvents.DISPENSER_LAUNCH, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1051: {
                this.level.playLocalSound(p_362181_, SoundEvents.WIND_CHARGE_THROW, SoundSource.BLOCKS, 0.5f, 0.4f / (this.level.getRandom().nextFloat() * 0.4f + 0.8f), false);
                break;
            }
            case 2010: {
                this.shootParticles(p_360434_, p_362181_, $$3, ParticleTypes.WHITE_SMOKE);
                break;
            }
            case 2000: {
                this.shootParticles(p_360434_, p_362181_, $$3, ParticleTypes.SMOKE);
                break;
            }
            case 2003: {
                double $$4 = (double)p_362181_.getX() + 0.5;
                double $$5 = p_362181_.getY();
                double $$6 = (double)p_362181_.getZ() + 0.5;
                for (int $$7 = 0; $$7 < 8; ++$$7) {
                    this.levelRenderer.addParticle(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.ENDER_EYE)), $$4, $$5, $$6, $$3.nextGaussian() * 0.15, $$3.nextDouble() * 0.2, $$3.nextGaussian() * 0.15);
                }
                for (double $$8 = 0.0; $$8 < Math.PI * 2; $$8 += 0.15707963267948966) {
                    this.levelRenderer.addParticle(ParticleTypes.PORTAL, $$4 + Math.cos($$8) * 5.0, $$5 - 0.4, $$6 + Math.sin($$8) * 5.0, Math.cos($$8) * -5.0, 0.0, Math.sin($$8) * -5.0);
                    this.levelRenderer.addParticle(ParticleTypes.PORTAL, $$4 + Math.cos($$8) * 5.0, $$5 - 0.4, $$6 + Math.sin($$8) * 5.0, Math.cos($$8) * -7.0, 0.0, Math.sin($$8) * -7.0);
                }
                break;
            }
            case 2002: 
            case 2007: {
                Vec3 $$9 = Vec3.atBottomCenterOf(p_362181_);
                for (int $$10 = 0; $$10 < 8; ++$$10) {
                    this.levelRenderer.addParticle(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.SPLASH_POTION)), $$9.x, $$9.y, $$9.z, $$3.nextGaussian() * 0.15, $$3.nextDouble() * 0.2, $$3.nextGaussian() * 0.15);
                }
                float $$11 = (float)(p_360434_ >> 16 & 0xFF) / 255.0f;
                float $$12 = (float)(p_360434_ >> 8 & 0xFF) / 255.0f;
                float $$13 = (float)(p_360434_ >> 0 & 0xFF) / 255.0f;
                SimpleParticleType $$14 = p_364986_ == 2007 ? ParticleTypes.INSTANT_EFFECT : ParticleTypes.EFFECT;
                for (int $$15 = 0; $$15 < 100; ++$$15) {
                    double $$16 = $$3.nextDouble() * 4.0;
                    double $$17 = $$3.nextDouble() * Math.PI * 2.0;
                    double $$18 = Math.cos($$17) * $$16;
                    double $$19 = 0.01 + $$3.nextDouble() * 0.5;
                    double $$20 = Math.sin($$17) * $$16;
                    Particle $$21 = this.levelRenderer.addParticleInternal($$14, $$14.getType().getOverrideLimiter(), $$9.x + $$18 * 0.1, $$9.y + 0.3, $$9.z + $$20 * 0.1, $$18, $$19, $$20);
                    if ($$21 == null) continue;
                    float $$22 = 0.75f + $$3.nextFloat() * 0.25f;
                    $$21.setColor($$11 * $$22, $$12 * $$22, $$13 * $$22);
                    $$21.setPower((float)$$16);
                }
                this.level.playLocalSound(p_362181_, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2001: {
                BlockState $$23 = Block.stateById(p_360434_);
                if (!$$23.isAir()) {
                    SoundType $$24 = $$23.getSoundType();
                    this.level.playLocalSound(p_362181_, $$24.getBreakSound(), SoundSource.BLOCKS, ($$24.getVolume() + 1.0f) / 2.0f, $$24.getPitch() * 0.8f, false);
                }
                this.level.addDestroyBlockEffect(p_362181_, $$23);
                break;
            }
            case 3008: {
                BlockState $$25 = Block.stateById(p_360434_);
                Block $$13 = $$25.getBlock();
                if ($$13 instanceof BrushableBlock) {
                    BrushableBlock $$26 = (BrushableBlock)$$13;
                    this.level.playLocalSound(p_362181_, $$26.getBrushCompletedSound(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                this.level.addDestroyBlockEffect(p_362181_, $$25);
                break;
            }
            case 2004: {
                for (int $$27 = 0; $$27 < 20; ++$$27) {
                    double $$28 = (double)p_362181_.getX() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    double $$29 = (double)p_362181_.getY() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    double $$30 = (double)p_362181_.getZ() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    this.level.addParticle(ParticleTypes.SMOKE, $$28, $$29, $$30, 0.0, 0.0, 0.0);
                    this.level.addParticle(ParticleTypes.FLAME, $$28, $$29, $$30, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 3011: {
                TrialSpawner.addSpawnParticles(this.level, p_362181_, $$3, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
                break;
            }
            case 3012: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_362181_, $$3, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
                break;
            }
            case 3021: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_362181_, $$3, TrialSpawner.FlameParticle.decode((int)p_360434_).particleType);
                break;
            }
            case 3013: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, $$3, p_360434_, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER);
                break;
            }
            case 3019: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, $$3, p_360434_, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                break;
            }
            case 3020: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, p_360434_ == 0 ? 0.3f : 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_362181_, $$3, 0, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                TrialSpawner.addBecomeOminousParticles(this.level, p_362181_, $$3);
                break;
            }
            case 3014: {
                this.level.playLocalSound(p_362181_, SoundEvents.TRIAL_SPAWNER_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addEjectItemParticles(this.level, p_362181_, $$3);
                break;
            }
            case 3017: {
                TrialSpawner.addEjectItemParticles(this.level, p_362181_, $$3);
                break;
            }
            case 3015: {
                BlockEntity $$28 = this.level.getBlockEntity(p_362181_);
                if (!($$28 instanceof VaultBlockEntity)) break;
                VaultBlockEntity $$31 = (VaultBlockEntity)$$28;
                VaultBlockEntity.Client.emitActivationParticles(this.level, $$31.getBlockPos(), $$31.getBlockState(), $$31.getSharedData(), p_360434_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME);
                this.level.playLocalSound(p_362181_, SoundEvents.VAULT_ACTIVATE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3016: {
                VaultBlockEntity.Client.emitDeactivationParticles(this.level, p_362181_, p_360434_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME);
                this.level.playLocalSound(p_362181_, SoundEvents.VAULT_DEACTIVATE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3018: {
                for (int $$32 = 0; $$32 < 10; ++$$32) {
                    double $$33 = $$3.nextGaussian() * 0.02;
                    double $$34 = $$3.nextGaussian() * 0.02;
                    double $$35 = $$3.nextGaussian() * 0.02;
                    this.level.addParticle(ParticleTypes.POOF, (double)p_362181_.getX() + $$3.nextDouble(), (double)p_362181_.getY() + $$3.nextDouble(), (double)p_362181_.getZ() + $$3.nextDouble(), $$33, $$34, $$35);
                }
                this.level.playLocalSound(p_362181_, SoundEvents.COBWEB_PLACE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 1505: {
                BoneMealItem.addGrowthParticles(this.level, p_362181_, p_360434_);
                this.level.playLocalSound(p_362181_, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2011: {
                ParticleUtils.spawnParticleInBlock(this.level, p_362181_, p_360434_, ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 2012: {
                ParticleUtils.spawnParticleInBlock(this.level, p_362181_, p_360434_, ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 3009: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_362181_, ParticleTypes.EGG_CRACK, UniformInt.of(3, 6));
                break;
            }
            case 3002: {
                if (p_360434_ >= 0 && p_360434_ < Direction.Axis.VALUES.length) {
                    ParticleUtils.spawnParticlesAlongAxis(Direction.Axis.VALUES[p_360434_], this.level, p_362181_, 0.125, ParticleTypes.ELECTRIC_SPARK, UniformInt.of(10, 19));
                    break;
                }
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_362181_, ParticleTypes.ELECTRIC_SPARK, UniformInt.of(3, 5));
                break;
            }
            case 2013: {
                ParticleUtils.spawnSmashAttackParticles(this.level, p_362181_, p_360434_);
                break;
            }
            case 3006: {
                int $$36 = p_360434_ >> 6;
                if ($$36 > 0) {
                    if ($$3.nextFloat() < 0.3f + (float)$$36 * 0.1f) {
                        float $$37 = 0.15f + 0.02f * (float)$$36 * (float)$$36 * $$3.nextFloat();
                        float $$38 = 0.4f + 0.3f * (float)$$36 * $$3.nextFloat();
                        this.level.playLocalSound(p_362181_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, $$37, $$38, false);
                    }
                    byte $$39 = (byte)(p_360434_ & 0x3F);
                    UniformInt $$40 = UniformInt.of(0, $$36);
                    float $$41 = 0.005f;
                    Supplier<Vec3> $$42 = () -> new Vec3(Mth.nextDouble($$3, -0.005f, 0.005f), Mth.nextDouble($$3, -0.005f, 0.005f), Mth.nextDouble($$3, -0.005f, 0.005f));
                    if ($$39 == 0) {
                        for (Direction $$43 : Direction.values()) {
                            float $$44 = $$43 == Direction.DOWN ? (float)Math.PI : 0.0f;
                            double $$45 = $$43.getAxis() == Direction.Axis.Y ? 0.65 : 0.57;
                            ParticleUtils.spawnParticlesOnBlockFace(this.level, p_362181_, new SculkChargeParticleOptions($$44), $$40, $$43, $$42, $$45);
                        }
                    } else {
                        for (Direction $$46 : MultifaceBlock.unpack($$39)) {
                            float $$47 = $$46 == Direction.UP ? (float)Math.PI : 0.0f;
                            double $$48 = 0.35;
                            ParticleUtils.spawnParticlesOnBlockFace(this.level, p_362181_, new SculkChargeParticleOptions($$47), $$40, $$46, $$42, 0.35);
                        }
                    }
                } else {
                    this.level.playLocalSound(p_362181_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    boolean $$49 = this.level.getBlockState(p_362181_).isCollisionShapeFullBlock(this.level, p_362181_);
                    int $$50 = $$49 ? 40 : 20;
                    float $$51 = $$49 ? 0.45f : 0.25f;
                    float $$52 = 0.07f;
                    for (int $$53 = 0; $$53 < $$50; ++$$53) {
                        float $$54 = 2.0f * $$3.nextFloat() - 1.0f;
                        float $$55 = 2.0f * $$3.nextFloat() - 1.0f;
                        float $$56 = 2.0f * $$3.nextFloat() - 1.0f;
                        this.level.addParticle(ParticleTypes.SCULK_CHARGE_POP, (double)p_362181_.getX() + 0.5 + (double)($$54 * $$51), (double)p_362181_.getY() + 0.5 + (double)($$55 * $$51), (double)p_362181_.getZ() + 0.5 + (double)($$56 * $$51), $$54 * 0.07f, $$55 * 0.07f, $$56 * 0.07f);
                    }
                }
                break;
            }
            case 3007: {
                boolean $$59;
                for (int $$57 = 0; $$57 < 10; ++$$57) {
                    this.level.addParticle(new ShriekParticleOption($$57 * 5), (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + SculkShriekerBlock.TOP_Y, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                BlockState $$58 = this.level.getBlockState(p_362181_);
                boolean bl = $$59 = $$58.hasProperty(BlockStateProperties.WATERLOGGED) && $$58.getValue(BlockStateProperties.WATERLOGGED) != false;
                if ($$59) break;
                this.level.playLocalSound((double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + SculkShriekerBlock.TOP_Y, (double)p_362181_.getZ() + 0.5, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 2.0f, 0.6f + this.level.random.nextFloat() * 0.4f, false);
                break;
            }
            case 3003: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_362181_, ParticleTypes.WAX_ON, UniformInt.of(3, 5));
                this.level.playLocalSound(p_362181_, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 3004: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_362181_, ParticleTypes.WAX_OFF, UniformInt.of(3, 5));
                break;
            }
            case 3005: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_362181_, ParticleTypes.SCRAPE, UniformInt.of(3, 5));
                break;
            }
            case 2008: {
                this.level.addParticle(ParticleTypes.EXPLOSION, (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + 0.5, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 1500: {
                ComposterBlock.handleFill(this.level, p_362181_, p_360434_ > 0);
                break;
            }
            case 1504: {
                PointedDripstoneBlock.spawnDripParticle(this.level, p_362181_, this.level.getBlockState(p_362181_));
                break;
            }
            case 1501: {
                this.level.playLocalSound(p_362181_, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                for (int $$60 = 0; $$60 < 8; ++$$60) {
                    this.level.addParticle(ParticleTypes.LARGE_SMOKE, (double)p_362181_.getX() + $$3.nextDouble(), (double)p_362181_.getY() + 1.2, (double)p_362181_.getZ() + $$3.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                this.level.playLocalSound(p_362181_, SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                for (int $$61 = 0; $$61 < 5; ++$$61) {
                    double $$62 = (double)p_362181_.getX() + $$3.nextDouble() * 0.6 + 0.2;
                    double $$63 = (double)p_362181_.getY() + $$3.nextDouble() * 0.6 + 0.2;
                    double $$64 = (double)p_362181_.getZ() + $$3.nextDouble() * 0.6 + 0.2;
                    this.level.addParticle(ParticleTypes.SMOKE, $$62, $$63, $$64, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                this.level.playLocalSound(p_362181_, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int $$65 = 0; $$65 < 16; ++$$65) {
                    double $$66 = (double)p_362181_.getX() + (5.0 + $$3.nextDouble() * 6.0) / 16.0;
                    double $$67 = (double)p_362181_.getY() + 0.8125;
                    double $$68 = (double)p_362181_.getZ() + (5.0 + $$3.nextDouble() * 6.0) / 16.0;
                    this.level.addParticle(ParticleTypes.SMOKE, $$66, $$67, $$68, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2006: {
                for (int $$69 = 0; $$69 < 200; ++$$69) {
                    float $$70 = $$3.nextFloat() * 4.0f;
                    float $$71 = $$3.nextFloat() * ((float)Math.PI * 2);
                    double $$72 = Mth.cos($$71) * $$70;
                    double $$73 = 0.01 + $$3.nextDouble() * 0.5;
                    double $$74 = Mth.sin($$71) * $$70;
                    Particle $$75 = this.levelRenderer.addParticleInternal(ParticleTypes.DRAGON_BREATH, false, (double)p_362181_.getX() + $$72 * 0.1, (double)p_362181_.getY() + 0.3, (double)p_362181_.getZ() + $$74 * 0.1, $$72, $$73, $$74);
                    if ($$75 == null) continue;
                    $$75.setPower($$70);
                }
                if (p_360434_ != 1) break;
                this.level.playLocalSound(p_362181_, SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.HOSTILE, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2009: {
                for (int $$76 = 0; $$76 < 8; ++$$76) {
                    this.level.addParticle(ParticleTypes.CLOUD, (double)p_362181_.getX() + $$3.nextDouble(), (double)p_362181_.getY() + 1.2, (double)p_362181_.getZ() + $$3.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1009: {
                if (p_360434_ == 0) {
                    this.level.playLocalSound(p_362181_, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                    break;
                }
                if (p_360434_ != 1) break;
                this.level.playLocalSound(p_362181_, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.7f, 1.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.4f, false);
                break;
            }
            case 1029: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1044: {
                this.level.playLocalSound(p_362181_, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.level.playLocalSound(p_362181_, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.level.playLocalSound(p_362181_, SoundEvents.PHANTOM_BITE, SoundSource.HOSTILE, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1010: {
                this.level.registryAccess().lookupOrThrow(Registries.JUKEBOX_SONG).get(p_360434_).ifPresent(p_360383_ -> this.playJukeboxSong((Holder<JukeboxSong>)p_360383_, p_362181_));
                break;
            }
            case 1011: {
                this.stopJukeboxSongAndNotifyNearby(p_362181_);
                break;
            }
            case 1015: {
                this.level.playLocalSound(p_362181_, SoundEvents.GHAST_WARN, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.level.playLocalSound(p_362181_, SoundEvents.ENDER_DRAGON_SHOOT, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.level.playLocalSound(p_362181_, SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_ATTACK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.level.playLocalSound(p_362181_, SoundEvents.WITHER_BREAK_BLOCK, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.level.playLocalSound(p_362181_, SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.level.playLocalSound(p_362181_, SoundEvents.WITHER_SHOOT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_INFECT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1040: {
                this.level.playLocalSound(p_362181_, SoundEvents.ZOMBIE_CONVERTED_TO_DROWNED, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.level.playLocalSound(p_362181_, SoundEvents.HUSK_CONVERTED_TO_ZOMBIE, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.level.playLocalSound(p_362181_, SoundEvents.BAT_TAKEOFF, SoundSource.NEUTRAL, 0.05f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.level.playLocalSound(p_362181_, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.level.playLocalSound(p_362181_, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                this.level.addParticle(ParticleTypes.EXPLOSION_EMITTER, true, true, (double)p_362181_.getX() + 0.5, (double)p_362181_.getY() + 0.5, (double)p_362181_.getZ() + 0.5, 0.0, 0.0, 0.0);
                this.level.playLocalSound(p_362181_, SoundEvents.END_GATEWAY_SPAWN, SoundSource.BLOCKS, 10.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.level.playLocalSound(p_362181_, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.HOSTILE, 64.0f, 0.8f + this.level.random.nextFloat() * 0.3f, false);
                break;
            }
            case 1045: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_LAND, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1046: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1047: {
                this.level.playLocalSound(p_362181_, SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1048: {
                this.level.playLocalSound(p_362181_, SoundEvents.SKELETON_CONVERTED_TO_STRAY, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
            }
        }
    }

    private void shootParticles(int p_365183_, BlockPos p_360425_, RandomSource p_363511_, SimpleParticleType p_363016_) {
        Direction $$4 = Direction.from3DDataValue(p_365183_);
        int $$5 = $$4.getStepX();
        int $$6 = $$4.getStepY();
        int $$7 = $$4.getStepZ();
        for (int $$8 = 0; $$8 < 10; ++$$8) {
            double $$9 = p_363511_.nextDouble() * 0.2 + 0.01;
            double $$10 = (double)p_360425_.getX() + (double)$$5 * 0.6 + 0.5 + (double)$$5 * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)$$7 * 0.5;
            double $$11 = (double)p_360425_.getY() + (double)$$6 * 0.6 + 0.5 + (double)$$6 * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)$$6 * 0.5;
            double $$12 = (double)p_360425_.getZ() + (double)$$7 * 0.6 + 0.5 + (double)$$7 * 0.01 + (p_363511_.nextDouble() - 0.5) * (double)$$5 * 0.5;
            double $$13 = (double)$$5 * $$9 + p_363511_.nextGaussian() * 0.01;
            double $$14 = (double)$$6 * $$9 + p_363511_.nextGaussian() * 0.01;
            double $$15 = (double)$$7 * $$9 + p_363511_.nextGaussian() * 0.01;
            this.levelRenderer.addParticle(p_363016_, $$10, $$11, $$12, $$13, $$14, $$15);
        }
    }

    private void playJukeboxSong(Holder<JukeboxSong> p_362746_, BlockPos p_364603_) {
        this.stopJukeboxSong(p_364603_);
        JukeboxSong $$2 = p_362746_.value();
        SoundEvent $$3 = $$2.soundEvent().value();
        SimpleSoundInstance $$4 = SimpleSoundInstance.forJukeboxSong($$3, Vec3.atCenterOf(p_364603_));
        this.playingJukeboxSongs.put(p_364603_, $$4);
        this.minecraft.getSoundManager().play($$4);
        this.minecraft.gui.setNowPlaying($$2.description());
        this.notifyNearbyEntities(this.level, p_364603_, true);
    }

    private void stopJukeboxSong(BlockPos p_360572_) {
        SoundInstance $$1 = this.playingJukeboxSongs.remove(p_360572_);
        if ($$1 != null) {
            this.minecraft.getSoundManager().stop($$1);
        }
    }

    private void stopJukeboxSongAndNotifyNearby(BlockPos p_364810_) {
        this.stopJukeboxSong(p_364810_);
        this.notifyNearbyEntities(this.level, p_364810_, false);
    }

    private void notifyNearbyEntities(Level p_365258_, BlockPos p_363364_, boolean p_360693_) {
        List<LivingEntity> $$3 = p_365258_.getEntitiesOfClass(LivingEntity.class, new AABB(p_363364_).inflate(3.0));
        for (LivingEntity $$4 : $$3) {
            $$4.setRecordPlayingNearby(p_363364_, p_360693_);
        }
    }
}

