/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class ItemBlockRenderTypes {
    private static final Map<Block, ChunkSectionLayer> TYPE_BY_BLOCK = Util.make(Maps.newHashMap(), p_401711_ -> {
        ChunkSectionLayer $$1 = ChunkSectionLayer.TRIPWIRE;
        p_401711_.put(Blocks.TRIPWIRE, $$1);
        ChunkSectionLayer $$2 = ChunkSectionLayer.CUTOUT_MIPPED;
        p_401711_.put(Blocks.GRASS_BLOCK, $$2);
        p_401711_.put(Blocks.IRON_BARS, $$2);
        p_401711_.put(Blocks.GLASS_PANE, $$2);
        p_401711_.put(Blocks.TRIPWIRE_HOOK, $$2);
        p_401711_.put(Blocks.HOPPER, $$2);
        p_401711_.put(Blocks.CHAIN, $$2);
        p_401711_.put(Blocks.JUNGLE_LEAVES, $$2);
        p_401711_.put(Blocks.OAK_LEAVES, $$2);
        p_401711_.put(Blocks.SPRUCE_LEAVES, $$2);
        p_401711_.put(Blocks.ACACIA_LEAVES, $$2);
        p_401711_.put(Blocks.CHERRY_LEAVES, $$2);
        p_401711_.put(Blocks.BIRCH_LEAVES, $$2);
        p_401711_.put(Blocks.DARK_OAK_LEAVES, $$2);
        p_401711_.put(Blocks.PALE_OAK_LEAVES, $$2);
        p_401711_.put(Blocks.AZALEA_LEAVES, $$2);
        p_401711_.put(Blocks.FLOWERING_AZALEA_LEAVES, $$2);
        p_401711_.put(Blocks.MANGROVE_ROOTS, $$2);
        p_401711_.put(Blocks.MANGROVE_LEAVES, $$2);
        ChunkSectionLayer $$3 = ChunkSectionLayer.CUTOUT;
        p_401711_.put(Blocks.OAK_SAPLING, $$3);
        p_401711_.put(Blocks.SPRUCE_SAPLING, $$3);
        p_401711_.put(Blocks.BIRCH_SAPLING, $$3);
        p_401711_.put(Blocks.JUNGLE_SAPLING, $$3);
        p_401711_.put(Blocks.ACACIA_SAPLING, $$3);
        p_401711_.put(Blocks.CHERRY_SAPLING, $$3);
        p_401711_.put(Blocks.DARK_OAK_SAPLING, $$3);
        p_401711_.put(Blocks.PALE_OAK_SAPLING, $$3);
        p_401711_.put(Blocks.GLASS, $$3);
        p_401711_.put(Blocks.WHITE_BED, $$3);
        p_401711_.put(Blocks.ORANGE_BED, $$3);
        p_401711_.put(Blocks.MAGENTA_BED, $$3);
        p_401711_.put(Blocks.LIGHT_BLUE_BED, $$3);
        p_401711_.put(Blocks.YELLOW_BED, $$3);
        p_401711_.put(Blocks.LIME_BED, $$3);
        p_401711_.put(Blocks.PINK_BED, $$3);
        p_401711_.put(Blocks.GRAY_BED, $$3);
        p_401711_.put(Blocks.LIGHT_GRAY_BED, $$3);
        p_401711_.put(Blocks.CYAN_BED, $$3);
        p_401711_.put(Blocks.PURPLE_BED, $$3);
        p_401711_.put(Blocks.BLUE_BED, $$3);
        p_401711_.put(Blocks.BROWN_BED, $$3);
        p_401711_.put(Blocks.GREEN_BED, $$3);
        p_401711_.put(Blocks.RED_BED, $$3);
        p_401711_.put(Blocks.BLACK_BED, $$3);
        p_401711_.put(Blocks.POWERED_RAIL, $$3);
        p_401711_.put(Blocks.DETECTOR_RAIL, $$3);
        p_401711_.put(Blocks.COBWEB, $$3);
        p_401711_.put(Blocks.SHORT_GRASS, $$3);
        p_401711_.put(Blocks.FERN, $$3);
        p_401711_.put(Blocks.BUSH, $$3);
        p_401711_.put(Blocks.DEAD_BUSH, $$3);
        p_401711_.put(Blocks.SHORT_DRY_GRASS, $$3);
        p_401711_.put(Blocks.TALL_DRY_GRASS, $$3);
        p_401711_.put(Blocks.SEAGRASS, $$3);
        p_401711_.put(Blocks.TALL_SEAGRASS, $$3);
        p_401711_.put(Blocks.DANDELION, $$3);
        p_401711_.put(Blocks.OPEN_EYEBLOSSOM, $$3);
        p_401711_.put(Blocks.CLOSED_EYEBLOSSOM, $$3);
        p_401711_.put(Blocks.POPPY, $$3);
        p_401711_.put(Blocks.BLUE_ORCHID, $$3);
        p_401711_.put(Blocks.ALLIUM, $$3);
        p_401711_.put(Blocks.AZURE_BLUET, $$3);
        p_401711_.put(Blocks.RED_TULIP, $$3);
        p_401711_.put(Blocks.ORANGE_TULIP, $$3);
        p_401711_.put(Blocks.WHITE_TULIP, $$3);
        p_401711_.put(Blocks.PINK_TULIP, $$3);
        p_401711_.put(Blocks.OXEYE_DAISY, $$3);
        p_401711_.put(Blocks.CORNFLOWER, $$3);
        p_401711_.put(Blocks.WITHER_ROSE, $$3);
        p_401711_.put(Blocks.LILY_OF_THE_VALLEY, $$3);
        p_401711_.put(Blocks.BROWN_MUSHROOM, $$3);
        p_401711_.put(Blocks.RED_MUSHROOM, $$3);
        p_401711_.put(Blocks.TORCH, $$3);
        p_401711_.put(Blocks.WALL_TORCH, $$3);
        p_401711_.put(Blocks.SOUL_TORCH, $$3);
        p_401711_.put(Blocks.SOUL_WALL_TORCH, $$3);
        p_401711_.put(Blocks.FIRE, $$3);
        p_401711_.put(Blocks.SOUL_FIRE, $$3);
        p_401711_.put(Blocks.SPAWNER, $$3);
        p_401711_.put(Blocks.TRIAL_SPAWNER, $$3);
        p_401711_.put(Blocks.VAULT, $$3);
        p_401711_.put(Blocks.REDSTONE_WIRE, $$3);
        p_401711_.put(Blocks.WHEAT, $$3);
        p_401711_.put(Blocks.OAK_DOOR, $$3);
        p_401711_.put(Blocks.LADDER, $$3);
        p_401711_.put(Blocks.RAIL, $$3);
        p_401711_.put(Blocks.IRON_DOOR, $$3);
        p_401711_.put(Blocks.REDSTONE_TORCH, $$3);
        p_401711_.put(Blocks.REDSTONE_WALL_TORCH, $$3);
        p_401711_.put(Blocks.CACTUS, $$3);
        p_401711_.put(Blocks.SUGAR_CANE, $$3);
        p_401711_.put(Blocks.REPEATER, $$3);
        p_401711_.put(Blocks.OAK_TRAPDOOR, $$3);
        p_401711_.put(Blocks.SPRUCE_TRAPDOOR, $$3);
        p_401711_.put(Blocks.BIRCH_TRAPDOOR, $$3);
        p_401711_.put(Blocks.JUNGLE_TRAPDOOR, $$3);
        p_401711_.put(Blocks.ACACIA_TRAPDOOR, $$3);
        p_401711_.put(Blocks.CHERRY_TRAPDOOR, $$3);
        p_401711_.put(Blocks.DARK_OAK_TRAPDOOR, $$3);
        p_401711_.put(Blocks.PALE_OAK_TRAPDOOR, $$3);
        p_401711_.put(Blocks.CRIMSON_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WARPED_TRAPDOOR, $$3);
        p_401711_.put(Blocks.MANGROVE_TRAPDOOR, $$3);
        p_401711_.put(Blocks.BAMBOO_TRAPDOOR, $$3);
        p_401711_.put(Blocks.COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.EXPOSED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WEATHERED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.OXIDIZED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WAXED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WAXED_EXPOSED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.WAXED_OXIDIZED_COPPER_TRAPDOOR, $$3);
        p_401711_.put(Blocks.ATTACHED_PUMPKIN_STEM, $$3);
        p_401711_.put(Blocks.ATTACHED_MELON_STEM, $$3);
        p_401711_.put(Blocks.PUMPKIN_STEM, $$3);
        p_401711_.put(Blocks.MELON_STEM, $$3);
        p_401711_.put(Blocks.VINE, $$3);
        p_401711_.put(Blocks.PALE_MOSS_CARPET, $$3);
        p_401711_.put(Blocks.PALE_HANGING_MOSS, $$3);
        p_401711_.put(Blocks.GLOW_LICHEN, $$3);
        p_401711_.put(Blocks.RESIN_CLUMP, $$3);
        p_401711_.put(Blocks.LILY_PAD, $$3);
        p_401711_.put(Blocks.NETHER_WART, $$3);
        p_401711_.put(Blocks.BREWING_STAND, $$3);
        p_401711_.put(Blocks.COCOA, $$3);
        p_401711_.put(Blocks.BEACON, $$3);
        p_401711_.put(Blocks.FLOWER_POT, $$3);
        p_401711_.put(Blocks.POTTED_OAK_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_SPRUCE_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_BIRCH_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_JUNGLE_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_ACACIA_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_CHERRY_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_DARK_OAK_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_PALE_OAK_SAPLING, $$3);
        p_401711_.put(Blocks.POTTED_MANGROVE_PROPAGULE, $$3);
        p_401711_.put(Blocks.POTTED_FERN, $$3);
        p_401711_.put(Blocks.POTTED_DANDELION, $$3);
        p_401711_.put(Blocks.POTTED_POPPY, $$3);
        p_401711_.put(Blocks.POTTED_OPEN_EYEBLOSSOM, $$3);
        p_401711_.put(Blocks.POTTED_CLOSED_EYEBLOSSOM, $$3);
        p_401711_.put(Blocks.POTTED_BLUE_ORCHID, $$3);
        p_401711_.put(Blocks.POTTED_ALLIUM, $$3);
        p_401711_.put(Blocks.POTTED_AZURE_BLUET, $$3);
        p_401711_.put(Blocks.POTTED_RED_TULIP, $$3);
        p_401711_.put(Blocks.POTTED_ORANGE_TULIP, $$3);
        p_401711_.put(Blocks.POTTED_WHITE_TULIP, $$3);
        p_401711_.put(Blocks.POTTED_PINK_TULIP, $$3);
        p_401711_.put(Blocks.POTTED_OXEYE_DAISY, $$3);
        p_401711_.put(Blocks.POTTED_CORNFLOWER, $$3);
        p_401711_.put(Blocks.POTTED_LILY_OF_THE_VALLEY, $$3);
        p_401711_.put(Blocks.POTTED_WITHER_ROSE, $$3);
        p_401711_.put(Blocks.POTTED_RED_MUSHROOM, $$3);
        p_401711_.put(Blocks.POTTED_BROWN_MUSHROOM, $$3);
        p_401711_.put(Blocks.POTTED_DEAD_BUSH, $$3);
        p_401711_.put(Blocks.POTTED_CACTUS, $$3);
        p_401711_.put(Blocks.POTTED_AZALEA, $$3);
        p_401711_.put(Blocks.POTTED_FLOWERING_AZALEA, $$3);
        p_401711_.put(Blocks.POTTED_TORCHFLOWER, $$3);
        p_401711_.put(Blocks.CARROTS, $$3);
        p_401711_.put(Blocks.POTATOES, $$3);
        p_401711_.put(Blocks.COMPARATOR, $$3);
        p_401711_.put(Blocks.ACTIVATOR_RAIL, $$3);
        p_401711_.put(Blocks.IRON_TRAPDOOR, $$3);
        p_401711_.put(Blocks.SUNFLOWER, $$3);
        p_401711_.put(Blocks.LILAC, $$3);
        p_401711_.put(Blocks.ROSE_BUSH, $$3);
        p_401711_.put(Blocks.PEONY, $$3);
        p_401711_.put(Blocks.TALL_GRASS, $$3);
        p_401711_.put(Blocks.LARGE_FERN, $$3);
        p_401711_.put(Blocks.SPRUCE_DOOR, $$3);
        p_401711_.put(Blocks.BIRCH_DOOR, $$3);
        p_401711_.put(Blocks.JUNGLE_DOOR, $$3);
        p_401711_.put(Blocks.ACACIA_DOOR, $$3);
        p_401711_.put(Blocks.CHERRY_DOOR, $$3);
        p_401711_.put(Blocks.DARK_OAK_DOOR, $$3);
        p_401711_.put(Blocks.PALE_OAK_DOOR, $$3);
        p_401711_.put(Blocks.MANGROVE_DOOR, $$3);
        p_401711_.put(Blocks.BAMBOO_DOOR, $$3);
        p_401711_.put(Blocks.COPPER_DOOR, $$3);
        p_401711_.put(Blocks.EXPOSED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.WEATHERED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.OXIDIZED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.WAXED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.WAXED_EXPOSED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.WAXED_WEATHERED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.WAXED_OXIDIZED_COPPER_DOOR, $$3);
        p_401711_.put(Blocks.END_ROD, $$3);
        p_401711_.put(Blocks.CHORUS_PLANT, $$3);
        p_401711_.put(Blocks.CHORUS_FLOWER, $$3);
        p_401711_.put(Blocks.TORCHFLOWER, $$3);
        p_401711_.put(Blocks.TORCHFLOWER_CROP, $$3);
        p_401711_.put(Blocks.PITCHER_PLANT, $$3);
        p_401711_.put(Blocks.PITCHER_CROP, $$3);
        p_401711_.put(Blocks.BEETROOTS, $$3);
        p_401711_.put(Blocks.KELP, $$3);
        p_401711_.put(Blocks.KELP_PLANT, $$3);
        p_401711_.put(Blocks.TURTLE_EGG, $$3);
        p_401711_.put(Blocks.DEAD_TUBE_CORAL, $$3);
        p_401711_.put(Blocks.DEAD_BRAIN_CORAL, $$3);
        p_401711_.put(Blocks.DEAD_BUBBLE_CORAL, $$3);
        p_401711_.put(Blocks.DEAD_FIRE_CORAL, $$3);
        p_401711_.put(Blocks.DEAD_HORN_CORAL, $$3);
        p_401711_.put(Blocks.TUBE_CORAL, $$3);
        p_401711_.put(Blocks.BRAIN_CORAL, $$3);
        p_401711_.put(Blocks.BUBBLE_CORAL, $$3);
        p_401711_.put(Blocks.FIRE_CORAL, $$3);
        p_401711_.put(Blocks.HORN_CORAL, $$3);
        p_401711_.put(Blocks.DEAD_TUBE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_BRAIN_CORAL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_BUBBLE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_FIRE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_HORN_CORAL_FAN, $$3);
        p_401711_.put(Blocks.TUBE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.BRAIN_CORAL_FAN, $$3);
        p_401711_.put(Blocks.BUBBLE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.FIRE_CORAL_FAN, $$3);
        p_401711_.put(Blocks.HORN_CORAL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_TUBE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_BRAIN_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_BUBBLE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_FIRE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.DEAD_HORN_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.TUBE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.BRAIN_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.BUBBLE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.FIRE_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.HORN_CORAL_WALL_FAN, $$3);
        p_401711_.put(Blocks.SEA_PICKLE, $$3);
        p_401711_.put(Blocks.CONDUIT, $$3);
        p_401711_.put(Blocks.BAMBOO_SAPLING, $$3);
        p_401711_.put(Blocks.BAMBOO, $$3);
        p_401711_.put(Blocks.POTTED_BAMBOO, $$3);
        p_401711_.put(Blocks.SCAFFOLDING, $$3);
        p_401711_.put(Blocks.STONECUTTER, $$3);
        p_401711_.put(Blocks.LANTERN, $$3);
        p_401711_.put(Blocks.SOUL_LANTERN, $$3);
        p_401711_.put(Blocks.CAMPFIRE, $$3);
        p_401711_.put(Blocks.SOUL_CAMPFIRE, $$3);
        p_401711_.put(Blocks.SWEET_BERRY_BUSH, $$3);
        p_401711_.put(Blocks.WEEPING_VINES, $$3);
        p_401711_.put(Blocks.WEEPING_VINES_PLANT, $$3);
        p_401711_.put(Blocks.TWISTING_VINES, $$3);
        p_401711_.put(Blocks.TWISTING_VINES_PLANT, $$3);
        p_401711_.put(Blocks.NETHER_SPROUTS, $$3);
        p_401711_.put(Blocks.CRIMSON_FUNGUS, $$3);
        p_401711_.put(Blocks.WARPED_FUNGUS, $$3);
        p_401711_.put(Blocks.CRIMSON_ROOTS, $$3);
        p_401711_.put(Blocks.WARPED_ROOTS, $$3);
        p_401711_.put(Blocks.POTTED_CRIMSON_FUNGUS, $$3);
        p_401711_.put(Blocks.POTTED_WARPED_FUNGUS, $$3);
        p_401711_.put(Blocks.POTTED_CRIMSON_ROOTS, $$3);
        p_401711_.put(Blocks.POTTED_WARPED_ROOTS, $$3);
        p_401711_.put(Blocks.CRIMSON_DOOR, $$3);
        p_401711_.put(Blocks.WARPED_DOOR, $$3);
        p_401711_.put(Blocks.POINTED_DRIPSTONE, $$3);
        p_401711_.put(Blocks.SMALL_AMETHYST_BUD, $$3);
        p_401711_.put(Blocks.MEDIUM_AMETHYST_BUD, $$3);
        p_401711_.put(Blocks.LARGE_AMETHYST_BUD, $$3);
        p_401711_.put(Blocks.AMETHYST_CLUSTER, $$3);
        p_401711_.put(Blocks.LIGHTNING_ROD, $$3);
        p_401711_.put(Blocks.CAVE_VINES, $$3);
        p_401711_.put(Blocks.CAVE_VINES_PLANT, $$3);
        p_401711_.put(Blocks.SPORE_BLOSSOM, $$3);
        p_401711_.put(Blocks.FLOWERING_AZALEA, $$3);
        p_401711_.put(Blocks.AZALEA, $$3);
        p_401711_.put(Blocks.PINK_PETALS, $$3);
        p_401711_.put(Blocks.WILDFLOWERS, $$3);
        p_401711_.put(Blocks.LEAF_LITTER, $$3);
        p_401711_.put(Blocks.BIG_DRIPLEAF, $$3);
        p_401711_.put(Blocks.BIG_DRIPLEAF_STEM, $$3);
        p_401711_.put(Blocks.SMALL_DRIPLEAF, $$3);
        p_401711_.put(Blocks.HANGING_ROOTS, $$3);
        p_401711_.put(Blocks.SCULK_SENSOR, $$3);
        p_401711_.put(Blocks.CALIBRATED_SCULK_SENSOR, $$3);
        p_401711_.put(Blocks.SCULK_VEIN, $$3);
        p_401711_.put(Blocks.SCULK_SHRIEKER, $$3);
        p_401711_.put(Blocks.MANGROVE_PROPAGULE, $$3);
        p_401711_.put(Blocks.FROGSPAWN, $$3);
        p_401711_.put(Blocks.COPPER_GRATE, $$3);
        p_401711_.put(Blocks.EXPOSED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.WEATHERED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.OXIDIZED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.WAXED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.WAXED_EXPOSED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.WAXED_WEATHERED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.WAXED_OXIDIZED_COPPER_GRATE, $$3);
        p_401711_.put(Blocks.FIREFLY_BUSH, $$3);
        p_401711_.put(Blocks.CACTUS_FLOWER, $$3);
        ChunkSectionLayer $$4 = ChunkSectionLayer.TRANSLUCENT;
        p_401711_.put(Blocks.ICE, $$4);
        p_401711_.put(Blocks.NETHER_PORTAL, $$4);
        p_401711_.put(Blocks.WHITE_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.ORANGE_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.MAGENTA_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.LIGHT_BLUE_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.YELLOW_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.LIME_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.PINK_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.GRAY_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.LIGHT_GRAY_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.CYAN_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.PURPLE_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.BLUE_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.BROWN_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.GREEN_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.RED_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.BLACK_STAINED_GLASS, $$4);
        p_401711_.put(Blocks.WHITE_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.ORANGE_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.MAGENTA_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.YELLOW_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.LIME_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.PINK_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.GRAY_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.CYAN_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.PURPLE_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.BLUE_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.BROWN_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.GREEN_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.RED_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.BLACK_STAINED_GLASS_PANE, $$4);
        p_401711_.put(Blocks.SLIME_BLOCK, $$4);
        p_401711_.put(Blocks.HONEY_BLOCK, $$4);
        p_401711_.put(Blocks.FROSTED_ICE, $$4);
        p_401711_.put(Blocks.BUBBLE_COLUMN, $$4);
        p_401711_.put(Blocks.TINTED_GLASS, $$4);
    });
    private static final Map<Fluid, ChunkSectionLayer> LAYER_BY_FLUID = Util.make(Maps.newHashMap(), p_426907_ -> {
        p_426907_.put(Fluids.FLOWING_WATER, ChunkSectionLayer.TRANSLUCENT);
        p_426907_.put(Fluids.WATER, ChunkSectionLayer.TRANSLUCENT);
    });
    private static boolean renderCutout;

    public static ChunkSectionLayer getChunkRenderType(BlockState p_109283_) {
        Block $$1 = p_109283_.getBlock();
        if ($$1 instanceof LeavesBlock) {
            return renderCutout ? ChunkSectionLayer.CUTOUT_MIPPED : ChunkSectionLayer.SOLID;
        }
        ChunkSectionLayer $$2 = TYPE_BY_BLOCK.get($$1);
        if ($$2 != null) {
            return $$2;
        }
        return ChunkSectionLayer.SOLID;
    }

    public static RenderType getMovingBlockRenderType(BlockState p_109294_) {
        Block $$1 = p_109294_.getBlock();
        if ($$1 instanceof LeavesBlock) {
            return renderCutout ? RenderType.cutoutMipped() : RenderType.solid();
        }
        ChunkSectionLayer $$2 = TYPE_BY_BLOCK.get($$1);
        if ($$2 != null) {
            return switch ($$2) {
                default -> throw new MatchException(null, null);
                case ChunkSectionLayer.SOLID -> RenderType.solid();
                case ChunkSectionLayer.CUTOUT_MIPPED -> RenderType.cutoutMipped();
                case ChunkSectionLayer.CUTOUT -> RenderType.cutout();
                case ChunkSectionLayer.TRANSLUCENT -> RenderType.translucentMovingBlock();
                case ChunkSectionLayer.TRIPWIRE -> RenderType.tripwire();
            };
        }
        return RenderType.solid();
    }

    public static RenderType getRenderType(BlockState p_366653_) {
        ChunkSectionLayer $$1 = ItemBlockRenderTypes.getChunkRenderType(p_366653_);
        if ($$1 == ChunkSectionLayer.TRANSLUCENT) {
            return Sheets.translucentItemSheet();
        }
        return Sheets.cutoutBlockSheet();
    }

    public static RenderType getRenderType(ItemStack p_366701_) {
        Item $$1 = p_366701_.getItem();
        if ($$1 instanceof BlockItem) {
            BlockItem $$2 = (BlockItem)$$1;
            Block $$3 = $$2.getBlock();
            return ItemBlockRenderTypes.getRenderType($$3.defaultBlockState());
        }
        return Sheets.translucentItemSheet();
    }

    public static ChunkSectionLayer getRenderLayer(FluidState p_109288_) {
        ChunkSectionLayer $$1 = LAYER_BY_FLUID.get(p_109288_.getType());
        if ($$1 != null) {
            return $$1;
        }
        return ChunkSectionLayer.SOLID;
    }

    public static void setFancy(boolean p_109292_) {
        renderCutout = p_109292_;
    }
}

