/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.Zone;
import org.slf4j.Logger;

public class GpuWarnlistManager
extends SimplePreparableReloadListener<Preparations> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation GPU_WARNLIST_LOCATION = ResourceLocation.withDefaultNamespace("gpu_warnlist.json");
    private ImmutableMap<String, String> warnings = ImmutableMap.of();
    private boolean showWarning;
    private boolean warningDismissed;
    private boolean skipFabulous;

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public boolean willShowWarning() {
        return this.hasWarnings() && !this.warningDismissed;
    }

    public void showWarning() {
        this.showWarning = true;
    }

    public void dismissWarning() {
        this.warningDismissed = true;
    }

    public void dismissWarningAndSkipFabulous() {
        this.warningDismissed = true;
        this.skipFabulous = true;
    }

    public boolean isShowingWarning() {
        return this.showWarning && !this.warningDismissed;
    }

    public boolean isSkippingFabulous() {
        return this.skipFabulous;
    }

    public void resetWarnings() {
        this.showWarning = false;
        this.warningDismissed = false;
        this.skipFabulous = false;
    }

    @Nullable
    public String getRendererWarnings() {
        return (String)this.warnings.get((Object)"renderer");
    }

    @Nullable
    public String getVersionWarnings() {
        return (String)this.warnings.get((Object)"version");
    }

    @Nullable
    public String getVendorWarnings() {
        return (String)this.warnings.get((Object)"vendor");
    }

    @Nullable
    public String getAllWarnings() {
        StringBuilder $$0 = new StringBuilder();
        this.warnings.forEach((p_109235_, p_109236_) -> $$0.append((String)p_109235_).append(": ").append((String)p_109236_));
        return $$0.length() == 0 ? null : $$0.toString();
    }

    @Override
    protected Preparations prepare(ResourceManager p_109220_, ProfilerFiller p_109221_) {
        ArrayList $$2 = Lists.newArrayList();
        ArrayList $$3 = Lists.newArrayList();
        ArrayList $$4 = Lists.newArrayList();
        JsonObject $$5 = GpuWarnlistManager.parseJson(p_109220_, p_109221_);
        if ($$5 != null) {
            try (Zone $$6 = p_109221_.zone("compile_regex");){
                GpuWarnlistManager.compilePatterns($$5.getAsJsonArray("renderer"), $$2);
                GpuWarnlistManager.compilePatterns($$5.getAsJsonArray("version"), $$3);
                GpuWarnlistManager.compilePatterns($$5.getAsJsonArray("vendor"), $$4);
            }
        }
        return new Preparations($$2, $$3, $$4);
    }

    @Override
    protected void apply(Preparations p_109226_, ResourceManager p_109227_, ProfilerFiller p_109228_) {
        this.warnings = p_109226_.apply();
    }

    private static void compilePatterns(JsonArray p_109223_, List<Pattern> p_109224_) {
        p_109223_.forEach(p_109239_ -> p_109224_.add(Pattern.compile(p_109239_.getAsString(), 2)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static JsonObject parseJson(ResourceManager p_109245_, ProfilerFiller p_109246_) {
        try (Zone $$2 = p_109246_.zone("parse_json");){
            JsonObject jsonObject;
            block14: {
                BufferedReader $$3 = p_109245_.openAsReader(GPU_WARNLIST_LOCATION);
                try {
                    jsonObject = StrictJsonParser.parse($$3).getAsJsonObject();
                    if ($$3 == null) break block14;
                }
                catch (Throwable throwable) {
                    if ($$3 != null) {
                        try {
                            ((Reader)$$3).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((Reader)$$3).close();
            }
            return jsonObject;
        }
        catch (JsonSyntaxException | IOException $$4) {
            LOGGER.warn("Failed to load GPU warnlist", $$4);
            return null;
        }
    }

    @Override
    protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.prepare(resourceManager, profilerFiller);
    }

    protected static final class Preparations {
        private final List<Pattern> rendererPatterns;
        private final List<Pattern> versionPatterns;
        private final List<Pattern> vendorPatterns;

        Preparations(List<Pattern> p_109261_, List<Pattern> p_109262_, List<Pattern> p_109263_) {
            this.rendererPatterns = p_109261_;
            this.versionPatterns = p_109262_;
            this.vendorPatterns = p_109263_;
        }

        private static String matchAny(List<Pattern> p_109273_, String p_109274_) {
            ArrayList $$2 = Lists.newArrayList();
            for (Pattern $$3 : p_109273_) {
                Matcher $$4 = $$3.matcher(p_109274_);
                while ($$4.find()) {
                    $$2.add($$4.group());
                }
            }
            return String.join((CharSequence)", ", $$2);
        }

        ImmutableMap<String, String> apply() {
            ImmutableMap.Builder $$0 = new ImmutableMap.Builder();
            GpuDevice $$1 = RenderSystem.getDevice();
            if ($$1.getBackendName().equals("OpenGL")) {
                String $$4;
                String $$3;
                String $$2 = Preparations.matchAny(this.rendererPatterns, $$1.getRenderer());
                if (!$$2.isEmpty()) {
                    $$0.put((Object)"renderer", (Object)$$2);
                }
                if (!($$3 = Preparations.matchAny(this.versionPatterns, $$1.getVersion())).isEmpty()) {
                    $$0.put((Object)"version", (Object)$$3);
                }
                if (!($$4 = Preparations.matchAny(this.vendorPatterns, $$1.getVendor())).isEmpty()) {
                    $$0.put((Object)"vendor", (Object)$$4);
                }
            }
            return $$0.build();
        }
    }
}

