/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.IdSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;

public class SessionSearchTrees {
    private static final Key RECIPE_COLLECTIONS = new Key();
    private static final Key CREATIVE_NAMES = new Key();
    private static final Key CREATIVE_TAGS = new Key();
    private CompletableFuture<SearchTree<ItemStack>> creativeByNameSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private CompletableFuture<SearchTree<ItemStack>> creativeByTagSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private CompletableFuture<SearchTree<RecipeCollection>> recipeSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private final Map<Key, Runnable> reloaders = new IdentityHashMap<Key, Runnable>();

    private void register(Key p_345458_, Runnable p_346175_) {
        p_346175_.run();
        this.reloaders.put(p_345458_, p_346175_);
    }

    public void rebuildAfterLanguageChange() {
        for (Runnable $$0 : this.reloaders.values()) {
            $$0.run();
        }
    }

    private static Stream<String> getTooltipLines(Stream<ItemStack> p_344879_, Item.TooltipContext p_345662_, TooltipFlag p_345262_) {
        return p_344879_.flatMap(p_344980_ -> p_344980_.getTooltipLines(p_345662_, null, p_345262_).stream()).map(p_345615_ -> ChatFormatting.stripFormatting(p_345615_.getString()).trim()).filter(p_346341_ -> !p_346341_.isEmpty());
    }

    public void updateRecipes(ClientRecipeBook p_346233_, Level p_379752_) {
        this.register(RECIPE_COLLECTIONS, () -> {
            List<RecipeCollection> $$2 = p_346233_.getCollections();
            RegistryAccess $$3 = p_379752_.registryAccess();
            HolderLookup.RegistryLookup $$4 = $$3.lookupOrThrow(Registries.ITEM);
            Item.TooltipContext $$5 = Item.TooltipContext.of($$3);
            ContextMap $$6 = SlotDisplayContext.fromLevel(p_379752_);
            TooltipFlag.Default $$7 = TooltipFlag.Default.NORMAL;
            CompletableFuture<SearchTree<RecipeCollection>> $$8 = this.recipeSearch;
            this.recipeSearch = CompletableFuture.supplyAsync(() -> SessionSearchTrees.lambda$updateRecipes$8($$6, $$5, $$7, (Registry)$$4, $$2), Util.backgroundExecutor());
            $$8.cancel(true);
        });
    }

    public SearchTree<RecipeCollection> recipes() {
        return this.recipeSearch.join();
    }

    public void updateCreativeTags(List<ItemStack> p_346121_) {
        this.register(CREATIVE_TAGS, () -> {
            CompletableFuture<SearchTree<ItemStack>> $$1 = this.creativeByTagSearch;
            this.creativeByTagSearch = CompletableFuture.supplyAsync(() -> new IdSearchTree<ItemStack>(p_344728_ -> p_344728_.getTags().map(TagKey::location), p_346121_), Util.backgroundExecutor());
            $$1.cancel(true);
        });
    }

    public SearchTree<ItemStack> creativeTagSearch() {
        return this.creativeByTagSearch.join();
    }

    public void updateCreativeTooltips(HolderLookup.Provider p_345391_, List<ItemStack> p_346357_) {
        this.register(CREATIVE_NAMES, () -> {
            Item.TooltipContext $$2 = Item.TooltipContext.of(p_345391_);
            TooltipFlag.Default $$3 = TooltipFlag.Default.NORMAL.asCreative();
            CompletableFuture<SearchTree<ItemStack>> $$4 = this.creativeByNameSearch;
            this.creativeByNameSearch = CompletableFuture.supplyAsync(() -> new FullTextSearchTree<ItemStack>(p_345006_ -> SessionSearchTrees.getTooltipLines(Stream.of(p_345006_), $$2, $$3), p_345861_ -> p_345861_.getItemHolder().unwrapKey().map(ResourceKey::location).stream(), p_346357_), Util.backgroundExecutor());
            $$4.cancel(true);
        });
    }

    public SearchTree<ItemStack> creativeNameSearch() {
        return this.creativeByNameSearch.join();
    }

    private static /* synthetic */ SearchTree lambda$updateRecipes$8(ContextMap p_381138_, Item.TooltipContext p_345767_, TooltipFlag p_344881_, Registry p_344896_, List p_345251_) {
        return new FullTextSearchTree<RecipeCollection>(p_378821_ -> SessionSearchTrees.getTooltipLines(p_378821_.getRecipes().stream().flatMap(p_380802_ -> p_380802_.resultItems(p_381138_).stream()), p_345767_, p_344881_), p_378813_ -> p_378813_.getRecipes().stream().flatMap(p_380804_ -> p_380804_.resultItems(p_381138_).stream()).map(p_378810_ -> p_344896_.getKey(p_378810_.getItem())), p_345251_);
    }

    static class Key {
        Key() {
        }
    }
}

