/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;

public class LevelLoadStatusManager {
    private final LocalPlayer player;
    private final ClientLevel level;
    private final LevelRenderer levelRenderer;
    private Status status = Status.WAITING_FOR_SERVER;

    public LevelLoadStatusManager(LocalPlayer p_304970_, ClientLevel p_304700_, LevelRenderer p_304864_) {
        this.player = p_304970_;
        this.level = p_304700_;
        this.levelRenderer = p_304864_;
    }

    public void tick() {
        switch (this.status.ordinal()) {
            case 0: 
            case 2: {
                break;
            }
            case 1: {
                BlockPos $$0 = this.player.blockPosition();
                boolean $$1 = this.level.isOutsideBuildHeight($$0.getY());
                if (!$$1 && !this.levelRenderer.isSectionCompiled($$0) && !this.player.isSpectator() && this.player.isAlive()) break;
                this.status = Status.LEVEL_READY;
            }
        }
    }

    public boolean levelReady() {
        return this.status == Status.LEVEL_READY;
    }

    public void loadingPacketsReceived() {
        if (this.status == Status.WAITING_FOR_SERVER) {
            this.status = Status.WAITING_FOR_PLAYER_CHUNK;
        }
    }

    static enum Status {
        WAITING_FOR_SERVER,
        WAITING_FOR_PLAYER_CHUNK,
        LEVEL_READY;

    }
}

