/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.definitions.WardenAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.WardenRenderState;
import net.minecraft.util.Mth;

public class WardenModel
extends EntityModel<WardenRenderState> {
    private static final float DEFAULT_ARM_X_Y = 13.0f;
    private static final float DEFAULT_ARM_Z = 1.0f;
    protected final ModelPart bone;
    protected final ModelPart body;
    protected final ModelPart head;
    protected final ModelPart rightTendril;
    protected final ModelPart leftTendril;
    protected final ModelPart leftLeg;
    protected final ModelPart leftArm;
    protected final ModelPart leftRibcage;
    protected final ModelPart rightArm;
    protected final ModelPart rightLeg;
    protected final ModelPart rightRibcage;
    private final List<ModelPart> tendrilsLayerModelParts;
    private final List<ModelPart> heartLayerModelParts;
    private final List<ModelPart> bioluminescentLayerModelParts;
    private final List<ModelPart> pulsatingSpotsLayerModelParts;
    private final KeyframeAnimation attackAnimation;
    private final KeyframeAnimation sonicBoomAnimation;
    private final KeyframeAnimation diggingAnimation;
    private final KeyframeAnimation emergeAnimation;
    private final KeyframeAnimation roarAnimation;
    private final KeyframeAnimation sniffAnimation;

    public WardenModel(ModelPart p_233512_) {
        super(p_233512_, RenderType::entityCutoutNoCull);
        this.bone = p_233512_.getChild("bone");
        this.body = this.bone.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.bone.getChild("right_leg");
        this.leftLeg = this.bone.getChild("left_leg");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightTendril = this.head.getChild("right_tendril");
        this.leftTendril = this.head.getChild("left_tendril");
        this.rightRibcage = this.body.getChild("right_ribcage");
        this.leftRibcage = this.body.getChild("left_ribcage");
        this.tendrilsLayerModelParts = ImmutableList.of((Object)this.leftTendril, (Object)this.rightTendril);
        this.heartLayerModelParts = ImmutableList.of((Object)this.body);
        this.bioluminescentLayerModelParts = ImmutableList.of((Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.pulsatingSpotsLayerModelParts = ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg);
        this.attackAnimation = WardenAnimation.WARDEN_ATTACK.bake(p_233512_);
        this.sonicBoomAnimation = WardenAnimation.WARDEN_SONIC_BOOM.bake(p_233512_);
        this.diggingAnimation = WardenAnimation.WARDEN_DIG.bake(p_233512_);
        this.emergeAnimation = WardenAnimation.WARDEN_EMERGE.bake(p_233512_);
        this.roarAnimation = WardenAnimation.WARDEN_ROAR.bake(p_233512_);
        this.sniffAnimation = WardenAnimation.WARDEN_SNIFF.bake(p_233512_);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset(0.0f, 24.0f, 0.0f));
        PartDefinition $$3 = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -13.0f, -4.0f, 18.0f, 21.0f, 11.0f), PartPose.offset(0.0f, -21.0f, 0.0f));
        $$3.addOrReplaceChild("right_ribcage", CubeListBuilder.create().texOffs(90, 11).addBox(-2.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f), PartPose.offset(-7.0f, -2.0f, -4.0f));
        $$3.addOrReplaceChild("left_ribcage", CubeListBuilder.create().texOffs(90, 11).mirror().addBox(-7.0f, -11.0f, -0.1f, 9.0f, 21.0f, 0.0f).mirror(false), PartPose.offset(7.0f, -2.0f, -4.0f));
        PartDefinition $$4 = $$3.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 32).addBox(-8.0f, -16.0f, -5.0f, 16.0f, 16.0f, 10.0f), PartPose.offset(0.0f, -13.0f, 0.0f));
        $$4.addOrReplaceChild("right_tendril", CubeListBuilder.create().texOffs(52, 32).addBox(-16.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset(-8.0f, -12.0f, 0.0f));
        $$4.addOrReplaceChild("left_tendril", CubeListBuilder.create().texOffs(58, 0).addBox(0.0f, -13.0f, 0.0f, 16.0f, 16.0f, 0.0f), PartPose.offset(8.0f, -12.0f, 0.0f));
        $$3.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 50).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.offset(-13.0f, -13.0f, 1.0f));
        $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 58).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 28.0f, 8.0f), PartPose.offset(13.0f, -13.0f, 1.0f));
        $$2.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(76, 48).addBox(-3.1f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset(-5.9f, -13.0f, 0.0f));
        $$2.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(76, 76).addBox(-2.9f, 0.0f, -3.0f, 6.0f, 13.0f, 6.0f), PartPose.offset(5.9f, -13.0f, 0.0f));
        return LayerDefinition.create($$0, 128, 128);
    }

    @Override
    public void setupAnim(WardenRenderState p_362289_) {
        super.setupAnim(p_362289_);
        this.animateHeadLookTarget(p_362289_.yRot, p_362289_.xRot);
        this.animateWalk(p_362289_.walkAnimationPos, p_362289_.walkAnimationSpeed);
        this.animateIdlePose(p_362289_.ageInTicks);
        this.animateTendrils(p_362289_, p_362289_.ageInTicks);
        this.attackAnimation.apply(p_362289_.attackAnimationState, p_362289_.ageInTicks);
        this.sonicBoomAnimation.apply(p_362289_.sonicBoomAnimationState, p_362289_.ageInTicks);
        this.diggingAnimation.apply(p_362289_.diggingAnimationState, p_362289_.ageInTicks);
        this.emergeAnimation.apply(p_362289_.emergeAnimationState, p_362289_.ageInTicks);
        this.roarAnimation.apply(p_362289_.roarAnimationState, p_362289_.ageInTicks);
        this.sniffAnimation.apply(p_362289_.sniffAnimationState, p_362289_.ageInTicks);
    }

    private void animateHeadLookTarget(float p_233517_, float p_233518_) {
        this.head.xRot = p_233518_ * ((float)Math.PI / 180);
        this.head.yRot = p_233517_ * ((float)Math.PI / 180);
    }

    private void animateIdlePose(float p_233515_) {
        float $$1 = p_233515_ * 0.1f;
        float $$2 = Mth.cos($$1);
        float $$3 = Mth.sin($$1);
        this.head.zRot += 0.06f * $$2;
        this.head.xRot += 0.06f * $$3;
        this.body.zRot += 0.025f * $$3;
        this.body.xRot += 0.025f * $$2;
    }

    private void animateWalk(float p_233539_, float p_233540_) {
        float $$2 = Math.min(0.5f, 3.0f * p_233540_);
        float $$3 = p_233539_ * 0.8662f;
        float $$4 = Mth.cos($$3);
        float $$5 = Mth.sin($$3);
        float $$6 = Math.min(0.35f, $$2);
        this.head.zRot += 0.3f * $$5 * $$2;
        this.head.xRot += 1.2f * Mth.cos($$3 + 1.5707964f) * $$6;
        this.body.zRot = 0.1f * $$5 * $$2;
        this.body.xRot = 1.0f * $$4 * $$6;
        this.leftLeg.xRot = 1.0f * $$4 * $$2;
        this.rightLeg.xRot = 1.0f * Mth.cos($$3 + (float)Math.PI) * $$2;
        this.leftArm.xRot = -(0.8f * $$4 * $$2);
        this.leftArm.zRot = 0.0f;
        this.rightArm.xRot = -(0.8f * $$5 * $$2);
        this.rightArm.zRot = 0.0f;
        this.resetArmPoses();
    }

    private void resetArmPoses() {
        this.leftArm.yRot = 0.0f;
        this.leftArm.z = 1.0f;
        this.leftArm.x = 13.0f;
        this.leftArm.y = -13.0f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.z = 1.0f;
        this.rightArm.x = -13.0f;
        this.rightArm.y = -13.0f;
    }

    private void animateTendrils(WardenRenderState p_360923_, float p_233528_) {
        float $$2;
        this.leftTendril.xRot = $$2 = p_360923_.tendrilAnimation * (float)(Math.cos((double)p_233528_ * 2.25) * Math.PI * (double)0.1f);
        this.rightTendril.xRot = -$$2;
    }

    public List<ModelPart> getTendrilsLayerModelParts(WardenRenderState p_379565_) {
        return this.tendrilsLayerModelParts;
    }

    public List<ModelPart> getHeartLayerModelParts(WardenRenderState p_380335_) {
        return this.heartLayerModelParts;
    }

    public List<ModelPart> getBioluminescentLayerModelParts(WardenRenderState p_379448_) {
        return this.bioluminescentLayerModelParts;
    }

    public List<ModelPart> getPulsatingSpotsLayerModelParts(WardenRenderState p_380118_) {
        return this.pulsatingSpotsLayerModelParts;
    }
}

