/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public abstract class Model {
    protected final ModelPart root;
    protected final Function<ResourceLocation, RenderType> renderType;
    private final List<ModelPart> allParts;

    public Model(ModelPart p_368583_, Function<ResourceLocation, RenderType> p_103110_) {
        this.root = p_368583_;
        this.renderType = p_103110_;
        this.allParts = p_368583_.getAllParts();
    }

    public final RenderType renderType(ResourceLocation p_103120_) {
        return this.renderType.apply(p_103120_);
    }

    public final void renderToBuffer(PoseStack p_103111_, VertexConsumer p_103112_, int p_103113_, int p_103114_, int p_350308_) {
        this.root().render(p_103111_, p_103112_, p_103113_, p_103114_, p_350308_);
    }

    public final void renderToBuffer(PoseStack p_350804_, VertexConsumer p_350976_, int p_350539_, int p_350374_) {
        this.renderToBuffer(p_350804_, p_350976_, p_350539_, p_350374_, -1);
    }

    public final ModelPart root() {
        return this.root;
    }

    public final List<ModelPart> allParts() {
        return this.allParts;
    }

    public final void resetPose() {
        for (ModelPart $$0 : this.allParts) {
            $$0.resetPose();
        }
    }

    public static class Simple
    extends Model {
        public Simple(ModelPart p_364140_, Function<ResourceLocation, RenderType> p_364753_) {
            super(p_364140_, p_364753_);
        }
    }
}

