/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EndermanRenderState;
import net.minecraft.util.Mth;

public class EndermanModel<T extends EndermanRenderState>
extends HumanoidModel<T> {
    public EndermanModel(ModelPart p_170541_) {
        super(p_170541_);
    }

    public static LayerDefinition createBodyLayer() {
        float $$0 = -14.0f;
        MeshDefinition $$1 = HumanoidModel.createMesh(CubeDeformation.NONE, -14.0f);
        PartDefinition $$2 = $$1.getRoot();
        PartDefinition $$3 = $$2.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset(0.0f, -13.0f, 0.0f));
        $$3.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.ZERO);
        $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.offset(0.0f, -14.0f, 0.0f));
        $$2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset(-5.0f, -12.0f, 0.0f));
        $$2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset(5.0f, -12.0f, 0.0f));
        $$2.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset(-2.0f, -5.0f, 0.0f));
        $$2.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 30.0f, 2.0f), PartPose.offset(2.0f, -5.0f, 0.0f));
        return LayerDefinition.create($$1, 64, 32);
    }

    @Override
    public void setupAnim(T p_361036_) {
        super.setupAnim(p_361036_);
        this.head.visible = true;
        this.rightArm.xRot *= 0.5f;
        this.leftArm.xRot *= 0.5f;
        this.rightLeg.xRot *= 0.5f;
        this.leftLeg.xRot *= 0.5f;
        float $$1 = 0.4f;
        this.rightArm.xRot = Mth.clamp(this.rightArm.xRot, -0.4f, 0.4f);
        this.leftArm.xRot = Mth.clamp(this.leftArm.xRot, -0.4f, 0.4f);
        this.rightLeg.xRot = Mth.clamp(this.rightLeg.xRot, -0.4f, 0.4f);
        this.leftLeg.xRot = Mth.clamp(this.leftLeg.xRot, -0.4f, 0.4f);
        if (((EndermanRenderState)p_361036_).carriedBlock != null) {
            this.rightArm.xRot = -0.5f;
            this.leftArm.xRot = -0.5f;
            this.rightArm.zRot = 0.05f;
            this.leftArm.zRot = -0.05f;
        }
        if (((EndermanRenderState)p_361036_).isCreepy) {
            float $$2 = 5.0f;
            this.head.y -= 5.0f;
            this.hat.y += 5.0f;
        }
    }
}

