/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.util.Mth;

public class ChickenModel
extends EntityModel<ChickenRenderState> {
    public static final String RED_THING = "red_thing";
    public static final float Y_OFFSET = 16.0f;
    public static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(false, 5.0f, 2.0f, 2.0f, 1.99f, 24.0f, Set.of("head", "beak", "red_thing"));
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public ChickenModel(ModelPart p_170490_) {
        super(p_170490_);
        this.head = p_170490_.getChild("head");
        this.rightLeg = p_170490_.getChild("right_leg");
        this.leftLeg = p_170490_.getChild("left_leg");
        this.rightWing = p_170490_.getChild("right_wing");
        this.leftWing = p_170490_.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = ChickenModel.createBaseChickenModel();
        return LayerDefinition.create($$0, 64, 32);
    }

    protected static MeshDefinition createBaseChickenModel() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -2.0f, 4.0f, 6.0f, 3.0f), PartPose.offset(0.0f, 15.0f, -4.0f));
        $$2.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(14, 0).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f), PartPose.ZERO);
        $$2.addOrReplaceChild(RED_THING, CubeListBuilder.create().texOffs(14, 4).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 2.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 9).addBox(-3.0f, -4.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.offsetAndRotation(0.0f, 16.0f, 0.0f, 1.5707964f, 0.0f, 0.0f));
        CubeListBuilder $$3 = CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f);
        $$1.addOrReplaceChild("right_leg", $$3, PartPose.offset(-2.0f, 19.0f, 1.0f));
        $$1.addOrReplaceChild("left_leg", $$3, PartPose.offset(1.0f, 19.0f, 1.0f));
        $$1.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(24, 13).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset(-4.0f, 13.0f, 0.0f));
        $$1.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(24, 13).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f), PartPose.offset(4.0f, 13.0f, 0.0f));
        return $$0;
    }

    @Override
    public void setupAnim(ChickenRenderState p_364616_) {
        super.setupAnim(p_364616_);
        float $$1 = (Mth.sin(p_364616_.flap) + 1.0f) * p_364616_.flapSpeed;
        this.head.xRot = p_364616_.xRot * ((float)Math.PI / 180);
        this.head.yRot = p_364616_.yRot * ((float)Math.PI / 180);
        float $$2 = p_364616_.walkAnimationSpeed;
        float $$3 = p_364616_.walkAnimationPos;
        this.rightLeg.xRot = Mth.cos($$3 * 0.6662f) * 1.4f * $$2;
        this.leftLeg.xRot = Mth.cos($$3 * 0.6662f + (float)Math.PI) * 1.4f * $$2;
        this.rightWing.zRot = $$1;
        this.leftWing.zRot = -$$1;
    }
}

