/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Arrays;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class BlazeModel
extends EntityModel<LivingEntityRenderState> {
    private final ModelPart[] upperBodyParts;
    private final ModelPart head;

    public BlazeModel(ModelPart p_170443_) {
        super(p_170443_);
        this.head = p_170443_.getChild("head");
        this.upperBodyParts = new ModelPart[12];
        Arrays.setAll(this.upperBodyParts, p_170449_ -> p_170443_.getChild(BlazeModel.getPartName(p_170449_)));
    }

    private static String getPartName(int p_170446_) {
        return "part" + p_170446_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        float $$2 = 0.0f;
        CubeListBuilder $$3 = CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        for (int $$4 = 0; $$4 < 4; ++$$4) {
            float $$5 = Mth.cos($$2) * 9.0f;
            float $$6 = -2.0f + Mth.cos((float)($$4 * 2) * 0.25f);
            float $$7 = Mth.sin($$2) * 9.0f;
            $$1.addOrReplaceChild(BlazeModel.getPartName($$4), $$3, PartPose.offset($$5, $$6, $$7));
            $$2 += 1.5707964f;
        }
        $$2 = 0.7853982f;
        for (int $$8 = 4; $$8 < 8; ++$$8) {
            float $$9 = Mth.cos($$2) * 7.0f;
            float $$10 = 2.0f + Mth.cos((float)($$8 * 2) * 0.25f);
            float $$11 = Mth.sin($$2) * 7.0f;
            $$1.addOrReplaceChild(BlazeModel.getPartName($$8), $$3, PartPose.offset($$9, $$10, $$11));
            $$2 += 1.5707964f;
        }
        $$2 = 0.47123894f;
        for (int $$12 = 8; $$12 < 12; ++$$12) {
            float $$13 = Mth.cos($$2) * 5.0f;
            float $$14 = 11.0f + Mth.cos((float)$$12 * 1.5f * 0.5f);
            float $$15 = Mth.sin($$2) * 5.0f;
            $$1.addOrReplaceChild(BlazeModel.getPartName($$12), $$3, PartPose.offset($$13, $$14, $$15));
            $$2 += 1.5707964f;
        }
        return LayerDefinition.create($$0, 64, 32);
    }

    @Override
    public void setupAnim(LivingEntityRenderState p_360395_) {
        super.setupAnim(p_360395_);
        float $$1 = p_360395_.ageInTicks * (float)Math.PI * -0.1f;
        for (int $$2 = 0; $$2 < 4; ++$$2) {
            this.upperBodyParts[$$2].y = -2.0f + Mth.cos(((float)($$2 * 2) + p_360395_.ageInTicks) * 0.25f);
            this.upperBodyParts[$$2].x = Mth.cos($$1) * 9.0f;
            this.upperBodyParts[$$2].z = Mth.sin($$1) * 9.0f;
            $$1 += 1.5707964f;
        }
        $$1 = 0.7853982f + p_360395_.ageInTicks * (float)Math.PI * 0.03f;
        for (int $$3 = 4; $$3 < 8; ++$$3) {
            this.upperBodyParts[$$3].y = 2.0f + Mth.cos(((float)($$3 * 2) + p_360395_.ageInTicks) * 0.25f);
            this.upperBodyParts[$$3].x = Mth.cos($$1) * 7.0f;
            this.upperBodyParts[$$3].z = Mth.sin($$1) * 7.0f;
            $$1 += 1.5707964f;
        }
        $$1 = 0.47123894f + p_360395_.ageInTicks * (float)Math.PI * -0.05f;
        for (int $$4 = 8; $$4 < 12; ++$$4) {
            this.upperBodyParts[$$4].y = 11.0f + Mth.cos(((float)$$4 * 1.5f + p_360395_.ageInTicks) * 0.5f);
            this.upperBodyParts[$$4].x = Mth.cos($$1) * 5.0f;
            this.upperBodyParts[$$4].z = Mth.sin($$1) * 5.0f;
            $$1 += 1.5707964f;
        }
        this.head.yRot = p_360395_.yRot * ((float)Math.PI / 180);
        this.head.xRot = p_360395_.xRot * ((float)Math.PI / 180);
    }
}

