/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.animation.definitions.ArmadilloAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.ArmadilloRenderState;
import net.minecraft.util.Mth;

public class ArmadilloModel
extends EntityModel<ArmadilloRenderState> {
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling(0.6f);
    private static final float MAX_DOWN_HEAD_ROTATION_EXTENT = 25.0f;
    private static final float MAX_UP_HEAD_ROTATION_EXTENT = 22.5f;
    private static final float MAX_WALK_ANIMATION_SPEED = 16.5f;
    private static final float WALK_ANIMATION_SCALE_FACTOR = 2.5f;
    private static final String HEAD_CUBE = "head_cube";
    private static final String RIGHT_EAR_CUBE = "right_ear_cube";
    private static final String LEFT_EAR_CUBE = "left_ear_cube";
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart cube;
    private final ModelPart head;
    private final ModelPart tail;
    private final KeyframeAnimation walkAnimation;
    private final KeyframeAnimation rollOutAnimation;
    private final KeyframeAnimation rollUpAnimation;
    private final KeyframeAnimation peekAnimation;

    public ArmadilloModel(ModelPart p_316704_) {
        super(p_316704_);
        this.body = p_316704_.getChild("body");
        this.rightHindLeg = p_316704_.getChild("right_hind_leg");
        this.leftHindLeg = p_316704_.getChild("left_hind_leg");
        this.head = this.body.getChild("head");
        this.tail = this.body.getChild("tail");
        this.cube = p_316704_.getChild("cube");
        this.walkAnimation = ArmadilloAnimation.ARMADILLO_WALK.bake(p_316704_);
        this.rollOutAnimation = ArmadilloAnimation.ARMADILLO_ROLL_OUT.bake(p_316704_);
        this.rollUpAnimation = ArmadilloAnimation.ARMADILLO_ROLL_UP.bake(p_316704_);
        this.peekAnimation = ArmadilloAnimation.ARMADILLO_PEEK.bake(p_316704_);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        PartDefinition $$2 = $$1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.3f)).texOffs(0, 40).addBox(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 21.0f, 4.0f));
        $$2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(44, 53).addBox(-0.5f, -0.0865f, 0.0933f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, -3.0f, 1.0f, 0.5061f, 0.0f, 0.0f));
        PartDefinition $$3 = $$2.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset(0.0f, -2.0f, -11.0f));
        $$3.addOrReplaceChild(HEAD_CUBE, CubeListBuilder.create().texOffs(43, 15).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.0f, 0.0f, 0.0f, -0.3927f, 0.0f, 0.0f));
        PartDefinition $$4 = $$3.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offset(-1.0f, -1.0f, 0.0f));
        $$4.addOrReplaceChild(RIGHT_EAR_CUBE, CubeListBuilder.create().texOffs(43, 10).addBox(-2.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(-0.5f, 0.0f, -0.6f, 0.1886f, -0.3864f, -0.0718f));
        PartDefinition $$5 = $$3.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offset(1.0f, -2.0f, 0.0f));
        $$5.addOrReplaceChild(LEFT_EAR_CUBE, CubeListBuilder.create().texOffs(47, 10).addBox(0.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation(0.5f, 1.0f, -0.6f, 0.1886f, 0.3864f, 0.0718f));
        $$1.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(51, 31).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(-2.0f, 21.0f, 4.0f));
        $$1.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(42, 31).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(2.0f, 21.0f, 4.0f));
        $$1.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(51, 43).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(-2.0f, 21.0f, -4.0f));
        $$1.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(42, 43).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset(2.0f, 21.0f, -4.0f));
        $$1.addOrReplaceChild("cube", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -6.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset(0.0f, 24.0f, 0.0f));
        return LayerDefinition.create($$0, 64, 64);
    }

    @Override
    public void setupAnim(ArmadilloRenderState p_360704_) {
        super.setupAnim(p_360704_);
        if (p_360704_.isHidingInShell) {
            this.body.skipDraw = true;
            this.leftHindLeg.visible = false;
            this.rightHindLeg.visible = false;
            this.tail.visible = false;
            this.cube.visible = true;
        } else {
            this.body.skipDraw = false;
            this.leftHindLeg.visible = true;
            this.rightHindLeg.visible = true;
            this.tail.visible = true;
            this.cube.visible = false;
            this.head.xRot = Mth.clamp(p_360704_.xRot, -22.5f, 25.0f) * ((float)Math.PI / 180);
            this.head.yRot = Mth.clamp(p_360704_.yRot, -32.5f, 32.5f) * ((float)Math.PI / 180);
        }
        this.walkAnimation.applyWalk(p_360704_.walkAnimationPos, p_360704_.walkAnimationSpeed, 16.5f, 2.5f);
        this.rollOutAnimation.apply(p_360704_.rollOutAnimationState, p_360704_.ageInTicks);
        this.rollUpAnimation.apply(p_360704_.rollUpAnimationState, p_360704_.ageInTicks);
        this.peekAnimation.apply(p_360704_.peekAnimationState, p_360704_.ageInTicks);
    }
}

