/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Set;
import net.minecraft.client.model.BabyModelTransform;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.util.Mth;

public abstract class AbstractEquineModel<T extends EquineRenderState>
extends EntityModel<T> {
    private static final float DEG_125 = 2.1816616f;
    private static final float DEG_60 = 1.0471976f;
    private static final float DEG_45 = 0.7853982f;
    private static final float DEG_30 = 0.5235988f;
    private static final float DEG_15 = 0.2617994f;
    protected static final String HEAD_PARTS = "head_parts";
    protected static final MeshTransformer BABY_TRANSFORMER = new BabyModelTransform(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f, Set.of("head_parts"));
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;

    public AbstractEquineModel(ModelPart p_362475_) {
        super(p_362475_);
        this.body = p_362475_.getChild("body");
        this.headParts = p_362475_.getChild(HEAD_PARTS);
        this.rightHindLeg = p_362475_.getChild("right_hind_leg");
        this.leftHindLeg = p_362475_.getChild("left_hind_leg");
        this.rightFrontLeg = p_362475_.getChild("right_front_leg");
        this.leftFrontLeg = p_362475_.getChild("left_front_leg");
        this.tail = this.body.getChild("tail");
    }

    public static MeshDefinition createBodyMesh(CubeDeformation p_362889_) {
        MeshDefinition $$1 = new MeshDefinition();
        PartDefinition $$2 = $$1.getRoot();
        PartDefinition $$3 = $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 32).addBox(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.offset(0.0f, 11.0f, 5.0f));
        PartDefinition $$4 = $$2.addOrReplaceChild(HEAD_PARTS, CubeListBuilder.create().texOffs(0, 35).addBox(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.offsetAndRotation(0.0f, 4.0f, -12.0f, 0.5235988f, 0.0f, 0.0f));
        PartDefinition $$5 = $$4.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 13).addBox(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, p_362889_), PartPose.ZERO);
        $$4.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(56, 36).addBox(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, p_362889_), PartPose.ZERO);
        $$4.addOrReplaceChild("upper_mouth", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, p_362889_), PartPose.ZERO);
        $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(4.0f, 14.0f, 7.0f));
        $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(-4.0f, 14.0f, 7.0f));
        $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(4.0f, 14.0f, -10.0f));
        $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, p_362889_), PartPose.offset(-4.0f, 14.0f, -10.0f));
        $$3.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(42, 36).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, p_362889_), PartPose.offsetAndRotation(0.0f, -5.0f, 2.0f, 0.5235988f, 0.0f, 0.0f));
        $$5.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(19, 16).addBox(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        $$5.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(19, 16).addBox(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.ZERO);
        return $$1;
    }

    public static MeshDefinition createBabyMesh(CubeDeformation p_361910_) {
        return BABY_TRANSFORMER.apply(AbstractEquineModel.createFullScaleBabyMesh(p_361910_));
    }

    protected static MeshDefinition createFullScaleBabyMesh(CubeDeformation p_360459_) {
        MeshDefinition $$1 = AbstractEquineModel.createBodyMesh(p_360459_);
        PartDefinition $$2 = $$1.getRoot();
        CubeDeformation $$3 = p_360459_.extend(0.0f, 5.5f, 0.0f);
        $$2.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, $$3), PartPose.offset(4.0f, 14.0f, 7.0f));
        $$2.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, $$3), PartPose.offset(-4.0f, 14.0f, 7.0f));
        $$2.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(48, 21).mirror().addBox(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, $$3), PartPose.offset(4.0f, 14.0f, -10.0f));
        $$2.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(48, 21).addBox(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, $$3), PartPose.offset(-4.0f, 14.0f, -10.0f));
        return $$1;
    }

    @Override
    public void setupAnim(T p_363341_) {
        super.setupAnim(p_363341_);
        float $$1 = Mth.clamp(((EquineRenderState)p_363341_).yRot, -20.0f, 20.0f);
        float $$2 = ((EquineRenderState)p_363341_).xRot * ((float)Math.PI / 180);
        float $$3 = ((EquineRenderState)p_363341_).walkAnimationSpeed;
        float $$4 = ((EquineRenderState)p_363341_).walkAnimationPos;
        if ($$3 > 0.2f) {
            $$2 += Mth.cos($$4 * 0.8f) * 0.15f * $$3;
        }
        float $$5 = ((EquineRenderState)p_363341_).eatAnimation;
        float $$6 = ((EquineRenderState)p_363341_).standAnimation;
        float $$7 = 1.0f - $$6;
        float $$8 = ((EquineRenderState)p_363341_).feedingAnimation;
        boolean $$9 = ((EquineRenderState)p_363341_).animateTail;
        this.headParts.xRot = 0.5235988f + $$2;
        this.headParts.yRot = $$1 * ((float)Math.PI / 180);
        float $$10 = ((EquineRenderState)p_363341_).isInWater ? 0.2f : 1.0f;
        float $$11 = Mth.cos($$10 * $$4 * 0.6662f + (float)Math.PI);
        float $$12 = $$11 * 0.8f * $$3;
        float $$13 = (1.0f - Math.max($$6, $$5)) * (0.5235988f + $$2 + $$8 * Mth.sin(((EquineRenderState)p_363341_).ageInTicks) * 0.05f);
        this.headParts.xRot = $$6 * (0.2617994f + $$2) + $$5 * (2.1816616f + Mth.sin(((EquineRenderState)p_363341_).ageInTicks) * 0.05f) + $$13;
        this.headParts.yRot = $$6 * $$1 * ((float)Math.PI / 180) + (1.0f - Math.max($$6, $$5)) * this.headParts.yRot;
        float $$14 = ((EquineRenderState)p_363341_).ageScale;
        this.headParts.y += Mth.lerp($$5, Mth.lerp($$6, 0.0f, -8.0f * $$14), 7.0f * $$14);
        this.headParts.z = Mth.lerp($$6, this.headParts.z, -4.0f * $$14);
        this.body.xRot = $$6 * -0.7853982f + $$7 * this.body.xRot;
        float $$15 = 0.2617994f * $$6;
        float $$16 = Mth.cos(((EquineRenderState)p_363341_).ageInTicks * 0.6f + (float)Math.PI);
        this.leftFrontLeg.y -= 12.0f * $$14 * $$6;
        this.leftFrontLeg.z += 4.0f * $$14 * $$6;
        this.rightFrontLeg.y = this.leftFrontLeg.y;
        this.rightFrontLeg.z = this.leftFrontLeg.z;
        float $$17 = (-1.0471976f + $$16) * $$6 + $$12 * $$7;
        float $$18 = (-1.0471976f - $$16) * $$6 - $$12 * $$7;
        this.leftHindLeg.xRot = $$15 - $$11 * 0.5f * $$3 * $$7;
        this.rightHindLeg.xRot = $$15 + $$11 * 0.5f * $$3 * $$7;
        this.leftFrontLeg.xRot = $$17;
        this.rightFrontLeg.xRot = $$18;
        this.tail.xRot = 0.5235988f + $$3 * 0.75f;
        this.tail.y += $$3 * $$14;
        this.tail.z += $$3 * 2.0f * $$14;
        this.tail.yRot = $$9 ? Mth.cos(((EquineRenderState)p_363341_).ageInTicks * 0.7f) : 0.0f;
    }
}

