/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SlotSelectTime;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplayId;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;

public class RecipeBookPage {
    public static final int ITEMS_PER_PAGE = 20;
    private static final WidgetSprites PAGE_FORWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/page_forward"), ResourceLocation.withDefaultNamespace("recipe_book/page_forward_highlighted"));
    private static final WidgetSprites PAGE_BACKWARD_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace("recipe_book/page_backward"), ResourceLocation.withDefaultNamespace("recipe_book/page_backward_highlighted"));
    private final List<RecipeButton> buttons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private RecipeButton hoveredButton;
    private final OverlayRecipeComponent overlay;
    private Minecraft minecraft;
    private final RecipeBookComponent<?> parent;
    private List<RecipeCollection> recipeCollections = ImmutableList.of();
    private StateSwitchingButton forwardButton;
    private StateSwitchingButton backButton;
    private int totalPages;
    private int currentPage;
    private ClientRecipeBook recipeBook;
    @Nullable
    private RecipeDisplayId lastClickedRecipe;
    @Nullable
    private RecipeCollection lastClickedRecipeCollection;
    private boolean isFiltering;

    public RecipeBookPage(RecipeBookComponent<?> p_379742_, SlotSelectTime p_364493_, boolean p_360996_) {
        this.parent = p_379742_;
        this.overlay = new OverlayRecipeComponent(p_364493_, p_360996_);
        for (int $$3 = 0; $$3 < 20; ++$$3) {
            this.buttons.add(new RecipeButton(p_364493_));
        }
    }

    public void init(Minecraft p_100429_, int p_100430_, int p_100431_) {
        this.minecraft = p_100429_;
        this.recipeBook = p_100429_.player.getRecipeBook();
        for (int $$3 = 0; $$3 < this.buttons.size(); ++$$3) {
            this.buttons.get($$3).setPosition(p_100430_ + 11 + 25 * ($$3 % 5), p_100431_ + 31 + 25 * ($$3 / 5));
        }
        this.forwardButton = new StateSwitchingButton(p_100430_ + 93, p_100431_ + 137, 12, 17, false);
        this.forwardButton.initTextureValues(PAGE_FORWARD_SPRITES);
        this.backButton = new StateSwitchingButton(p_100430_ + 38, p_100431_ + 137, 12, 17, true);
        this.backButton.initTextureValues(PAGE_BACKWARD_SPRITES);
    }

    public void updateCollections(List<RecipeCollection> p_100437_, boolean p_100438_, boolean p_363556_) {
        this.recipeCollections = p_100437_;
        this.isFiltering = p_363556_;
        this.totalPages = (int)Math.ceil((double)p_100437_.size() / 20.0);
        if (this.totalPages <= this.currentPage || p_100438_) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    private void updateButtonsForPage() {
        int $$0 = 20 * this.currentPage;
        ContextMap $$1 = SlotDisplayContext.fromLevel(this.minecraft.level);
        for (int $$2 = 0; $$2 < this.buttons.size(); ++$$2) {
            RecipeButton $$3 = this.buttons.get($$2);
            if ($$0 + $$2 < this.recipeCollections.size()) {
                RecipeCollection $$4 = this.recipeCollections.get($$0 + $$2);
                $$3.init($$4, this.isFiltering, this, $$1);
                $$3.visible = true;
                continue;
            }
            $$3.visible = false;
        }
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        this.forwardButton.visible = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.visible = this.totalPages > 1 && this.currentPage > 0;
    }

    public void render(GuiGraphics p_281416_, int p_281888_, int p_281904_, int p_282278_, int p_282424_, float p_281712_) {
        if (this.totalPages > 1) {
            MutableComponent $$6 = Component.translatable("gui.recipebook.page", this.currentPage + 1, this.totalPages);
            int $$7 = this.minecraft.font.width($$6);
            p_281416_.drawString(this.minecraft.font, $$6, p_281888_ - $$7 / 2 + 73, p_281904_ + 141, -1);
        }
        this.hoveredButton = null;
        for (RecipeButton $$8 : this.buttons) {
            $$8.render(p_281416_, p_282278_, p_282424_, p_281712_);
            if (!$$8.visible || !$$8.isHoveredOrFocused()) continue;
            this.hoveredButton = $$8;
        }
        this.backButton.render(p_281416_, p_282278_, p_282424_, p_281712_);
        this.forwardButton.render(p_281416_, p_282278_, p_282424_, p_281712_);
        p_281416_.nextStratum();
        this.overlay.render(p_281416_, p_282278_, p_282424_, p_281712_);
    }

    public void renderTooltip(GuiGraphics p_283690_, int p_282626_, int p_282490_) {
        if (this.minecraft.screen != null && this.hoveredButton != null && !this.overlay.isVisible()) {
            ItemStack $$3 = this.hoveredButton.getDisplayStack();
            ResourceLocation $$4 = $$3.get(DataComponents.TOOLTIP_STYLE);
            p_283690_.setComponentTooltipForNextFrame(this.minecraft.font, this.hoveredButton.getTooltipText($$3), p_282626_, p_282490_, $$4);
        }
    }

    @Nullable
    public RecipeDisplayId getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public RecipeCollection getLastClickedRecipeCollection() {
        return this.lastClickedRecipeCollection;
    }

    public void setInvisible() {
        this.overlay.setVisible(false);
    }

    public boolean mouseClicked(double p_100410_, double p_100411_, int p_100412_, int p_100413_, int p_100414_, int p_100415_, int p_100416_) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeCollection = null;
        if (this.overlay.isVisible()) {
            if (this.overlay.mouseClicked(p_100410_, p_100411_, p_100412_)) {
                this.lastClickedRecipe = this.overlay.getLastRecipeClicked();
                this.lastClickedRecipeCollection = this.overlay.getRecipeCollection();
            } else {
                this.overlay.setVisible(false);
            }
            return true;
        }
        if (this.forwardButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        ContextMap $$7 = SlotDisplayContext.fromLevel(this.minecraft.level);
        for (RecipeButton $$8 : this.buttons) {
            if (!$$8.mouseClicked(p_100410_, p_100411_, p_100412_)) continue;
            if (p_100412_ == 0) {
                this.lastClickedRecipe = $$8.getCurrentRecipe();
                this.lastClickedRecipeCollection = $$8.getCollection();
            } else if (p_100412_ == 1 && !this.overlay.isVisible() && !$$8.isOnlyOption()) {
                this.overlay.init($$8.getCollection(), $$7, this.isFiltering, $$8.getX(), $$8.getY(), p_100413_ + p_100415_ / 2, p_100414_ + 13 + p_100416_ / 2, $$8.getWidth());
            }
            return true;
        }
        return false;
    }

    public void recipeShown(RecipeDisplayId p_380247_) {
        this.parent.recipeShown(p_380247_);
    }

    public ClientRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    protected void listButtons(Consumer<AbstractWidget> p_170054_) {
        p_170054_.accept(this.forwardButton);
        p_170054_.accept(this.backButton);
        this.buttons.forEach(p_170054_);
    }
}

